/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.model.OpenIDUserRPDO;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;

public class OpenIDUserRPDAO {
    private static final Log log = LogFactory.getLog(OpenIDUserRPDAO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdate(OpenIDUserRPDO rpdo, int tenantId) {
        PreparedStatement prepStmt;
        Connection connection;
        block5: {
            OpenIDUserRPDO existingdo = this.getOpenIDUserRP(rpdo.getUserName(), rpdo.getRpUrl(), tenantId);
            connection = IdentityDatabaseUtil.getDBConnection();
            prepStmt = null;
            try {
                if (existingdo != null) {
                    prepStmt = connection.prepareStatement("UPDATE IDN_OPENID_USER_RPS SET TRUSTED_ALWAYS = ?, LAST_VISIT = ?, VISIT_COUNT = ?, DEFAULT_PROFILE_NAME = ? WHERE USER_NAME = ? AND TENANT_ID = ? AND RP_URL = ?");
                    prepStmt.setString(5, rpdo.getUserName());
                    prepStmt.setInt(6, tenantId);
                    prepStmt.setString(7, rpdo.getRpUrl());
                    prepStmt.setString(1, rpdo.isTrustedAlways() ? "TRUE" : "FALSE");
                    prepStmt.setDate(2, new java.sql.Date(new Date().getTime()));
                    prepStmt.setInt(3, existingdo.getVisitCount() + 1);
                    prepStmt.setString(4, rpdo.getDefaultProfileName());
                    prepStmt.execute();
                    connection.commit();
                    break block5;
                }
                prepStmt = connection.prepareStatement("INSERT INTO IDN_OPENID_USER_RPS (USER_NAME, TENANT_ID, RP_URL, TRUSTED_ALWAYS, LAST_VISIT, VISIT_COUNT, DEFAULT_PROFILE_NAME) VALUES (?,?,?,?,?,?,?)");
                prepStmt.setString(1, rpdo.getUserName());
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, rpdo.getRpUrl());
                prepStmt.setString(4, rpdo.isTrustedAlways() ? "TRUE" : "FALSE");
                prepStmt.setDate(5, new java.sql.Date(new Date().getTime()));
                prepStmt.setInt(6, 1);
                prepStmt.setString(7, rpdo.getDefaultProfileName());
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction(connection);
            }
            catch (SQLException e) {
                try {
                    IdentityDatabaseUtil.rollbackTransaction(connection);
                    log.error((Object)("Failed to store RP:  " + rpdo.getRpUrl() + " for user: " + rpdo.getUserName() + " Error while accessing the database"), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    IdentityDatabaseUtil.closeConnection(connection);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
            }
        }
        IdentityDatabaseUtil.closeStatement(prepStmt);
        IdentityDatabaseUtil.closeConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(OpenIDUserRPDO rpdo, int tenantId) {
        PreparedStatement prepStmt;
        Connection connection;
        block5: {
            connection = IdentityDatabaseUtil.getDBConnection();
            prepStmt = null;
            try {
                if (this.isUserRPExist(connection, rpdo, tenantId)) {
                    prepStmt = connection.prepareStatement("UPDATE IDN_OPENID_USER_RPS SET TRUSTED_ALWAYS = ?, LAST_VISIT = ?, VISIT_COUNT = ?, DEFAULT_PROFILE_NAME = ? WHERE USER_NAME = ? AND TENANT_ID = ? AND RP_URL = ?");
                    prepStmt.setString(1, rpdo.getUserName());
                    prepStmt.setInt(2, tenantId);
                    prepStmt.setString(3, rpdo.getRpUrl());
                    prepStmt.setString(4, rpdo.isTrustedAlways() ? "TRUE" : "FALSE");
                    prepStmt.setDate(5, new java.sql.Date(rpdo.getLastVisit().getTime()));
                    prepStmt.setInt(6, rpdo.getVisitCount() + 1);
                    prepStmt.setString(7, rpdo.getDefaultProfileName());
                    prepStmt.execute();
                    IdentityDatabaseUtil.commitTransaction(connection);
                    break block5;
                }
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("Failed to update RP: " + rpdo.getRpUrl() + " for user: " + rpdo.getUserName() + ". Entry does not exist in the database."));
            }
            catch (SQLException e) {
                try {
                    IdentityDatabaseUtil.rollbackTransaction(connection);
                    log.error((Object)("Failed to update RP:  " + rpdo.getRpUrl() + " for user: " + rpdo.getUserName() + " Error while accessing the database"), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    IdentityDatabaseUtil.closeConnection(connection);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
            }
        }
        IdentityDatabaseUtil.closeStatement(prepStmt);
        IdentityDatabaseUtil.closeConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(OpenIDUserRPDO opdo, int tenantId) {
        PreparedStatement prepStmt;
        Connection connection;
        block4: {
            connection = IdentityDatabaseUtil.getDBConnection();
            prepStmt = null;
            try {
                if (!this.isUserRPExist(connection, opdo, tenantId)) break block4;
                prepStmt = connection.prepareStatement("DELETE FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND TENANT_ID = ? AND RP_URL = ?");
                prepStmt.setString(1, opdo.getUserName());
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, opdo.getRpUrl());
                prepStmt.execute();
                IdentityDatabaseUtil.commitTransaction(connection);
            }
            catch (SQLException e) {
                try {
                    IdentityDatabaseUtil.rollbackTransaction(connection);
                    log.error((Object)("Failed to remove RP: " + opdo.getRpUrl() + " of user: " + opdo.getUserName()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    IdentityDatabaseUtil.closeConnection(connection);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
            }
        }
        IdentityDatabaseUtil.closeStatement(prepStmt);
        IdentityDatabaseUtil.closeConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenIDUserRPDO getOpenIDUserRP(String userName, String rpUrl, int tenantId) {
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            block5: {
                OpenIDUserRPDO openIDUserRPDO;
                connection = IdentityDatabaseUtil.getDBConnection(false);
                prepStmt = null;
                OpenIDUserRPDO rpdo = new OpenIDUserRPDO();
                rpdo.setUserName(userName);
                rpdo.setRpUrl(rpUrl);
                if (!this.isUserRPExist(connection, rpdo, tenantId)) break block5;
                prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, RP_URL, TRUSTED_ALWAYS, LAST_VISIT, VISIT_COUNT, DEFAULT_PROFILE_NAME FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND TENANT_ID = ? AND RP_URL = ?");
                prepStmt.setString(1, userName);
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, rpUrl);
                OpenIDUserRPDO openIDUserRPDO2 = openIDUserRPDO = this.buildUserRPDO(prepStmt.executeQuery(), userName);
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
                return openIDUserRPDO2;
            }
            try {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("RP: " + rpUrl + " of user: " + userName + " not found in the database"));
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Failed to load RP: " + rpUrl + " for user: " + userName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    IdentityDatabaseUtil.closeConnection(connection);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
            }
        }
        IdentityDatabaseUtil.closeStatement(prepStmt);
        IdentityDatabaseUtil.closeConnection(connection);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenIDUserRPDO[] getAllOpenIDUserRP() {
        Connection connection = IdentityDatabaseUtil.getDBConnection(false);
        PreparedStatement prepStmt = null;
        ResultSet results = null;
        OpenIDUserRPDO[] rpDOs = null;
        ArrayList<OpenIDUserRPDO> rpdos = new ArrayList<OpenIDUserRPDO>();
        try {
            prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, RP_URL, TRUSTED_ALWAYS, LAST_VISIT, VISIT_COUNT, DEFAULT_PROFILE_NAME FROM IDN_OPENID_USER_RPS ");
            results = prepStmt.executeQuery();
            while (results.next()) {
                OpenIDUserRPDO rpdo = new OpenIDUserRPDO();
                rpdo.setUserName(results.getString(1));
                rpdo.setRpUrl(results.getString(3));
                rpdo.setTrustedAlways(Boolean.parseBoolean(results.getString(4)));
                rpdo.setLastVisit(results.getDate(5));
                rpdo.setVisitCount(results.getInt(6));
                rpdo.setDefaultProfileName(results.getString(7));
                rpdos.add(rpdo);
            }
            rpDOs = new OpenIDUserRPDO[rpdos.size()];
            rpDOs = rpdos.toArray(rpDOs);
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Error while accessing the database to load RPs.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
                throw throwable;
            }
            IdentityDatabaseUtil.closeResultSet(results);
            IdentityDatabaseUtil.closeStatement(prepStmt);
            IdentityDatabaseUtil.closeConnection(connection);
        }
        IdentityDatabaseUtil.closeResultSet(results);
        IdentityDatabaseUtil.closeStatement(prepStmt);
        IdentityDatabaseUtil.closeConnection(connection);
        return rpDOs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenIDUserRPDO[] getOpenIDUserRPs(String userName, int tenantId) {
        OpenIDUserRPDO[] rpDOs;
        block6: {
            Connection connection = IdentityDatabaseUtil.getDBConnection(false);
            PreparedStatement prepStmt = null;
            ResultSet results = null;
            rpDOs = null;
            ArrayList<OpenIDUserRPDO> rpdos = new ArrayList<OpenIDUserRPDO>();
            try {
                prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, RP_URL, TRUSTED_ALWAYS, LAST_VISIT, VISIT_COUNT, DEFAULT_PROFILE_NAME FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND TENANT_ID = ?");
                prepStmt.setString(1, userName);
                prepStmt.setInt(2, tenantId);
                results = prepStmt.executeQuery();
                while (results.next()) {
                    OpenIDUserRPDO rpdo = new OpenIDUserRPDO();
                    rpdo.setUserName(results.getString(1));
                    rpdo.setRpUrl(results.getString(3));
                    rpdo.setTrustedAlways(Boolean.parseBoolean(results.getString(4)));
                    rpdo.setLastVisit(results.getDate(5));
                    rpdo.setVisitCount(results.getInt(6));
                    rpdo.setDefaultProfileName(results.getString(7));
                    rpdos.add(rpdo);
                }
                rpDOs = new OpenIDUserRPDO[rpdos.size()];
                rpDOs = rpdos.toArray(rpDOs);
                IdentityDatabaseUtil.closeResultSet(results);
            }
            catch (SQLException e) {
                log.error((Object)"Error while accessing the database to load RPs", (Throwable)e);
                break block6;
            }
            finally {
                IdentityDatabaseUtil.closeResultSet(results);
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
            }
            IdentityDatabaseUtil.closeStatement(prepStmt);
            IdentityDatabaseUtil.closeConnection(connection);
        }
        return rpDOs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOpenIDDefaultUserProfile(String userName, String rpUrl, int tenantId) {
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            block5: {
                connection = IdentityDatabaseUtil.getDBConnection(false);
                prepStmt = null;
                OpenIDUserRPDO rpdo = new OpenIDUserRPDO();
                rpdo.setUserName(userName);
                rpdo.setRpUrl(rpUrl);
                if (!this.isUserRPExist(connection, rpdo, tenantId)) break block5;
                prepStmt = connection.prepareStatement("SELECT DEFAULT_PROFILE_NAME FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND TENANT_ID = ? AND RP_URL = ?");
                prepStmt.setString(1, userName);
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, rpUrl);
                String string = prepStmt.executeQuery().getString(7);
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
                return string;
            }
            try {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("RP: " + rpUrl + " of user: " + userName + " not found in the database"));
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Failed to load RP: " + rpUrl + " for user: " + userName), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    IdentityDatabaseUtil.closeConnection(connection);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection(connection);
            }
        }
        IdentityDatabaseUtil.closeStatement(prepStmt);
        IdentityDatabaseUtil.closeConnection(connection);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserRPExist(Connection connection, OpenIDUserRPDO rpDo, int tenantId) throws SQLException {
        PreparedStatement prepStmt = null;
        ResultSet results = null;
        boolean result = false;
        try {
            prepStmt = connection.prepareStatement("SELECT * FROM IDN_OPENID_USER_RPS WHERE USER_NAME = ? AND TENANT_ID = ? AND RP_URL = ?");
            prepStmt.setString(1, rpDo.getUserName());
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, rpDo.getRpUrl());
            results = prepStmt.executeQuery();
            if (results != null && results.next()) {
                result = true;
            }
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeResultSet(results);
            IdentityDatabaseUtil.closeStatement(prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeResultSet(results);
        IdentityDatabaseUtil.closeStatement(prepStmt);
        return result;
    }

    private OpenIDUserRPDO buildUserRPDO(ResultSet results, String userName) {
        OpenIDUserRPDO rpdo = new OpenIDUserRPDO();
        try {
            if (!results.next()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RememberMe token not found for the user " + userName));
                }
                return null;
            }
            rpdo.setUserName(results.getString(1));
            rpdo.setRpUrl(results.getString(3));
            rpdo.setTrustedAlways(Boolean.parseBoolean(results.getString(4)));
            rpdo.setLastVisit(results.getDate(5));
            rpdo.setVisitCount(results.getInt(6));
            rpdo.setDefaultProfileName(results.getString(7));
        }
        catch (SQLException e) {
            log.error((Object)"Error while accessing the database", (Throwable)e);
        }
        return rpdo;
    }
}

