/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.dao.AbstractDAO;
import org.wso2.carbon.identity.core.model.OpenIDUserDO;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.user.core.UserRealm;

public class OpenIDUserDAO
extends AbstractDAO<OpenIDUserDO> {
    protected static final Log log = LogFactory.getLog(OpenIDUserDAO.class);
    private UserRealm realm;

    public OpenIDUserDAO(Registry registry, UserRealm realm) {
        this.registry = registry;
        this.realm = realm;
    }

    @Override
    protected OpenIDUserDO resourceToObject(Resource resource) {
        OpenIDUserDO openIDUserDo = new OpenIDUserDO();
        openIDUserDo.setUserName(resource.getProperty("UserID"));
        openIDUserDo.setOpenID(resource.getProperty("OpenID"));
        return openIDUserDo;
    }

    public boolean addAssociation(OpenIDUserDO openIDuserDO) {
        String path = null;
        Resource resource = null;
        Collection userResource = null;
        try {
            if (openIDuserDO == null) {
                return false;
            }
            path = "/repository/identity/OpenIDSignUp/" + this.getOpenIdModified(openIDuserDO.getOpenID());
            if (this.registry.resourceExists(path)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Already added Signed-Up for the OpenId " + openIDuserDO.getOpenID()));
                }
                return false;
            }
            resource = this.registry.newResource();
            resource.addProperty("UserID", openIDuserDO.getUserName());
            resource.addProperty("OpenID", openIDuserDO.getOpenID());
            boolean transactionStarted = Transaction.isStarted();
            try {
                if (!transactionStarted) {
                    this.registry.beginTransaction();
                }
                this.registry.put(path, resource);
                if (!this.registry.resourceExists("/users/" + openIDuserDO.getUserName())) {
                    userResource = this.registry.newCollection();
                    this.registry.put("/users/" + openIDuserDO.getUserName(), (Resource)userResource);
                }
                this.registry.addAssociation("/users/" + openIDuserDO.getUserName(), path, "identity.user.openidAssociation");
                if (!transactionStarted) {
                    this.registry.commitTransaction();
                }
            }
            catch (Exception e) {
                if (!transactionStarted) {
                    this.registry.rollbackTransaction();
                }
                if (e instanceof RegistryException) {
                    throw (RegistryException)((Object)e);
                }
                log.error((Object)"Error adding OpenID Sign-Up", (Throwable)e);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error adding OpenID Sign-Up", (Throwable)e);
        }
        return true;
    }

    public String getUserIdForAssociation(String openId) {
        try {
            if (this.registry.resourceExists("/repository/identity/OpenIDSignUp/" + this.getOpenIdModified(openId))) {
                return this.resourceToObject(this.registry.get("/repository/identity/OpenIDSignUp/" + this.getOpenIdModified(openId))).getUserName();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to find an Sign-Up for " + openId));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error retrieving a resource from Registry", (Throwable)e);
        }
        return null;
    }

    public boolean hasAssociation(String openId) {
        try {
            if (this.registry.resourceExists("/repository/identity/OpenIDSignUp/" + this.getOpenIdModified(openId))) {
                OpenIDUserDO openIDUserDo = this.resourceToObject(this.registry.get("/repository/identity/OpenIDSignUp/" + this.getOpenIdModified(openId)));
                if (this.realm.getUserStoreManager().isExistingUser(openIDUserDo.getUserName())) {
                    return true;
                }
                this.registry.delete("/repository/identity/OpenIDSignUp/" + this.getOpenIdModified(openId));
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to find an Sign-Up for " + openId));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error retrieving the resource", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error retrieving  the user information from user store", (Throwable)e);
        }
        return false;
    }

    public String[] getOpenIDsForUser(String username) {
        String[] openIDSet = new String[]{};
        Resource openIDResource = null;
        try {
            if (this.registry.resourceExists("/users/" + username)) {
                Association[] openIDAssociations = this.registry.getAssociations("/users/" + username, "identity.user.openidAssociation");
                openIDSet = new String[openIDAssociations.length];
                int i = 0;
                for (Association association : openIDAssociations) {
                    String openIDAssociation = association.getDestinationPath().trim();
                    String openID = "";
                    if (this.registry.resourceExists(openIDAssociation)) {
                        openIDResource = this.registry.get(openIDAssociation);
                        openID = openIDResource.getProperty("OpenID");
                    }
                    openIDSet[i] = openID;
                    ++i;
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error retrieving user information from registry.", (Throwable)e);
        }
        return openIDSet;
    }

    public void removeOpenIDSignUp(String openID) {
        try {
            if (this.registry.resourceExists("/repository/identity/OpenIDSignUp/" + this.getOpenIdModified(openID))) {
                this.registry.delete("/repository/identity/OpenIDSignUp/" + this.getOpenIdModified(openID));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error Removing the OpenID", (Throwable)e);
        }
    }

    private String getOpenIdModified(String openId) {
        openId = openId.trim().replace("/", "FORWARD_SLASH");
        openId = openId.replace("=", "WSO2_EQUAL_SIGN");
        return openId;
    }
}

