/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.dao.AbstractDAO;
import org.wso2.carbon.identity.core.model.OpenIDRememberMeDO;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;

public class OpenIDRememberMeDAO
extends AbstractDAO<OpenIDRememberMeDO> {
    protected static final Log log = LogFactory.getLog(OpenIDRememberMeDAO.class);

    public OpenIDRememberMeDAO(Registry registry) {
        this.registry = registry;
    }

    public void updateToken(OpenIDRememberMeDO rememberMe) throws IdentityException {
        block8: {
            Collection userResource = null;
            boolean transactionStarted = Transaction.isStarted();
            try {
                if (!this.registry.resourceExists("/users/" + rememberMe.getUserName())) {
                    userResource = this.registry.newCollection();
                    this.registry.put("/users/" + rememberMe.getUserName(), (Resource)userResource);
                } else {
                    userResource = (Collection)this.registry.get("/users/" + rememberMe.getUserName());
                }
                if (!transactionStarted) {
                    this.registry.beginTransaction();
                }
                userResource.removeProperty("OpenIDRememberMeToken");
                userResource.addProperty("OpenIDRememberMeToken", rememberMe.getToken());
                this.registry.put("/users/" + rememberMe.getUserName(), (Resource)userResource);
                if (!transactionStarted) {
                    this.registry.commitTransaction();
                }
            }
            catch (Exception ex) {
                if (transactionStarted) break block8;
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException e) {
                    log.error((Object)"Error occured while updating OpenID remember me token", (Throwable)e);
                    throw IdentityException.error((String)"Error occured while updating OpenID remember me token", (Throwable)e);
                }
            }
        }
    }

    public String getToken(OpenIDRememberMeDO rememberMe) throws IdentityException {
        Collection userResource = null;
        String value = null;
        try {
            if (!this.registry.resourceExists("/users/" + rememberMe.getUserName())) {
                return null;
            }
            userResource = (Collection)this.registry.get("/users/" + rememberMe.getUserName());
            value = userResource.getProperty("OpenIDRememberMeToken");
        }
        catch (Exception e) {
            log.error((Object)"Error occured while updating OpenID remember me token", (Throwable)e);
            throw IdentityException.error((String)"Error occured while updating OpenID remember me token", (Throwable)e);
        }
        return value;
    }

    @Override
    protected OpenIDRememberMeDO resourceToObject(Resource resource) {
        return null;
    }
}

