/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.dao.AbstractDAO;
import org.wso2.carbon.identity.core.model.OpenIDAdminDO;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class OpenIDAdminDAO
extends AbstractDAO<OpenIDAdminDO> {
    protected static final Log log = LogFactory.getLog(OpenIDAdminDAO.class);

    public OpenIDAdminDAO(Registry registry) {
        this.registry = registry;
    }

    public void createOrUpdate(OpenIDAdminDO opAdmin) throws IdentityException {
        String path = null;
        Resource resource = null;
        try {
            path = "/repository/identity/OpenIDSettings/";
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Creating new openid admin");
                }
                resource = this.registry.newResource();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Updating openid admin");
                }
                resource = this.registry.get(path);
                resource.removeProperty("SubDomain");
                resource.removeProperty("OpenIDPattern");
            }
            resource.addProperty("SubDomain", opAdmin.getSubDomain());
            resource.addProperty("OpenIDPattern", opAdmin.getTenantOpenIDPattern());
            this.registry.put(path, resource);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while creating/updating openid admin", (Throwable)e);
            throw IdentityException.error((String)"Error while creating/updating openid admin", (Throwable)e);
        }
    }

    public OpenIDAdminDO getOpenIDAdminDO() throws IdentityException {
        OpenIDAdminDO opdo = null;
        Resource resource = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving OpenID admin for tenant");
        }
        try {
            if (this.registry.resourceExists("/repository/identity/OpenIDSettings/")) {
                resource = this.registry.get("/repository/identity/OpenIDSettings/");
                return this.resourceToObject(resource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retreiving openid admin", (Throwable)e);
            throw IdentityException.error((String)"Error while retreiving openid admin", (Throwable)e);
        }
        return opdo;
    }

    @Override
    protected OpenIDAdminDO resourceToObject(Resource resource) {
        OpenIDAdminDO opdo = null;
        if (resource != null) {
            opdo = new OpenIDAdminDO();
            String subDomain = resource.getProperty("SubDomain");
            String openIDPattern = resource.getProperty("OpenIDPattern");
            opdo.setSubDomain(subDomain);
            opdo.setTenantOpenIDPattern(openIDPattern);
        }
        return opdo;
    }
}

