/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.dao.AbstractDAO;
import org.wso2.carbon.identity.core.model.OAuthConsumerDO;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;

public class OAuthConsumerDAO
extends AbstractDAO<OAuthConsumerDO> {
    protected static final Log log = LogFactory.getLog(OAuthConsumerDAO.class);

    public OAuthConsumerDAO(Registry registry) {
        this.registry = registry;
    }

    public void registerOAuthConsumer(OAuthConsumerDO consumer) throws IdentityException {
        Collection userResource = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating or updating OAuth consumer value");
        }
        try {
            boolean transactionStarted = Transaction.isStarted();
            try {
                if (!transactionStarted) {
                    this.registry.beginTransaction();
                }
                if (!this.registry.resourceExists("/users/" + consumer.getConsumerKey())) {
                    userResource = this.registry.newCollection();
                    this.registry.put("/users/" + consumer.getConsumerKey(), (Resource)userResource);
                } else {
                    userResource = (Collection)this.registry.get("/users/" + consumer.getConsumerKey());
                    userResource.removeProperty("/repository/identity/OAuthConsumer/");
                }
                userResource.addProperty("/repository/identity/OAuthConsumer/", consumer.getConsumerSecret());
                this.registry.put("/users/" + consumer.getConsumerKey(), (Resource)userResource);
                if (!transactionStarted) {
                    this.registry.commitTransaction();
                }
            }
            catch (Exception e) {
                if (!transactionStarted) {
                    this.registry.rollbackTransaction();
                }
                if (e instanceof RegistryException) {
                    throw (RegistryException)((Object)e);
                }
                throw IdentityException.error((String)"Error while creating or updating OAuth consumer", (Throwable)e);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while creating or updating OAuth consumer", (Throwable)e);
            throw IdentityException.error((String)"Error while creating or updating OAuth consumer", (Throwable)e);
        }
    }

    public String getOAuthConsumerSecret(String consumerKey) throws IdentityException {
        String path = null;
        Resource resource = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retreiving user for OAuth consumer key  " + consumerKey));
        }
        try {
            path = "/users/" + consumerKey;
            if (this.registry.resourceExists(path)) {
                resource = this.registry.get(path);
                return resource.getProperty("/repository/identity/OAuthConsumer/");
            }
            return null;
        }
        catch (RegistryException e) {
            log.error((Object)("Error while retreiving user for OAuth consumer key  " + consumerKey), (Throwable)e);
            throw IdentityException.error((String)("Error while retreiving user for OAuth consumer key  " + consumerKey), (Throwable)e);
        }
    }

    @Override
    protected OAuthConsumerDO resourceToObject(Resource resource) {
        return null;
    }
}

