/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public abstract class AbstractDAO<T> {
    private static final String SQL_GET_ALL_BY_PROP = "SELECT REG_PATH FROM REG_RESOURCE RR, REG_PROPERTY RP WHERE RR.REG_RID=RP.REG_RID AND RP.REG_NAME=? AND RP.REG_PROPERTY_VALUE=?";
    private static final String CUSTOM_QUERY_PATH = "/repository/identity/CustomQueries/";
    private static final String CUSTOM_QUERY_GET_ALL_BY_PROP = "/repository/identity/CustomQueries/GetByProp";
    private static Log log = LogFactory.getLog(AbstractDAO.class);
    protected Registry registry = null;

    public List<T> getAllObjects(String path) throws IdentityException {
        ArrayList<T> list = null;
        Collection collection = null;
        String[] children = null;
        if (log.isErrorEnabled()) {
            log.debug((Object)("Retrieving all objects from the registry path " + path));
        }
        try {
            list = new ArrayList<T>();
            if (!this.registry.resourceExists(path)) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)("Required resource does bot exist in the registry path " + path));
                }
                return list;
            }
            collection = (Collection)this.registry.get(path);
            for (String child : children = collection.getChildren()) {
                Resource resource = null;
                resource = this.registry.get(child);
                T obj = this.resourceToObject(resource);
                list.add(obj);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving all objects from the registry path", (Throwable)e);
            throw IdentityException.error((String)"Error while retrieving all objects from the registry path", (Throwable)e);
        }
        return list;
    }

    public List<T> getAllObjectsWithPropertyValue(String path, String propName, String value) throws IdentityException {
        Resource query = null;
        ArrayList<T> retList = null;
        HashMap<String, String> params = null;
        Collection result = null;
        String[] paths = null;
        Resource resource = null;
        if (log.isErrorEnabled()) {
            log.debug((Object)("Retrieving all objects from the registry path with property values " + path));
        }
        try {
            retList = new ArrayList<T>();
            if (!this.registry.resourceExists(CUSTOM_QUERY_GET_ALL_BY_PROP)) {
                query = this.registry.newResource();
                query.setContent((Object)SQL_GET_ALL_BY_PROP);
                query.setMediaType("application/vnd.sql.query");
                query.addProperty("resultType", "Resource");
                this.registry.put(CUSTOM_QUERY_GET_ALL_BY_PROP, query);
            }
            params = new HashMap<String, String>();
            params.put("1", propName);
            params.put("2", value);
            result = this.registry.executeQuery(CUSTOM_QUERY_GET_ALL_BY_PROP, params);
            for (String prop : paths = (String[])result.getContent()) {
                resource = this.registry.get(prop);
                retList.add(this.resourceToObject(resource));
            }
        }
        catch (RegistryException e) {
            String message = "Error while retrieving all objects from the registry path  with property values";
            log.error((Object)message, (Throwable)e);
            throw IdentityException.error((String)message, (Throwable)e);
        }
        return retList;
    }

    public T getFirstObjectWithPropertyValue(String path, String propName, String value) throws IdentityException {
        Resource resource = null;
        HashMap<String, String> params = null;
        Collection result = null;
        String[] paths = null;
        try {
            if (log.isErrorEnabled()) {
                log.debug((Object)("Retrieving first object from the registry path with property value " + path));
            }
            params = new HashMap<String, String>();
            params.put("1", propName);
            params.put("2", value);
            result = this.registry.executeQuery(this.getCustomQuery(), params);
            paths = (String[])result.getContent();
            if (paths != null && paths.length > 0) {
                resource = this.registry.get(paths[0]);
            }
        }
        catch (RegistryException e) {
            String message = "Error while retrieving first object from the registry path with property value";
            log.error((Object)message, (Throwable)e);
            throw IdentityException.error((String)message, (Throwable)e);
        }
        return this.resourceToObject(resource);
    }

    protected abstract T resourceToObject(Resource var1);

    private String getCustomQuery() {
        if (StaticConfiguration.isVersioningProperties()) {
            return "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R , REG_PROPERTY PP, REG_RESOURCE_PROPERTY RPR.REG_VERSION=RP.REG_VERSION ANDRP.REG_PROPERTY_ID=PP.REG_ID AND PP.REG_NAME=? AND PP.REG_VALUE LIKE ?";
        }
        return "SELECT R.REG_PATH_ID, R.REG_NAME FROM REG_RESOURCE R , REG_PROPERTY PP, REG_RESOURCE_PROPERTY RP((R.REG_PATH_ID=RP.REG_PATH_ID AND R.REG_NAME = RP.REG_RESOURCE_NAME ) OR(R.REG_PATH_ID=RP.REG_PATH_ID AND R.REG_NAME IS NULL AND RP.REG_RESOURCE_NAME IS NULL)) ANDRP.REG_PROPERTY_ID=PP.REG_ID AND PP.REG_NAME=? AND PP.REG_VALUE LIKE ?";
    }
}

