/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core.bean.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.wso2.carbon.identity.base.IdentityRuntimeException;

public abstract class MessageContext<T1, T2>
implements Serializable {
    protected Map<T1, T2> parameters = new HashMap<T1, T2>();

    public MessageContext(Map<T1, T2> parameters) {
        if (MapUtils.isNotEmpty(parameters)) {
            this.parameters = parameters;
        }
    }

    public MessageContext() {
    }

    public void addParameter(T1 key, T2 value) {
        if (this.parameters.containsKey(key)) {
            throw IdentityRuntimeException.error((String)("Parameters map trying to override existing key " + key));
        }
        this.parameters.put(key, value);
    }

    public void addParameters(Map<T1, T2> parameters) {
        for (Map.Entry<T1, T2> parameter : parameters.entrySet()) {
            if (this.parameters.containsKey(parameter.getKey())) {
                throw IdentityRuntimeException.error((String)("Parameters map trying to override existing key " + parameter.getKey()));
            }
            parameters.put(parameter.getKey(), parameter.getValue());
        }
    }

    public Map<T1, T2> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public T2 getParameter(T1 key) {
        return this.parameters.get(key);
    }
}

