/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.core.CertificateRetriever;
import org.wso2.carbon.identity.core.CertificateRetrievingException;
import org.wso2.carbon.user.api.Tenant;

public class KeyStoreCertificateRetriever
implements CertificateRetriever {
    @Override
    public X509Certificate getCertificate(String certificateId, Tenant tenant) throws CertificateRetrievingException {
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenant.getId());
        try {
            KeyStore keyStore = tenant.getId() != -1234 ? keyStoreManager.getKeyStore(this.getKeyStoreName(tenant.getDomain())) : keyStoreManager.getPrimaryKeyStore();
            X509Certificate certificate = (X509Certificate)keyStore.getCertificate(certificateId);
            return certificate;
        }
        catch (Exception e) {
            String errorMsg = String.format("Error occurred while retrieving the certificate for the alias '%s' of the tenant domain '%s'." + certificateId, tenant.getDomain());
            throw new CertificateRetrievingException(errorMsg, e);
        }
    }

    private String getKeyStoreName(String tenantDomain) {
        String keyStoreName = tenantDomain.trim().replace(".", "-");
        return keyStoreName + ".jks";
    }
}

