/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.user.core.UserRealm;

public class IdentityProfileManager {
    private static Log log = LogFactory.getLog(IdentityClaimManager.class);
    private static IdentityProfileManager profileManager;
    private static Object lock;
    private UserRealm realm;

    private IdentityProfileManager() throws IdentityException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IdentityProfileManager getInstance() throws IdentityException {
        if (profileManager == null) {
            Object object = lock;
            synchronized (object) {
                if (profileManager == null) {
                    profileManager = new IdentityProfileManager();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"IdentityClaimManager singleton instance created successfully");
                    }
                }
            }
        }
        return profileManager;
    }

    public UserRealm getRealm() {
        return this.realm;
    }

    public void setRealm(UserRealm realm) {
        this.realm = realm;
        if (log.isDebugEnabled() && realm != null) {
            log.debug((Object)("IdentityProfileManager UserRealm set successfully: " + realm.getClass().getName()));
        }
    }

    static {
        lock = new Object();
    }
}

