/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;

public class IdentityClaimManager {
    private static Log log = LogFactory.getLog(IdentityClaimManager.class);
    private static IdentityClaimManager claimManager;
    private static Object lock;

    private IdentityClaimManager() throws IdentityException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IdentityClaimManager getInstance() throws IdentityException {
        if (claimManager == null) {
            Object object = lock;
            synchronized (object) {
                if (claimManager == null) {
                    claimManager = new IdentityClaimManager();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"IdentityClaimManager singleton instance created successfully");
                    }
                }
            }
        }
        return claimManager;
    }

    public Claim[] getAllSupportedClaims(UserRealm realm) throws IdentityException {
        try {
            ClaimManager claimAdmin = realm.getClaimManager();
            ClaimMapping[] mappings = claimAdmin.getAllSupportClaimMappingsByDefault();
            Claim[] claims = new Claim[]{};
            if (mappings != null) {
                claims = new Claim[mappings.length];
                for (int i = 0; i < mappings.length; ++i) {
                    claims[i] = (Claim)mappings[i].getClaim();
                }
            }
            return claims;
        }
        catch (UserStoreException e) {
            log.error((Object)"Error occurred while loading supported claims", (Throwable)e);
            this.getException("Error occurred while loading supported claima", (Exception)((Object)e));
            return new Claim[0];
        }
    }

    public Claim[] getAllSupportedClaims(String dialectUri, UserRealm realm) throws IdentityException {
        ArrayList<Claim> requiredClaims = new ArrayList<Claim>();
        try {
            ClaimManager claimAdmin = realm.getClaimManager();
            ClaimMapping[] mappings = claimAdmin.getAllClaimMappings(dialectUri);
            if (mappings != null) {
                for (int i = 0; i < mappings.length; ++i) {
                    if (!mappings[i].getClaim().isSupportedByDefault()) continue;
                    requiredClaims.add((Claim)mappings[i].getClaim());
                }
            }
        }
        catch (UserStoreException e) {
            log.error((Object)("Error occurred while loading supported claims from the dialect " + dialectUri), (Throwable)e);
            this.getException("Error occurred while loading supported claims from the dialect " + dialectUri, (Exception)((Object)e));
        }
        return requiredClaims.toArray(new Claim[requiredClaims.size()]);
    }

    private void getException(String message, Exception e) throws IdentityException {
        log.error((Object)message, (Throwable)e);
        throw IdentityException.error((String)message, (Throwable)e);
    }

    static {
        lock = new Object();
    }
}

