/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.CertificateRetriever;
import org.wso2.carbon.identity.core.CertificateRetrievingException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.api.Tenant;

public class DatabaseCertificateRetriever
implements CertificateRetriever {
    private static final Log log = LogFactory.getLog(DatabaseCertificateRetriever.class);
    private static String QUERY_TO_GET_APPLICATION_CERTIFICATE = "SELECT CERTIFICATE_IN_PEM FROM IDN_CERTIFICATE WHERE ID = ?";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public X509Certificate getCertificate(String certificateId, Tenant tenant) throws CertificateRetrievingException {
        ResultSet queryResults;
        PreparedStatement statementToGetApplicationCertificate;
        Connection connection;
        block9: {
            X509Certificate x509Certificate;
            try {
                connection = IdentityDatabaseUtil.getDBConnection(false);
            }
            catch (IdentityRuntimeException e) {
                throw new CertificateRetrievingException("Couldn't get a database connection.", (Exception)((Object)e));
            }
            statementToGetApplicationCertificate = null;
            queryResults = null;
            try {
                statementToGetApplicationCertificate = connection.prepareStatement(QUERY_TO_GET_APPLICATION_CERTIFICATE);
                statementToGetApplicationCertificate.setInt(1, Integer.parseInt(certificateId));
                queryResults = statementToGetApplicationCertificate.executeQuery();
                String certificateContent = null;
                while (queryResults.next()) {
                    certificateContent = this.getBlobValue(queryResults.getBinaryStream(1));
                }
                if (!StringUtils.isNotBlank(certificateContent)) break block9;
                x509Certificate = (X509Certificate)IdentityUtil.convertPEMEncodedContentToCertificate(certificateContent);
            }
            catch (SQLException e) {
                try {
                    String errorMessage = String.format("An error occurred while retrieving the certificate content from the database for the ID '%s'", certificateId);
                    throw new CertificateRetrievingException(errorMessage, e);
                    catch (CertificateException e2) {
                        errorMessage = String.format("An error occurred while build a certificate using the certificate content from the database for the ID '%s'", certificateId);
                        throw new CertificateRetrievingException(errorMessage, e2);
                    }
                    catch (IOException e3) {
                        errorMessage = String.format("An error occurred while reading the certificate blob from the database for the ID '%s'", certificateId);
                        throw new CertificateRetrievingException(errorMessage, e3);
                    }
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections(connection, queryResults, statementToGetApplicationCertificate);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections(connection, queryResults, statementToGetApplicationCertificate);
            return x509Certificate;
        }
        IdentityDatabaseUtil.closeAllConnections(connection, queryResults, statementToGetApplicationCertificate);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBlobValue(InputStream is) throws IOException {
        if (is != null) {
            BufferedReader br = null;
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error in retrieving the Blob value", (Throwable)e);
                    }
                }
            }
            return sb.toString();
        }
        return null;
    }
}

