/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.cluster.mgt.internal.managementBeans;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.wso2.carbon.andes.cluster.mgt.internal.ClusterMgtException;

public class ClusterManagementBeans {
    public boolean isClusteringEnabled() throws ClusterMgtException {
        boolean isClustered = false;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "ClusteringEnabled");
            if (result != null) {
                isClustered = (Boolean)result;
            }
            return isClustered;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
        catch (AttributeNotFoundException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
    }

    public String getMyNodeID() throws ClusterMgtException {
        String myNodeID = "";
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "MyNodeID");
            if (result != null) {
                myNodeID = (String)result;
            }
            return myNodeID;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
        catch (AttributeNotFoundException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot access cluster information", e);
        }
    }

    public String getCoordinatorNodeAddress() throws ClusterMgtException {
        String coordinatorNodeAddress = "";
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "CoordinatorNodeAddress");
            if (result != null) {
                coordinatorNodeAddress = (String)result;
            }
            return coordinatorNodeAddress;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot get coordinator node address. Check if clustering is enabled.", e);
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot get coordinator node address. Check if clustering is enabled.", e);
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot get coordinator node address. Check if clustering is enabled.", e);
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot get coordinator node address. Check if clustering is enabled.", e);
        }
        catch (AttributeNotFoundException e) {
            throw new ClusterMgtException("Cannot get coordinator node address. Check if clustering is enabled.", e);
        }
    }

    public List<String> getAllClusterNodeAddresses() throws ClusterMgtException {
        List<String> allClusterNodeAddresses = new ArrayList<String>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "AllClusterNodeAddresses");
            if (result != null) {
                allClusterNodeAddresses = (List)result;
            }
            return allClusterNodeAddresses;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot get cluster node addresses. Check if clustering is enabled.", e);
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot get cluster node addresses. Check if clustering is enabled.", e);
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot get cluster node addresses. Check if clustering is enabled.", e);
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot get cluster node addresses. Check if clustering is enabled.", e);
        }
        catch (AttributeNotFoundException e) {
            throw new ClusterMgtException("Cannot get cluster node addresses. Check if clustering is enabled.", e);
        }
    }

    public boolean getStoreHealth() throws ClusterMgtException {
        boolean storeHealth = false;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=ClusterManagementInformation,name=ClusterManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "StoreHealth");
            if (result != null) {
                storeHealth = (Boolean)result;
            }
            return storeHealth;
        }
        catch (MalformedObjectNameException e) {
            throw new ClusterMgtException("Cannot get message store health.", e);
        }
        catch (ReflectionException e) {
            throw new ClusterMgtException("Cannot get message store health.", e);
        }
        catch (MBeanException e) {
            throw new ClusterMgtException("Cannot get message store health.", e);
        }
        catch (InstanceNotFoundException e) {
            throw new ClusterMgtException("Cannot get message store health.", e);
        }
        catch (AttributeNotFoundException e) {
            throw new ClusterMgtException("Cannot get message store health.", e);
        }
    }
}

