/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.directory.server.manager.ui;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.directory.common.stub.types.ServerPrinciple;
import org.wso2.carbon.directory.server.manager.stub.DirectoryServerManagerDirectoryServerManagerExceptionException;
import org.wso2.carbon.directory.server.manager.stub.DirectoryServerManagerStub;
import org.wso2.carbon.directory.server.manager.ui.ServerManagerClientException;

public class DirectoryServerManagerClient {
    public static final String SERVER_MANAGER_CLIENT = "org.wso2.carbon.directory.server.manager";
    private static final Log log = LogFactory.getLog(DirectoryServerManagerClient.class);
    private static final String SERVER_MANAGER_SERVICE = "DirectoryServerManager";
    protected DirectoryServerManagerStub stub = null;
    private String passwordRegularExpression;
    private String serviceNameRegularExpression;

    public DirectoryServerManagerClient(String cookie, String url, ConfigurationContext configContext) throws ServerManagerClientException {
        try {
            this.stub = new DirectoryServerManagerStub(configContext, url + SERVER_MANAGER_SERVICE);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault e) {
            log.error((Object)"Unable to instantiate DirectoryServerManagerClient.", (Throwable)e);
            throw new ServerManagerClientException("service.principle.init.error", e);
        }
    }

    public void addServicePrinciple(String serverName, String serverDescription, String password) throws ServerManagerClientException {
        try {
            if (this.stub.isExistingServicePrinciple(serverName)) {
                log.error((Object)"Error adding service principle. Service name already exists.");
                throw new ServerManagerClientException("service.principle.exists");
            }
            this.stub.addServer(serverName, serverDescription, password);
        }
        catch (RemoteException e) {
            StringBuilder stb = new StringBuilder();
            stb.append("Server Name - ").append(serverName).append(" Description - ").append(serverDescription);
            log.error((Object)("Error adding service principle. Could not reach back-end service. " + stb.toString()), (Throwable)e);
            throw new ServerManagerClientException("service.principle.add.error", e);
        }
        catch (DirectoryServerManagerDirectoryServerManagerExceptionException e) {
            StringBuilder stb = new StringBuilder();
            stb.append("Server Name - ").append(serverName).append(" Description - ").append(serverDescription);
            log.error((Object)("An error occurred while adding a service principle. " + stb.toString()), (Throwable)e);
            throw new ServerManagerClientException("service.principle.add.error", e);
        }
    }

    public ServerPrinciple[] listServicePrinciples(String filter) throws ServerManagerClientException {
        try {
            ServerPrinciple[] principles = this.stub.listServicePrinciples(filter);
            if (principles == null) {
                return new ServerPrinciple[0];
            }
            return principles;
        }
        catch (RemoteException e) {
            log.error((Object)("Error listing service principles. Could not reach back-end service. Filter - " + filter), (Throwable)e);
            throw new ServerManagerClientException("service.principle.list.error", e);
        }
        catch (DirectoryServerManagerDirectoryServerManagerExceptionException e) {
            log.error((Object)("An error occurred while listing service principles. Filter - " + filter), (Throwable)e);
            throw new ServerManagerClientException("service.principle.list.error", e);
        }
    }

    public void updatePassword(String servicePrinciple, String oldPassword, String newPassword) throws ServerManagerClientException {
        try {
            this.stub.changePassword(servicePrinciple, oldPassword, newPassword);
        }
        catch (RemoteException e) {
            log.error((Object)("Could not reach back-end service. Error updating password for service principle - " + servicePrinciple), (Throwable)e);
            throw new ServerManagerClientException("service.principle.change.error", e);
        }
        catch (DirectoryServerManagerDirectoryServerManagerExceptionException e) {
            log.error((Object)("An error occurred while updating service principle's password. Service principle - " + servicePrinciple), (Throwable)e);
            throw new ServerManagerClientException("service.principle.change.error", e);
        }
    }

    public void removeServicePrinciple(String servicePrinciple) throws ServerManagerClientException {
        try {
            this.stub.removeServer(servicePrinciple);
        }
        catch (RemoteException e) {
            log.error((Object)("Could not reach back-end service. Error deleting service principle - " + servicePrinciple), (Throwable)e);
            throw new ServerManagerClientException("service.principle.remove.error", e);
        }
        catch (DirectoryServerManagerDirectoryServerManagerExceptionException e) {
            log.error((Object)("An error occurred while deleting service principle - " + servicePrinciple), (Throwable)e);
            throw new ServerManagerClientException("service.principle.remove.error", e);
        }
    }

    public String getPasswordConformanceRegularExpression() throws ServerManagerClientException {
        if (this.passwordRegularExpression != null) {
            return this.passwordRegularExpression;
        }
        try {
            this.passwordRegularExpression = this.stub.getPasswordConformanceRegularExpression();
            return this.passwordRegularExpression;
        }
        catch (RemoteException e) {
            log.error((Object)"Could not reach back-end service. Error retrieving password format. ", (Throwable)e);
            throw new ServerManagerClientException("password.format.get.error", e);
        }
        catch (DirectoryServerManagerDirectoryServerManagerExceptionException e) {
            log.error((Object)"An error occurred while retrieving password format.", (Throwable)e);
            throw new ServerManagerClientException("password.format.get.error", e);
        }
    }

    public String getServiceNameConformanceRegularExpression() throws ServerManagerClientException {
        if (this.serviceNameRegularExpression != null) {
            return this.serviceNameRegularExpression;
        }
        try {
            this.serviceNameRegularExpression = this.stub.getServiceNameConformanceRegularExpression();
            return this.serviceNameRegularExpression;
        }
        catch (RemoteException e) {
            log.error((Object)"Could not reach back-end service. Error retrieving service name format. ", (Throwable)e);
            throw new ServerManagerClientException("name.format.get.error", e);
        }
        catch (DirectoryServerManagerDirectoryServerManagerExceptionException e) {
            log.error((Object)"An error occurred while retrieving service name format.", (Throwable)e);
            throw new ServerManagerClientException("name.format.get.error", e);
        }
    }

    public boolean isKDCEnabled() {
        try {
            return this.stub.isKDCEnabled();
        }
        catch (RemoteException e) {
            log.error((Object)"Could not reach back-end service. Error checking whether KDC is enabled. ", (Throwable)e);
        }
        catch (DirectoryServerManagerDirectoryServerManagerExceptionException e) {
            log.error((Object)"An error occurred while checking whether KDC is enabled.", (Throwable)e);
        }
        return false;
    }
}

