/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.logs.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.report.ReportAppender;
import org.wso2.carbon.privacy.forgetme.api.user.UserIdentifier;
import org.wso2.carbon.privacy.forgetme.logs.beans.Patterns;
import org.wso2.carbon.privacy.forgetme.logs.exception.LogProcessorException;

public class LogFileProcessor {
    private static Logger log = LoggerFactory.getLogger(LogFileProcessor.class);
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String TEMP_FILE_PREFIX = "anon-";

    public void processFiles(UserIdentifier userIdentifier, ReportAppender reportAppender, List<Patterns.Pattern> patternList, List<File> fileList) throws LogProcessorException {
        Map<String, String> templatePatternData = this.getTemplatePatternData(userIdentifier);
        List<MatchAndReplace> compiledPatterns = this.compile(patternList, templatePatternData);
        for (File file : fileList) {
            reportAppender.appendSection("Starting File %s", new Object[]{file.getAbsolutePath()});
            if (log.isDebugEnabled()) {
                log.debug("Reading log file {}.", (Object)file.getName());
            }
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), ENCODING);
                 LineNumberReader lineReader = new LineNumberReader(reader);
                 BufferedWriter writer = new BufferedWriter(new FileWriter(Paths.get(file.getParent(), TEMP_FILE_PREFIX + System.currentTimeMillis() + "-" + file.getName()).toString()));){
                String line;
                while ((line = lineReader.readLine()) != null) {
                    String replacement = line;
                    boolean patternMatched = false;
                    for (MatchAndReplace matchAndReplace : compiledPatterns) {
                        Matcher matcher = matchAndReplace.getPattern().matcher(replacement);
                        if (!matcher.find()) continue;
                        patternMatched = true;
                        String formattedReplacePattern = StrSubstitutor.replace((Object)matchAndReplace.getReplacePattern(), templatePatternData);
                        if (StringUtils.isNotBlank((CharSequence)formattedReplacePattern)) {
                            replacement = replacement.replaceAll(formattedReplacePattern, userIdentifier.getPseudonym());
                            reportAppender.append("Replaced, %d, %b", new Object[]{lineReader.getLineNumber(), true});
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Replaced {}", (Object)lineReader.getLineNumber());
                            continue;
                        }
                        reportAppender.append("Not Replaced, %d, %b", new Object[]{lineReader.getLineNumber(), true});
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Not replaced {}", (Object)lineReader.getLineNumber());
                    }
                    if (patternMatched) {
                        writer.write(replacement + '\n');
                        continue;
                    }
                    writer.write(line + '\n');
                }
            }
            catch (IOException ex) {
                log.error("Error occurred while file read/write operation.", (Throwable)ex);
                throw new LogProcessorException(ex);
            }
            catch (Exception ex) {
                throw new LogProcessorException("Error occurred while processing log file.", ex);
            }
            log.info("Completed scanning log file: {}", (Object)file);
            reportAppender.appendSectionEnd("Completed " + file, new Object[0]);
        }
    }

    private List<MatchAndReplace> compile(List<Patterns.Pattern> patternList, Map<String, String> templatePatternData) {
        ArrayList<MatchAndReplace> result = new ArrayList<MatchAndReplace>(patternList.size());
        for (Patterns.Pattern pattern : patternList) {
            if (log.isDebugEnabled()) {
                log.debug("Compiling pattern {}.", (Object)pattern.getKey());
            }
            String formattedDetectPattern = StrSubstitutor.replace((Object)pattern.getDetectPattern(), templatePatternData).trim();
            Pattern regexp = Pattern.compile(formattedDetectPattern);
            result.add(new MatchAndReplace(regexp, pattern.getReplacePattern()));
        }
        return result;
    }

    private static void replaceFile(Path filePath) throws LogProcessorException {
        String fileName = filePath.getFileName().toString();
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                log.info("Deleting File From The Configured Path: " + filePath.toString());
                Files.delete(filePath);
                Path tempFilePath = Paths.get(filePath + TEMP_FILE_PREFIX, new String[0]);
                Files.move(tempFilePath, tempFilePath.resolveSibling(fileName), new CopyOption[0]);
                log.info("Renamed the temp file '" + fileName + ".temp' to '" + fileName + "'");
            }
            catch (IOException ex) {
                throw new LogProcessorException("Error occurred while delete/rename file operation.", ex);
            }
        }
    }

    private Map<String, String> getTemplatePatternData(UserIdentifier userIdentifier) {
        HashMap<String, String> patternData = new HashMap<String, String>();
        patternData.put("username", userIdentifier.getUsername());
        patternData.put("tenantDomain", userIdentifier.getTenantDomain());
        patternData.put("tenantId", String.valueOf(userIdentifier.getTenantId()));
        if (StringUtils.equalsIgnoreCase((CharSequence)"PRIMARY", (CharSequence)userIdentifier.getUserStoreDomain())) {
            patternData.put("userstoreDomain", "");
        } else {
            patternData.put("userstoreDomain", StringUtils.capitalize((String)userIdentifier.getUserStoreDomain()));
        }
        return patternData;
    }

    private static class MatchAndReplace {
        private Pattern pattern;
        private String replacePattern;

        public MatchAndReplace(Pattern pattern, String replacePattern) {
            this.pattern = pattern;
            this.replacePattern = replacePattern;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getReplacePattern() {
            return this.replacePattern;
        }
    }
}

