/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.logs.instructions;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.runtime.Environment;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeInstruction;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionReader;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;
import org.wso2.carbon.privacy.forgetme.logs.beans.Patterns;
import org.wso2.carbon.privacy.forgetme.logs.exception.LogProcessorException;
import org.wso2.carbon.privacy.forgetme.logs.instructions.LogFileInstruction;

public class LogFileInstructionReader
implements InstructionReader {
    private static final Logger log = LoggerFactory.getLogger(LogFileInstructionReader.class);
    private static final String NAME = "log-file";
    private static final String LOG_FILE_PATH_PROPERTY = "log-file-path";
    private static final String LOG_FILE_NAME_REGEX_PROPERTY = "log-file-name-regex";

    public String getType() {
        return NAME;
    }

    public List<ForgetMeInstruction> read(Path patternDir, Properties properties, Environment environment) throws ModuleException {
        File contentDirectory = patternDir.toFile();
        File[] patternFiles = contentDirectory.listFiles(fileName -> fileName.isFile() && this.isXmlExtension(fileName.getName()));
        List<Patterns.Pattern> patternList = this.loadReplacementPatterns(patternFiles);
        List<File> logFiles = this.listMatchingLogFiles(patternDir, properties);
        return logFiles.stream().map(logFile -> new LogFileInstruction(patternList, (File)logFile)).collect(Collectors.toList());
    }

    private List<Patterns.Pattern> loadReplacementPatterns(File[] patternFiles) throws ModuleException {
        ArrayList<Patterns.Pattern> patternList = new ArrayList<Patterns.Pattern>();
        if (patternFiles != null) {
            for (File file : patternFiles) {
                try {
                    Patterns patterns = this.readXML(file);
                    patternList.addAll(patterns.getPattern());
                }
                catch (LogProcessorException e) {
                    throw new ModuleException("Could not read the file : " + file, (Throwable)((Object)e));
                }
            }
        }
        return patternList;
    }

    private List<File> listMatchingLogFiles(Path patternDir, Properties properties) throws ModuleException {
        String logFilePath = properties.getProperty(LOG_FILE_PATH_PROPERTY);
        if (logFilePath == null) {
            throw new ModuleException("Property : log-file-path is not set for the processor :log-file for path : " + patternDir);
        }
        String logFileNameRegex = properties.getProperty(LOG_FILE_NAME_REGEX_PROPERTY);
        if (logFileNameRegex == null) {
            throw new ModuleException("Property : log-file-name-regex is not set for the processor :log-file for path : " + patternDir);
        }
        return this.scanForFiles(logFilePath, logFileNameRegex);
    }

    private List<File> scanForFiles(String logFilePath, String logFileNameRegex) {
        File dir = new File(logFilePath);
        Pattern regexPattern = Pattern.compile(logFileNameRegex);
        File[] logFiles = dir.listFiles((dir1, name) -> regexPattern.matcher(name).matches());
        return logFiles != null ? Arrays.asList(logFiles) : Collections.EMPTY_LIST;
    }

    private Patterns readXML(File xmlFile) throws LogProcessorException {
        if (log.isDebugEnabled()) {
            log.debug("Reading pattern configuration file at : " + xmlFile);
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Patterns.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Patterns patterns = (Patterns)unmarshaller.unmarshal(xmlFile);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (log.isDebugEnabled()) {
                log.debug("Read pattern configuration file success : " + xmlFile);
            }
            return patterns;
        }
        catch (JAXBException ex) {
            throw new LogProcessorException("Error occurred while unmarshalling xml content.", ex);
        }
    }

    private boolean isXmlExtension(String name) {
        return true;
    }
}

