/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.logs.instructions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.report.ReportAppender;
import org.wso2.carbon.privacy.forgetme.api.runtime.Environment;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeInstruction;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeResult;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionExecutionException;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfig;
import org.wso2.carbon.privacy.forgetme.api.user.UserIdentifier;
import org.wso2.carbon.privacy.forgetme.logs.beans.Patterns;
import org.wso2.carbon.privacy.forgetme.logs.processor.LogFileProcessor;

public class LogFileInstruction
implements ForgetMeInstruction {
    private static final Logger log = LoggerFactory.getLogger(LogFileInstruction.class);
    private List<Patterns.Pattern> patterns;
    private File logFile;

    public LogFileInstruction(List<Patterns.Pattern> patterns, File logFile) {
        this.patterns = patterns;
        this.logFile = logFile;
    }

    public ForgetMeResult execute(UserIdentifier userIdentifier, ProcessorConfig processorConfig, Environment environment, ReportAppender reportAppender) throws InstructionExecutionException {
        ArrayList<File> logFiles = new ArrayList<File>();
        logFiles.add(this.logFile);
        LogFileProcessor logFileProcessor = new LogFileProcessor();
        if (log.isDebugEnabled()) {
            log.debug("File {} is being processed.", (Object)this.logFile.getName());
        }
        logFileProcessor.processFiles(userIdentifier, reportAppender, this.patterns, logFiles);
        return new ForgetMeResult();
    }
}

