/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.event.processor.core.util.DistributedModeConstants;

public class ExecutionPlanStatusHolder
implements Serializable {
    private DistributedModeConstants.TopologyState topologyState = DistributedModeConstants.TopologyState.UNKNOWN;
    private final Map<String, Integer> publisherBoltsMap = new HashMap<String, Integer>();
    private final Map<String, Integer[]> cepReceiversMap = new HashMap<String, Integer[]>();
    private int requiredPublisherBoltsCount = 0;

    public ExecutionPlanStatusHolder(int requiredPublisherBolts) {
        this.requiredPublisherBoltsCount = requiredPublisherBolts;
    }

    DistributedModeConstants.TopologyState getTopologyState() {
        return this.topologyState;
    }

    public void setStormTopologyStatus(DistributedModeConstants.TopologyState topologyState) {
        this.topologyState = topologyState;
    }

    int getRequiredPublisherBoltsCount() {
        return this.requiredPublisherBoltsCount;
    }

    public void setCEPReceiverStatus(String hostIp, int connected, int required) {
        this.cepReceiversMap.put(hostIp, new Integer[]{connected, required});
    }

    public void setConnectedPublisherBoltsCount(String hostIp, int connectedCount) {
        this.publisherBoltsMap.put(hostIp, connectedCount);
    }

    public String getExecutionPlanStatus() {
        String topologyStatus = "Storm topology : " + this.getTopologyState().toString() + "\n";
        String receiverStatus = "Inflow connections : ";
        if (this.cepReceiversMap.size() == 0) {
            receiverStatus = receiverStatus + "no receivers found \n";
        } else {
            receiverStatus = receiverStatus + "\n";
            for (Map.Entry<String, Integer[]> entry : this.cepReceiversMap.entrySet()) {
                if (entry.getValue()[1] - entry.getValue()[0] == 0) {
                    receiverStatus = receiverStatus + "\t" + entry.getKey() + " : all established\n";
                    continue;
                }
                receiverStatus = receiverStatus + "\t" + entry.getKey() + " : " + entry.getValue()[0] + "/" + entry.getValue()[1] + " established\n";
            }
        }
        int boltsConnected = 0;
        String stormPublishingBoltStatus = "Outflow connections : ";
        for (Map.Entry<String, Integer> entry : this.publisherBoltsMap.entrySet()) {
            boltsConnected += entry.getValue().intValue();
        }
        int requiredPublisherBoltsCount = this.getRequiredPublisherBoltsCount();
        stormPublishingBoltStatus = requiredPublisherBoltsCount - boltsConnected == 0 ? stormPublishingBoltStatus + " all established\n" : stormPublishingBoltStatus + boltsConnected + "/" + requiredPublisherBoltsCount + " established\n";
        return topologyStatus + receiverStatus + stormPublishingBoltStatus;
    }
}

