/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.util.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanDependencyValidationException;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.AttributeNotExistException;
import org.wso2.siddhi.query.api.util.AnnotationHelper;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class EventProcessorHelper {
    private static final Log log = LogFactory.getLog(EventProcessorHelper.class);

    public static String getExecutionPlanName(String executionPlanAsString) {
        String executionPlanName = null;
        ExecutionPlan executionPlan = SiddhiCompiler.parse((String)executionPlanAsString);
        executionPlanName = AnnotationHelper.getAnnotationElement((String)"name", null, (List)executionPlan.getAnnotations()).getValue();
        return executionPlanName;
    }

    public static void validateExecutionPlan(String executionPlan) throws ExecutionPlanConfigurationException, ExecutionPlanDependencyValidationException {
        int i = 0;
        ArrayList<String> importedStreams = new ArrayList<String>();
        ArrayList<String> exportedStreams = new ArrayList<String>();
        Pattern databridgeStreamNamePattern = Pattern.compile("[a-zA-Z0-9_\\-\\.]+");
        Pattern streamVersionPattern = Pattern.compile("([0-9]*)\\.([0-9]*)\\.([0-9]*)");
        ExecutionPlan parsedExecPlan = SiddhiCompiler.parse((String)executionPlan);
        Element element = AnnotationHelper.getAnnotationElement((String)"name", null, (List)parsedExecPlan.getAnnotations());
        if (element == null) {
            throw new ExecutionPlanConfigurationException("Execution plan name is not given. Please specify execution plan name using the annotation '@Plan:name('executionPlanNameHere')'");
        }
        String planName = element.getValue();
        if (planName.equals("")) {
            throw new ExecutionPlanConfigurationException("Execution plan name is empty. Hence the plan is invalid");
        }
        if (planName.trim().contains(" ")) {
            throw new ExecutionPlanConfigurationException("Execution plan name '" + planName + "' contains whitespaces. Please remove whitespaces.");
        }
        Map streamDefMap = parsedExecPlan.getStreamDefinitionMap();
        for (Map.Entry entry : streamDefMap.entrySet()) {
            Matcher m;
            String[] streamIdComponents;
            Element importElement = AnnotationHelper.getAnnotationElement((String)"Import", null, (List)((StreamDefinition)entry.getValue()).getAnnotations());
            Element exportElement = AnnotationHelper.getAnnotationElement((String)"Export", null, (List)((StreamDefinition)entry.getValue()).getAnnotations());
            if (importElement != null && exportElement != null) {
                throw new ExecutionPlanConfigurationException("Same stream definition has being imported and exported. Please correct " + i + "th of the " + parsedExecPlan.getStreamDefinitionMap().size() + "stream definition, with stream id '" + (String)entry.getKey() + "'");
            }
            if (importElement != null) {
                String atImportLiteral = "@Import";
                String importElementValue = importElement.getValue();
                if (importElementValue == null || importElementValue.trim().isEmpty()) {
                    throw new ExecutionPlanConfigurationException("Imported stream cannot be empty as in '" + atImportLiteral + "(" + "'" + "'" + ")" + "'. Please correct " + i + "th of the " + parsedExecPlan.getStreamDefinitionMap().size() + "stream definition, with stream id '" + (String)entry.getKey() + "'");
                }
                streamIdComponents = importElementValue.split(":");
                if (streamIdComponents.length != 2) {
                    throw new ExecutionPlanConfigurationException("Found malformed " + atImportLiteral + " element '" + importElementValue + "'. " + atImportLiteral + " annotation should take the form '" + atImportLiteral + "(" + "'" + "streamName" + ":" + "StreamVersion" + "'" + ")" + "'. There should be a '" + ":" + "' character, separating the streamName and its version");
                }
                if (!databridgeStreamNamePattern.matcher(streamIdComponents[0].trim()).matches()) {
                    throw new ExecutionPlanConfigurationException("Invalid imported stream name[" + streamIdComponents[0] + "] in execution plan:" + planName + ". Stream name should match the regex '" + "[a-zA-Z0-9_\\-\\.]+" + "'");
                }
                m = streamVersionPattern.matcher(streamIdComponents[1].trim());
                if (!m.matches()) {
                    throw new ExecutionPlanConfigurationException("Invalid stream version [" + streamIdComponents[1] + "] for stream name " + streamIdComponents[0] + " in execution plan: " + planName + ". Stream version should match the regex '" + "([0-9]*)\\.([0-9]*)\\.([0-9]*)" + "'");
                }
                EventProcessorHelper.validateSiddhiStreamWithDatabridgeStream(streamIdComponents[0], streamIdComponents[1], (StreamDefinition)entry.getValue());
                if (exportedStreams.contains(importElementValue)) {
                    throw new ExecutionPlanConfigurationException("Imported stream '" + importElementValue + "' is also among the exported streams. Hence the execution plan is invalid");
                }
                importedStreams.add(importElementValue);
            }
            if (exportElement != null) {
                String atExportLiteral = "@Export";
                String exportElementValue = exportElement.getValue();
                if (exportElementValue == null || exportElementValue.trim().isEmpty()) {
                    throw new ExecutionPlanConfigurationException("Exported stream cannot be empty as in '" + atExportLiteral + "(" + "'" + "'" + ")" + "'. Please correct " + i + "th of the " + parsedExecPlan.getStreamDefinitionMap().size() + "stream definition, with stream id '" + (String)entry.getKey());
                }
                streamIdComponents = exportElementValue.split(":");
                if (streamIdComponents.length != 2) {
                    throw new ExecutionPlanConfigurationException("Found malformed " + atExportLiteral + " element '" + exportElementValue + "'. " + atExportLiteral + " annotation should take the form '" + atExportLiteral + "(" + "'" + "streamName" + ":" + "StreamVersion" + "'" + ")" + "'. There should be a '" + ":" + "' character, separating the streamName and its version");
                }
                if (!databridgeStreamNamePattern.matcher(streamIdComponents[0].trim()).matches()) {
                    throw new ExecutionPlanConfigurationException("Invalid exported stream name[" + streamIdComponents[0] + "] in execution plan:" + planName + ". Stream name should match the regex '" + "[a-zA-Z0-9_\\-\\.]+" + "'");
                }
                m = streamVersionPattern.matcher(streamIdComponents[1].trim());
                if (!m.matches()) {
                    throw new ExecutionPlanConfigurationException("Invalid stream version [" + streamIdComponents[1] + "] for stream name " + streamIdComponents[0] + " in execution plan: " + planName + ". Stream version should match the regex '" + "([0-9]*)\\.([0-9]*)\\.([0-9]*)" + "'");
                }
                EventProcessorHelper.validateSiddhiStreamWithDatabridgeStream(streamIdComponents[0], streamIdComponents[1], (StreamDefinition)entry.getValue());
                if (importedStreams.contains(exportElementValue)) {
                    throw new ExecutionPlanConfigurationException("Exported stream '" + exportElementValue + "' is also among the imported streams. Hence the execution plan is invalid");
                }
                exportedStreams.add(exportElementValue);
            }
            ++i;
        }
        SiddhiManager siddhiManager = EventProcessorValueHolder.getSiddhiManager();
        EventProcessorHelper.loadDataSourceConfiguration(siddhiManager);
        try {
            siddhiManager.validateExecutionPlan(executionPlan);
        }
        catch (Throwable t) {
            throw new ExecutionPlanConfigurationException(t.getMessage(), t);
        }
    }

    private static boolean validateSiddhiStreamWithDatabridgeStream(String streamName, String streamVersion, StreamDefinition siddhiStreamDefinition) throws ExecutionPlanConfigurationException, ExecutionPlanDependencyValidationException {
        if (siddhiStreamDefinition == null) {
            throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Cannot validate null Siddhi stream for the stream: " + streamName + ":" + streamVersion + " ");
        }
        EventStreamService eventStreamService = EventProcessorValueHolder.getEventStreamService();
        try {
            org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition = eventStreamService.getStreamDefinition(streamName, streamVersion);
            if (streamDefinition != null) {
                Attribute.Type type;
                String siddhiAttributeName;
                int attributeCount = 0;
                int siddhiStreamAttributeCount = siddhiStreamDefinition.getAttributeList().size();
                int streamSize = (streamDefinition.getMetaData() == null ? 0 : streamDefinition.getMetaData().size()) + (streamDefinition.getCorrelationData() == null ? 0 : streamDefinition.getCorrelationData().size()) + (streamDefinition.getPayloadData() == null ? 0 : streamDefinition.getPayloadData().size());
                Element ArbitraryElement = AnnotationHelper.getAnnotationElement((String)"Import", (String)"arbitrary.data", (List)siddhiStreamDefinition.getAnnotations());
                if (ArbitraryElement == null) {
                    ArbitraryElement = AnnotationHelper.getAnnotationElement((String)"Export", (String)"arbitrary.data", (List)siddhiStreamDefinition.getAnnotations());
                }
                if (ArbitraryElement != null && ArbitraryElement.getValue().equals("true")) {
                    if (!((Attribute)siddhiStreamDefinition.getAttributeList().get(siddhiStreamAttributeCount - 1)).getName().equals("arbitraryDataMap")) {
                        throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Please specify arbitraryDataMap attribute name in stream " + streamName + ":" + streamVersion);
                    }
                } else if (siddhiStreamAttributeCount != streamSize) {
                    throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "No of attributes in stream " + streamName + ":" + streamVersion + " do not match the no of attributes in Siddhi stream");
                }
                if (streamDefinition.getMetaData() != null) {
                    for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getMetaData()) {
                        siddhiAttributeName = "meta_" + attribute.getName();
                        type = siddhiStreamDefinition.getAttributeType(siddhiAttributeName);
                        if (siddhiStreamDefinition.getAttributePosition(siddhiAttributeName) != attributeCount++) {
                            throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Stream " + streamName + ":" + streamVersion + "; Attribute positions do not match for attribute: " + attribute.getName());
                        }
                        if (EventProcessorHelper.isMatchingType(type, attribute.getType())) continue;
                        throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Stream " + streamName + ":" + streamVersion + "; Type mismatch for attribute: " + attribute.getName());
                    }
                }
                if (streamDefinition.getCorrelationData() != null) {
                    for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getCorrelationData()) {
                        siddhiAttributeName = "correlation_" + attribute.getName();
                        type = siddhiStreamDefinition.getAttributeType(siddhiAttributeName);
                        if (siddhiStreamDefinition.getAttributePosition(siddhiAttributeName) != attributeCount++) {
                            throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Stream " + streamName + ":" + streamVersion + "; Attribute positions do not match for attribute: " + attribute.getName());
                        }
                        if (EventProcessorHelper.isMatchingType(type, attribute.getType())) continue;
                        throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Stream " + streamName + ":" + streamVersion + "; Type mismatch for attribute: " + attribute.getName());
                    }
                }
                if (streamDefinition.getPayloadData() != null) {
                    for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getPayloadData()) {
                        siddhiAttributeName = attribute.getName();
                        type = siddhiStreamDefinition.getAttributeType(siddhiAttributeName);
                        if (siddhiStreamDefinition.getAttributePosition(siddhiAttributeName) != attributeCount++) {
                            throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Stream " + streamName + ":" + streamVersion + "; Attribute positions do not match for attribute: " + attribute.getName());
                        }
                        if (EventProcessorHelper.isMatchingType(type, attribute.getType())) continue;
                        throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Stream " + streamName + ":" + streamVersion + "; Type mismatch for attribute: " + attribute.getName());
                    }
                }
                return true;
            }
        }
        catch (EventStreamConfigurationException e) {
            throw new ExecutionPlanConfigurationException("Error while validating stream definition with store : " + e.getMessage(), e);
        }
        catch (AttributeNotExistException e) {
            throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, e.getMessage());
        }
        throw new ExecutionPlanDependencyValidationException(streamName + ":" + streamVersion, "Stream " + streamName + ":" + streamVersion + " does not exist");
    }

    private static boolean isMatchingType(Attribute.Type siddhiType, AttributeType databridgeType) {
        switch (siddhiType) {
            case BOOL: {
                return databridgeType == AttributeType.BOOL;
            }
            case STRING: {
                return databridgeType == AttributeType.STRING;
            }
            case DOUBLE: {
                return databridgeType == AttributeType.DOUBLE;
            }
            case FLOAT: {
                return databridgeType == AttributeType.FLOAT;
            }
            case INT: {
                return databridgeType == AttributeType.INT;
            }
            case LONG: {
                return databridgeType == AttributeType.LONG;
            }
        }
        return false;
    }

    public static String setExecutionPlanAnnotationName(String executionPlan, String annotationName, boolean isAnnotationNameTrue) {
        String newExecutionPlan = null;
        String planHeader = "";
        String planBody = "";
        String planHeaderLineRegex = "(^\\s*@Plan:.*)|(^\\s*--.*)|(^\\s*\\/\\*.*\\*\\/\\s*)|(^\\s*)";
        String regexToBeReplaced = "^\\s*@Plan:" + annotationName + "\\" + "(" + "'" + !isAnnotationNameTrue + "'" + "\\" + ")";
        String replacement = "@Plan:" + annotationName + "(" + "'" + isAnnotationNameTrue + "'" + ")";
        Matcher matcher = Pattern.compile(regexToBeReplaced, 8).matcher(executionPlan);
        if (matcher.find()) {
            String[] matchSplitArray = matcher.group().split("@");
            String whitespaces = "";
            if (matchSplitArray.length > 1) {
                whitespaces = whitespaces + matchSplitArray[0];
            }
            replacement = whitespaces + replacement;
            newExecutionPlan = matcher.replaceFirst(replacement);
        } else {
            String[] planHeaderArray = executionPlan.split("\n");
            for (int i = 0; i < planHeaderArray.length && planHeaderArray[i].matches(planHeaderLineRegex) && !planHeaderArray[i].matches("^\\s*\\/\\* define streams and write query here ... \\*\\/\\s*"); ++i) {
                planHeader = planHeader + planHeaderArray[i] + "\n";
            }
            planBody = executionPlan.replace(planHeader, "");
            newExecutionPlan = planHeader + replacement + "\n" + "\n" + planBody;
        }
        return newExecutionPlan;
    }

    public static void loadDataSourceConfiguration(SiddhiManager siddhiManager) {
        try {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            if (tenantId > -1) {
                DataSourceManager.getInstance().initTenant(tenantId);
            }
            List dataSources = EventProcessorValueHolder.getDataSourceService().getAllDataSources();
            for (CarbonDataSource cds : dataSources) {
                try {
                    if (!(cds.getDSObject() instanceof DataSource)) continue;
                    siddhiManager.setDataSource(cds.getDSMInfo().getName(), (DataSource)cds.getDSObject());
                }
                catch (Exception e) {
                    log.error((Object)("Unable to add the datasource" + cds.getDSMInfo().getName()), (Throwable)e);
                }
            }
        }
        catch (DataSourceException e) {
            log.error((Object)"Unable to populate the data sources in Siddhi engine.", (Throwable)e);
        }
    }
}

