/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.event.processor.core.StreamConfiguration;
import org.wso2.carbon.event.processor.core.exception.ExcecutionPlanRuntimeException;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.exception.DuplicateAttributeException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EventProcessorUtil {
    private static Log log = LogFactory.getLog(EventProcessorUtil.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    public static org.wso2.carbon.databridge.commons.StreamDefinition convertToDatabridgeStreamDefinition(StreamDefinition siddhiStreamDefinition, StreamConfiguration streamConfiguration) {
        org.wso2.carbon.databridge.commons.StreamDefinition databridgeDefinition = null;
        try {
            databridgeDefinition = new org.wso2.carbon.databridge.commons.StreamDefinition(streamConfiguration.getName(), streamConfiguration.getVersion());
        }
        catch (MalformedStreamDefinitionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        ArrayList<org.wso2.carbon.databridge.commons.Attribute> payload = new ArrayList<org.wso2.carbon.databridge.commons.Attribute>();
        ArrayList<org.wso2.carbon.databridge.commons.Attribute> meta = new ArrayList<org.wso2.carbon.databridge.commons.Attribute>();
        ArrayList<org.wso2.carbon.databridge.commons.Attribute> correlation = new ArrayList<org.wso2.carbon.databridge.commons.Attribute>();
        if (siddhiStreamDefinition.getAttributeList() != null) {
            for (Attribute attribute : siddhiStreamDefinition.getAttributeList()) {
                if (attribute.getName().startsWith("meta_")) {
                    meta.add(EventProcessorUtil.convertToDatabridgeAttribute(attribute, "meta_"));
                    continue;
                }
                if (attribute.getName().startsWith("correlation_")) {
                    correlation.add(EventProcessorUtil.convertToDatabridgeAttribute(attribute, "correlation_"));
                    continue;
                }
                payload.add(EventProcessorUtil.convertToDatabridgeAttribute(attribute, null));
            }
        }
        if (!payload.isEmpty()) {
            databridgeDefinition.setPayloadData(payload);
        }
        if (!meta.isEmpty()) {
            databridgeDefinition.setMetaData(meta);
        }
        if (!correlation.isEmpty()) {
            databridgeDefinition.setCorrelationData(correlation);
        }
        return databridgeDefinition;
    }

    public static StreamDefinition convertToSiddhiStreamDefinition(org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition, String siddhiStreamName) throws EventStreamConfigurationException {
        StreamDefinition siddhiStreamDefinition = new StreamDefinition();
        siddhiStreamDefinition.setId(siddhiStreamName);
        try {
            Attribute siddhiAttribute;
            if (streamDefinition.getMetaData() != null) {
                for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getMetaData()) {
                    siddhiAttribute = EventProcessorUtil.convertToSiddhiAttribute(attribute, "meta_");
                    siddhiStreamDefinition.attribute(siddhiAttribute.getName(), siddhiAttribute.getType());
                }
            }
            if (streamDefinition.getCorrelationData() != null) {
                for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getCorrelationData()) {
                    siddhiAttribute = EventProcessorUtil.convertToSiddhiAttribute(attribute, "correlation_");
                    siddhiStreamDefinition.attribute(siddhiAttribute.getName(), siddhiAttribute.getType());
                }
            }
            if (streamDefinition.getPayloadData() != null) {
                for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getPayloadData()) {
                    siddhiStreamDefinition.attribute(attribute.getName(), EventProcessorUtil.convertToSiddhiAttribute(attribute, "").getType());
                }
            }
            return siddhiStreamDefinition;
        }
        catch (DuplicateAttributeException ex) {
            throw new EventStreamConfigurationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static org.wso2.carbon.databridge.commons.Attribute convertToDatabridgeAttribute(Attribute attribute, String prefixToDrop) {
        AttributeType type;
        switch (attribute.getType()) {
            case LONG: {
                type = AttributeType.LONG;
                break;
            }
            case INT: {
                type = AttributeType.INT;
                break;
            }
            case FLOAT: {
                type = AttributeType.FLOAT;
                break;
            }
            case DOUBLE: {
                type = AttributeType.DOUBLE;
                break;
            }
            case BOOL: {
                type = AttributeType.BOOL;
                break;
            }
            default: {
                type = AttributeType.STRING;
            }
        }
        String name = prefixToDrop != null ? attribute.getName().replaceFirst(prefixToDrop, "") : attribute.getName();
        return new org.wso2.carbon.databridge.commons.Attribute(name, type);
    }

    public static Attribute convertToSiddhiAttribute(org.wso2.carbon.databridge.commons.Attribute attribute, String prefix) {
        Attribute.Type type;
        switch (attribute.getType()) {
            case LONG: {
                type = Attribute.Type.LONG;
                break;
            }
            case INT: {
                type = Attribute.Type.INT;
                break;
            }
            case FLOAT: {
                type = Attribute.Type.FLOAT;
                break;
            }
            case DOUBLE: {
                type = Attribute.Type.DOUBLE;
                break;
            }
            case BOOL: {
                type = Attribute.Type.BOOL;
                break;
            }
            default: {
                type = Attribute.Type.STRING;
            }
        }
        return new Attribute(prefix + attribute.getName(), type);
    }

    public static String formatXml(String unformattedXml) throws ExecutionPlanConfigurationException {
        try {
            Document document = EventProcessorUtil.parseXmlFile(unformattedXml);
            OutputFormat format = new OutputFormat(document);
            format.setLineWidth(65);
            format.setIndenting(true);
            format.setIndent(2);
            StringWriter out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.serialize(document);
            return ((Object)out).toString();
        }
        catch (IOException e) {
            throw new ExecutionPlanConfigurationException(e);
        }
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    private static Document parseXmlFile(String in) throws ExecutionPlanConfigurationException {
        try {
            DocumentBuilderFactory dbf = EventProcessorUtil.getSecuredDocumentBuilder();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(in));
            return db.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new ExecutionPlanConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ExecutionPlanConfigurationException(e);
        }
        catch (IOException e) {
            throw new ExecutionPlanConfigurationException(e);
        }
    }

    public static String getStreamId(String streamName, String version) {
        return streamName + ":" + version;
    }

    public static String getStreamName(String streamId) {
        return streamId.split(":")[0];
    }

    public static String getDefinitionString(org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition, String siddhiStreamName) {
        StringBuilder builder = new StringBuilder();
        builder.append("define stream ");
        builder.append(siddhiStreamName);
        builder.append(" ( ");
        if (streamDefinition.getMetaData() != null) {
            for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getMetaData()) {
                builder.append("meta_" + attribute.getName() + " " + attribute.getType().toString().toLowerCase() + ", ");
            }
        }
        if (streamDefinition.getCorrelationData() != null) {
            for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getCorrelationData()) {
                builder.append("correlation_" + attribute.getName() + " " + attribute.getType().toString().toLowerCase() + ", ");
            }
        }
        if (streamDefinition.getPayloadData() != null) {
            for (org.wso2.carbon.databridge.commons.Attribute attribute : streamDefinition.getPayloadData()) {
                builder.append(attribute.getName() + " " + attribute.getType().toString().toLowerCase() + ", ");
            }
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append(");");
        return builder.toString();
    }

    public static String getDefinitionString(AbstractDefinition siddhiStreamDefinition) {
        StringBuilder builder = new StringBuilder();
        builder.append("define stream ");
        builder.append(siddhiStreamDefinition.getId());
        builder.append(" ( ");
        for (Attribute attribute : siddhiStreamDefinition.getAttributeList()) {
            builder.append(attribute.getName() + " " + attribute.getType().toString().toLowerCase() + ", ");
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append(");");
        return builder.toString();
    }

    public static String getTriggerDefinitionString(TriggerDefinition triggerDefinition) {
        StringBuilder builder = new StringBuilder();
        builder.append("define trigger ");
        builder.append(triggerDefinition.getId());
        Long atEvery = triggerDefinition.getAtEvery();
        if (atEvery != null) {
            builder.append(" at every ");
            builder.append(atEvery / 1000L);
            builder.append(" sec");
        } else {
            builder.append(" at ");
            builder.append("'" + triggerDefinition.getAt() + "'");
        }
        builder.append(";");
        return builder.toString();
    }

    public static String constructQueryExpression(String executionPlanName, List<String> importDefinitions, List<String> exportDefinitions, String queryExpressions) {
        StringBuilder builder = new StringBuilder();
        if (executionPlanName != null && executionPlanName.length() > 0) {
            builder.append("@plan:").append("Name").append("('").append(executionPlanName).append("')");
        }
        for (String definition : importDefinitions) {
            builder.append(definition);
        }
        for (String definition : exportDefinitions) {
            builder.append(definition);
        }
        builder.append(queryExpressions);
        return builder.toString();
    }

    public static AxisConfiguration getAxisConfiguration() {
        AxisConfiguration axisConfiguration = null;
        if (CarbonContext.getThreadLocalCarbonContext().getTenantId() == -1234) {
            axisConfiguration = EventProcessorValueHolder.getConfigurationContext().getServerConfigContext().getAxisConfiguration();
        } else {
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            ConfigurationContext configurationContext = EventProcessorValueHolder.getTenantConfig(tenantId);
            if (configurationContext != null) {
                axisConfiguration = configurationContext.getAxisConfiguration();
            } else {
                throw new ExcecutionPlanRuntimeException("Tenant configuration not found for tenant id: " + tenantId);
            }
        }
        return axisConfiguration;
    }

    public static Event getWso2Event(org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition, int metaAttrCount, int correlationAttrCount, int payloadAttrCount, long timestamp, Object[] data) {
        int dataLength = data.length;
        Object[] metaAttrArray = new Object[metaAttrCount];
        Object[] correlationAttrArray = new Object[correlationAttrCount];
        Object[] payloadAttrArray = new Object[payloadAttrCount];
        Map arbitraryDataMap = null;
        if (metaAttrCount + correlationAttrCount + payloadAttrCount + 1 == dataLength) {
            dataLength = data.length - 1;
            arbitraryDataMap = (Map)data[dataLength];
        }
        int attrIndex = 0;
        for (int i = 0; i < metaAttrCount; ++i) {
            metaAttrArray[i] = data[attrIndex++];
        }
        for (int j = 0; j < correlationAttrCount; ++j) {
            correlationAttrArray[j] = data[attrIndex++];
        }
        for (int k = 0; k < payloadAttrCount; ++k) {
            payloadAttrArray[k] = data[attrIndex++];
        }
        return new Event(streamDefinition.getStreamId(), timestamp, metaAttrArray, correlationAttrArray, payloadAttrArray, arbitraryDataMap);
    }

    public static List<Event> getWso2Events(org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition, int metaAttrCount, int correlationAttrCount, int payloadAttrCount, org.wso2.siddhi.core.event.Event[] events) {
        ArrayList<Event> eventList = new ArrayList<Event>();
        for (org.wso2.siddhi.core.event.Event event : events) {
            eventList.add(EventProcessorUtil.getWso2Event(streamDefinition, metaAttrCount, correlationAttrCount, payloadAttrCount, event.getTimestamp(), event.getData()));
        }
        return eventList;
    }

    public static void validatePath(String fileName) throws ExecutionPlanConfigurationException {
        if (fileName.contains("../") || fileName.contains("..\\")) {
            throw new ExecutionPlanConfigurationException("File name contains restricted path elements. " + fileName);
        }
    }
}

