/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.core.EventProcessorDeployer;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.internal.util.EventProcessorUtil;

public class EventProcessorConfigurationFilesystemInvoker {
    private static final Log log = LogFactory.getLog(EventProcessorConfigurationFilesystemInvoker.class);

    public static void save(OMElement executionPlanOM, String executionPlanName, String fileName) throws ExecutionPlanConfigurationException {
        EventProcessorConfigurationFilesystemInvoker.saveOld(executionPlanOM.toString(), executionPlanName, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOld(String executionPlan, String executionPlanName, String fileName) throws ExecutionPlanConfigurationException {
        EventProcessorDeployer eventProcessorDeployer = (EventProcessorDeployer)EventProcessorConfigurationFilesystemInvoker.getDeployer("executionplans");
        EventProcessorUtil.validatePath(fileName);
        String filePath = EventProcessorConfigurationFilesystemInvoker.getFilePathFromFilename(fileName);
        try {
            OutputStreamWriter writer = null;
            try {
                File file = new File(filePath);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                String xmlContent = EventProcessorUtil.formatXml(executionPlan);
                eventProcessorDeployer.getDeployedExecutionPlanFilePaths().add(filePath);
                writer.write(xmlContent);
                log.info((Object)("Execution plan configuration for " + executionPlanName + " saved in the filesystem"));
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            eventProcessorDeployer.executeManualDeployment(filePath);
        }
        catch (IOException e) {
            eventProcessorDeployer.getDeployedExecutionPlanFilePaths().remove(filePath);
            log.error((Object)("Error while saving " + executionPlanName), (Throwable)e);
            throw new ExecutionPlanConfigurationException("Error while saving ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String executionPlan, String executionPlanName, String fileName) throws ExecutionPlanConfigurationException {
        EventProcessorDeployer eventProcessorDeployer = (EventProcessorDeployer)EventProcessorConfigurationFilesystemInvoker.getDeployer("executionplans");
        EventProcessorUtil.validatePath(fileName);
        String filePath = EventProcessorConfigurationFilesystemInvoker.getFilePathFromFilename(fileName);
        try {
            OutputStreamWriter writer = null;
            try {
                File file = new File(filePath);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                eventProcessorDeployer.getDeployedExecutionPlanFilePaths().add(filePath);
                writer.write(executionPlan);
                log.info((Object)("Execution plan: " + executionPlanName + " saved in the filesystem"));
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            eventProcessorDeployer.executeManualDeployment(filePath);
        }
        catch (IOException e) {
            eventProcessorDeployer.getDeployedExecutionPlanFilePaths().remove(filePath);
            log.error((Object)("Error while saving " + executionPlanName), (Throwable)e);
            throw new ExecutionPlanConfigurationException("Error while saving ", e);
        }
    }

    public static void delete(String fileName) throws ExecutionPlanConfigurationException {
        try {
            EventProcessorUtil.validatePath(fileName);
            String filePath = EventProcessorConfigurationFilesystemInvoker.getFilePathFromFilename(fileName);
            File file = new File(filePath);
            if (file.exists()) {
                EventProcessorDeployer deployer = (EventProcessorDeployer)EventProcessorConfigurationFilesystemInvoker.getDeployer("executionplans");
                deployer.getUnDeployedExecutionPlanFilePaths().add(filePath);
                boolean fileDeleted = file.delete();
                if (!fileDeleted) {
                    log.error((Object)("Could not delete " + fileName));
                    deployer.getUnDeployedExecutionPlanFilePaths().remove(filePath);
                } else {
                    log.info((Object)(fileName + " is deleted from the file system"));
                    deployer.executeManualUndeployment(filePath);
                }
            }
        }
        catch (Exception e) {
            throw new ExecutionPlanConfigurationException("Error while deleting the execution plan file ", e);
        }
    }

    public static void reload(String filePath) throws ExecutionPlanConfigurationException {
        EventProcessorDeployer eventProcessorDeployer = (EventProcessorDeployer)EventProcessorConfigurationFilesystemInvoker.getDeployer("executionplans");
        try {
            eventProcessorDeployer.processUndeploy(filePath);
            eventProcessorDeployer.processDeploy(new DeploymentFileData(new File(filePath)));
        }
        catch (ExecutionPlanConfigurationException e) {
            throw new ExecutionPlanConfigurationException(e);
        }
    }

    public static Deployer getDeployer(String endpointDirPath) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)EventProcessorUtil.getAxisConfiguration().getConfigurator();
        return deploymentEngine.getDeployer(endpointDirPath, "siddhiql");
    }

    private static String getFilePathFromFilename(String fileName) {
        return new File(EventProcessorUtil.getAxisConfiguration().getRepository().getPath()).getAbsolutePath() + File.separator + "executionplans" + File.separator + fileName;
    }

    public static String readExecutionPlanConfigFile(String fileName) throws ExecutionPlanConfigurationException {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            EventProcessorUtil.validatePath(fileName);
            String filePath = EventProcessorConfigurationFilesystemInvoker.getFilePathFromFilename(fileName);
            bufferedReader = new BufferedReader(new FileReader(filePath));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new ExecutionPlanConfigurationException("Execution plan file not found, " + fileName + "," + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ExecutionPlanConfigurationException("Cannot read the execution plan file, " + fileName + "," + e.getMessage(), e);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred when reading the file, " + fileName + "," + e.getMessage()), (Throwable)e);
            }
        }
        return stringBuilder.toString().trim();
    }
}

