/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.util;

import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.common.storm.component.EventPublisherBolt;
import org.wso2.carbon.event.processor.common.storm.component.EventReceiverSpout;
import org.wso2.carbon.event.processor.common.storm.component.SiddhiBolt;
import org.wso2.carbon.event.processor.common.storm.component.TriggerSpout;
import org.wso2.carbon.event.processor.core.exception.StormQueryConstructionException;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.StormStatusHolderInitializer;
import org.wso2.carbon.event.processor.core.internal.storm.util.ComponentInfoHolder;
import org.wso2.carbon.event.processor.core.internal.storm.util.TopologyInfoHolder;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class StormTopologyConstructor {
    private static Log log = LogFactory.getLog(StormTopologyConstructor.class);

    public static TopologyBuilder constructTopologyBuilder(String queryPlanString, String executionPlanName, int tenantId, DistributedConfiguration stormDeploymentConfig) throws XMLStreamException, StormQueryConstructionException {
        OMElement eventProcessorElement;
        ComponentInfoHolder componentInfoHolder;
        String parallel;
        String name;
        OMElement queryPlanElement = AXIOMUtil.stringToOM((String)queryPlanString);
        TopologyInfoHolder topologyInfoHolder = new TopologyInfoHolder();
        TopologyBuilder builder = new TopologyBuilder();
        Iterator iterator = queryPlanElement.getChildrenWithName(new QName("event-receiver"));
        while (iterator.hasNext()) {
            OMElement eventReceiverElement = (OMElement)iterator.next();
            name = eventReceiverElement.getAttributeValue(new QName("name"));
            parallel = eventReceiverElement.getAttributeValue(new QName("parallel"));
            componentInfoHolder = new ComponentInfoHolder(name, ComponentInfoHolder.ComponentType.EVENT_RECEIVER_SPOUT);
            List<String> streamDefinitions = StormTopologyConstructor.getStreamDefinitions(eventReceiverElement.getFirstChildWithName(new QName("streams")));
            for (String streamDefinition : streamDefinitions) {
                componentInfoHolder.addInputStream(streamDefinition);
                componentInfoHolder.addOutputStream(streamDefinition);
            }
            componentInfoHolder.setDeclarer(builder.setSpout(name, (IRichSpout)new EventReceiverSpout(stormDeploymentConfig, streamDefinitions, executionPlanName, tenantId, stormDeploymentConfig.getManagementHeartbeatInterval()), (Number)Integer.parseInt(parallel)));
            topologyInfoHolder.addComponent(componentInfoHolder);
        }
        iterator = queryPlanElement.getChildrenWithName(new QName("event-processor"));
        while (iterator.hasNext()) {
            eventProcessorElement = (OMElement)iterator.next();
            name = eventProcessorElement.getAttributeValue(new QName("name"));
            parallel = eventProcessorElement.getAttributeValue(new QName("parallel"));
            String isEnforced = eventProcessorElement.getAttributeValue(new QName("enforceParallel"));
            ComponentInfoHolder componentInfoHolder2 = new ComponentInfoHolder(name, ComponentInfoHolder.ComponentType.SIDDHI_BOLT);
            OMElement inputStreamsElement = eventProcessorElement.getFirstChildWithName(new QName("input-streams"));
            List<String> inputStreamDefinitions = StormTopologyConstructor.getStreamDefinitions(inputStreamsElement);
            Iterator<Object> iterator2 = inputStreamDefinitions.iterator();
            while (iterator2.hasNext()) {
                String streamDefinition = iterator2.next();
                componentInfoHolder2.addInputStream(streamDefinition);
            }
            StormTopologyConstructor.addPartitionFields(inputStreamsElement, componentInfoHolder2);
            OMElement queryElement = eventProcessorElement.getFirstChildWithName(new QName("queries"));
            OMElement tableDefinitionElement = eventProcessorElement.getFirstChildWithName(new QName("table-definitions"));
            String queryWithEventTable = "";
            if (tableDefinitionElement != null) {
                queryWithEventTable = tableDefinitionElement.getText() + queryElement.getText();
            }
            componentInfoHolder2.addSiddhiQuery(queryWithEventTable);
            List<String> outputStreamDefinitions = StormTopologyConstructor.getStreamDefinitions(eventProcessorElement.getFirstChildWithName(new QName("output-streams")));
            Iterator<String> iterator3 = outputStreamDefinitions.iterator();
            while (iterator3.hasNext()) {
                String streamDefinition = iterator3.next();
                componentInfoHolder2.addOutputStream(streamDefinition);
            }
            BoltDeclarer declarer = builder.setBolt(name, (IBasicBolt)new SiddhiBolt(name, (List)inputStreamDefinitions, queryWithEventTable, (List)outputStreamDefinitions, executionPlanName, tenantId), (Number)Integer.parseInt(parallel));
            if (isEnforced.equals("true")) {
                declarer.setMaxTaskParallelism((Number)Integer.parseInt(parallel));
            }
            componentInfoHolder2.setDeclarer(declarer);
            topologyInfoHolder.addComponent(componentInfoHolder2);
        }
        iterator = queryPlanElement.getChildrenWithName(new QName("event-publisher"));
        while (iterator.hasNext()) {
            eventProcessorElement = (OMElement)iterator.next();
            name = eventProcessorElement.getAttributeValue(new QName("name"));
            int parallel2 = Integer.parseInt(eventProcessorElement.getAttributeValue(new QName("parallel")));
            componentInfoHolder = new ComponentInfoHolder(name, ComponentInfoHolder.ComponentType.EVENT_PUBLISHER_BOLT);
            OMElement inputStreamsElement = eventProcessorElement.getFirstChildWithName(new QName("input-streams"));
            List<String> inputStreamDefinitions = StormTopologyConstructor.getStreamDefinitions(inputStreamsElement);
            for (String streamDefinition : inputStreamDefinitions) {
                componentInfoHolder.addInputStream(streamDefinition);
            }
            StormTopologyConstructor.addPartitionFields(inputStreamsElement, componentInfoHolder);
            OMElement queryElement = eventProcessorElement.getFirstChildWithName(new QName("queries"));
            OMElement tableDefinitionElement = eventProcessorElement.getFirstChildWithName(new QName("table-definitions"));
            String query = "";
            if (tableDefinitionElement != null) {
                query = tableDefinitionElement.getText();
            }
            if (queryElement != null) {
                query = query + queryElement.getText();
                componentInfoHolder.addSiddhiQuery(query);
            }
            List<String> outputStreamDefinitions = StormTopologyConstructor.getStreamDefinitions(eventProcessorElement.getFirstChildWithName(new QName("output-streams")));
            for (String streamDefinition : outputStreamDefinitions) {
                componentInfoHolder.addOutputStream(streamDefinition);
            }
            componentInfoHolder.setDeclarer(builder.setBolt(name, (IBasicBolt)new EventPublisherBolt(stormDeploymentConfig, inputStreamDefinitions, outputStreamDefinitions, query, executionPlanName, tenantId), (Number)parallel2));
            topologyInfoHolder.addComponent(componentInfoHolder);
            StormStatusHolderInitializer.initializeStatusHolder(executionPlanName, tenantId, parallel2);
        }
        iterator = queryPlanElement.getChildrenWithName(new QName("trigger"));
        while (iterator.hasNext()) {
            OMElement triggerElement = (OMElement)iterator.next();
            name = triggerElement.getAttributeValue(new QName("name"));
            ComponentInfoHolder componentInfoHolder3 = new ComponentInfoHolder("TriggerSpout_" + name, ComponentInfoHolder.ComponentType.TRIGGER_SPOUT);
            OMElement triggerDefinitionElement = triggerElement.getFirstChildWithName(new QName("trigger-definition"));
            String triggerDefinition = triggerDefinitionElement.getText();
            OMElement outputStreamElement = triggerElement.getFirstChildWithName(new QName("output-stream"));
            String outputStream = outputStreamElement.getText();
            componentInfoHolder3.addOutputStream(outputStream);
            componentInfoHolder3.setDeclarer(builder.setSpout("TriggerSpout_" + name, (IRichSpout)new TriggerSpout(name, triggerDefinition, executionPlanName, tenantId), (Number)1));
            topologyInfoHolder.addComponent(componentInfoHolder3);
        }
        topologyInfoHolder.indexComponents();
        for (ComponentInfoHolder componentInfoHolder4 : topologyInfoHolder.getComponents()) {
            if (componentInfoHolder4.getComponentType() == ComponentInfoHolder.ComponentType.EVENT_RECEIVER_SPOUT || componentInfoHolder4.getComponentType() == ComponentInfoHolder.ComponentType.TRIGGER_SPOUT) continue;
            BoltDeclarer boltDeclarer = (BoltDeclarer)componentInfoHolder4.getDeclarer();
            for (String inputStreamId : componentInfoHolder4.getInputStreamIds()) {
                if (topologyInfoHolder.getPublishingComponents(inputStreamId) != null) {
                    for (ComponentInfoHolder pubComponent : topologyInfoHolder.getPublishingComponents(inputStreamId)) {
                        if (pubComponent.getComponentType() == ComponentInfoHolder.ComponentType.EVENT_PUBLISHER_BOLT || pubComponent.getComponentName().equals(componentInfoHolder4.getComponentName())) continue;
                        String partitionedField = componentInfoHolder4.getPartionenedField(inputStreamId);
                        String groupingType = "ShuffleGrouping";
                        if (partitionedField == null) {
                            boltDeclarer.shuffleGrouping(pubComponent.getComponentName(), inputStreamId);
                        } else {
                            groupingType = "FieldGrouping";
                            boltDeclarer.fieldsGrouping(pubComponent.getComponentName(), inputStreamId, new Fields(new String[]{partitionedField}));
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Connecting storm components [Consumer:" + componentInfoHolder4.getComponentName() + ", Stream:" + inputStreamId + ", Publisher:" + pubComponent.getComponentName() + ", Grouping:" + groupingType + "]"));
                    }
                    continue;
                }
                throw new StormQueryConstructionException("No corresponding stream imported for Siddhi stream : " + inputStreamId);
            }
        }
        return builder;
    }

    private static List<String> getStreamDefinitions(OMElement streamsElement) {
        ArrayList<String> streamDefinitions = new ArrayList<String>();
        Iterator streamIterator = streamsElement.getChildrenWithName(new QName("stream"));
        while (streamIterator.hasNext()) {
            OMElement streamElement = (OMElement)streamIterator.next();
            String streamDefinition = streamElement.getText();
            streamDefinitions.add(streamDefinition);
        }
        return streamDefinitions;
    }

    private static void addPartitionFields(OMElement streamsElement, ComponentInfoHolder componentInfoHolder) throws StormQueryConstructionException {
        Iterator streamIterator = streamsElement.getChildrenWithName(new QName("stream"));
        while (streamIterator.hasNext()) {
            OMElement streamElement = (OMElement)streamIterator.next();
            OMAttribute partitionAttribute = streamElement.getAttribute(new QName("partition"));
            if (partitionAttribute == null) continue;
            StreamDefinition streamDefinition = SiddhiCompiler.parseStreamDefinition((String)streamElement.getText());
            if (!Arrays.asList(streamDefinition.getAttributeNameArray()).contains(partitionAttribute.getAttributeValue())) {
                throw new StormQueryConstructionException("All input streams of the partition should have the partitioning attribute.");
            }
            componentInfoHolder.addStreamPartitioningField(streamDefinition.getId(), partitionAttribute.getAttributeValue());
        }
    }
}

