/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.util;

import java.util.HashSet;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.event.processor.core.exception.StormQueryConstructionException;

public class StormQueryPlanValidator {
    private static XPathFactory xPathfactory = XPathFactory.newInstance();

    public static void validateQueryPlan(Document queryPlan) throws StormQueryConstructionException {
        StormQueryPlanValidator.validatePublishingStreams(queryPlan);
    }

    private static void validatePublishingStreams(Document queryPlan) throws StormQueryConstructionException {
        try {
            HashSet<String> allEmittedStreams = new HashSet<String>();
            allEmittedStreams.addAll(StormQueryPlanValidator.extractStreamIds(StormQueryPlanValidator.getEventProcessorOutputStreams(queryPlan)));
            allEmittedStreams.addAll(StormQueryPlanValidator.extractStreamIds(StormQueryPlanValidator.getEventReceiverStreams(queryPlan)));
            for (String publisherInputStream : StormQueryPlanValidator.extractStreamIds(StormQueryPlanValidator.getEventPublisherInputStreams(queryPlan))) {
                if (allEmittedStreams.contains(publisherInputStream)) continue;
                throw new StormQueryConstructionException("Event publisher bolt(s) trying to consume stream '" + publisherInputStream + "', but it's not produced by any bolt/spout.");
            }
        }
        catch (XPathExpressionException e) {
            throw new StormQueryConstructionException("Failed to validate query plan. Error :" + e.getMessage());
        }
    }

    private static Set<String> getEventReceiverStreams(Document queryPlan) throws XPathExpressionException {
        XPath xpath = xPathfactory.newXPath();
        String xPathExpression = "/storm-query-plan/event-receiver/streams/stream";
        XPathExpression expr = xpath.compile(xPathExpression);
        NodeList list = (NodeList)expr.evaluate(queryPlan, XPathConstants.NODESET);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            result.add(node.getTextContent());
        }
        return result;
    }

    private static Set<String> getEventProcessorOutputStreams(Document queryPlan) throws XPathExpressionException {
        XPath xpath = xPathfactory.newXPath();
        String xPathExpression = "/storm-query-plan/event-processor/output-streams/stream";
        XPathExpression expr = xpath.compile(xPathExpression);
        NodeList list = (NodeList)expr.evaluate(queryPlan, XPathConstants.NODESET);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            result.add(node.getTextContent());
        }
        return result;
    }

    private static Set<String> getEventPublisherInputStreams(Document queryPlan) throws XPathExpressionException {
        XPath xpath = xPathfactory.newXPath();
        String xPathExpression = "/storm-query-plan/event-publisher/input-streams/stream";
        XPathExpression expr = xpath.compile(xPathExpression);
        NodeList list = (NodeList)expr.evaluate(queryPlan, XPathConstants.NODESET);
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            result.add(node.getTextContent());
        }
        return result;
    }

    private static Set<String> extractStreamIds(Set<String> streamDefinitions) {
        HashSet<String> streamIds = new HashSet<String>();
        for (String streamDefinition : streamDefinitions) {
            streamIds.add(StormQueryPlanValidator.extractStreamId(streamDefinition));
        }
        return streamIds;
    }

    private static String extractStreamId(String streamDefinition) {
        return streamDefinition.split(" ")[2];
    }
}

