/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.exception.StormQueryConstructionException;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.storm.compiler.SiddhiQLStormQuerySplitter;
import org.wso2.carbon.event.processor.core.internal.storm.util.ExecutionElementInfoHolder;
import org.wso2.carbon.event.processor.core.internal.storm.util.ParallelismInfoHolder;
import org.wso2.carbon.event.processor.core.internal.storm.util.QueryGroupInfoHolder;
import org.wso2.carbon.event.processor.core.internal.storm.util.StormQueryPlanValidator;
import org.wso2.carbon.event.processor.core.internal.util.EventProcessorUtil;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.definition.TriggerDefinition;
import org.wso2.siddhi.query.api.execution.ExecutionElement;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;
import org.wso2.siddhi.query.compiler.exception.SiddhiParserException;

public class StormQueryPlanBuilder {
    public static Document constructStormQueryPlanXML(ExecutionPlanConfiguration configuration, List<String> importStreams, List<String> exportStreams) throws StormQueryConstructionException {
        Document document;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element rootElement = document.createElement("storm-query-plan");
            document.appendChild(rootElement);
            Element receiverElement = StormQueryPlanBuilder.constructReceiverElement(document, configuration.getExecutionPlan(), importStreams);
            Element publisherElement = StormQueryPlanBuilder.constructPublisherElement(document, configuration.getExecutionPlan(), exportStreams);
            List<Element> triggerProcessorElements = StormQueryPlanBuilder.constructTriggerElement(document, configuration.getExecutionPlan());
            List<Element> processorElements = StormQueryPlanBuilder.constructProcessorElement(document, configuration.getExecutionPlan(), importStreams, exportStreams);
            rootElement.appendChild(receiverElement);
            for (Element processorElement : processorElements) {
                rootElement.appendChild(processorElement);
            }
            for (Element triggerProcessorElement : triggerProcessorElements) {
                rootElement.appendChild(triggerProcessorElement);
            }
            rootElement.appendChild(publisherElement);
            StormQueryPlanValidator.validateQueryPlan(document);
        }
        catch (ParserConfigurationException e) {
            throw new StormQueryConstructionException("Error when creating storm query configuration.", e);
        }
        catch (EventStreamConfigurationException e) {
            throw new StormQueryConstructionException("Error when retrieving stream definitions in order to create storm query configuration", e);
        }
        catch (SiddhiParserException e) {
            throw new StormQueryConstructionException("Provided Siddhi query contains errors", e);
        }
        return document;
    }

    private static Element constructReceiverElement(Document document, String queryExpressions, List<String> importedStreams) throws EventStreamConfigurationException {
        Element receiverElement = document.createElement("event-receiver");
        receiverElement.setAttribute("name", "EventReceiverSpout");
        ExecutionPlan executionPlan = SiddhiCompiler.parse((String)queryExpressions);
        receiverElement.setAttribute("parallel", String.valueOf(StormQueryPlanBuilder.getParallelism(executionPlan.getAnnotations(), "receiverParallelism")));
        Element streams = document.createElement("streams");
        for (String definition : importedStreams) {
            Element stream = StormQueryPlanBuilder.getStreamElement(document, definition);
            streams.appendChild(stream);
        }
        receiverElement.appendChild(streams);
        return receiverElement;
    }

    private static Element constructPublisherElement(Document document, String queryExpressions, List<String> exportedStreams) throws EventStreamConfigurationException {
        Element publisherElement = document.createElement("event-publisher");
        Element publisherInputStream = document.createElement("input-streams");
        Element publisherOutputStream = document.createElement("output-streams");
        publisherElement.setAttribute("name", "EventPublisherBolt");
        ExecutionPlan executionPlan = SiddhiCompiler.parse((String)queryExpressions);
        publisherElement.setAttribute("parallel", String.valueOf(StormQueryPlanBuilder.getParallelism(executionPlan.getAnnotations(), "publisherParallelism")));
        for (String definition : exportedStreams) {
            Element stream = StormQueryPlanBuilder.getStreamElement(document, definition);
            publisherOutputStream.appendChild(stream);
            Element clonedStream = (Element)stream.cloneNode(true);
            publisherInputStream.appendChild(clonedStream);
        }
        publisherElement.appendChild(publisherInputStream);
        publisherElement.appendChild(publisherOutputStream);
        return publisherElement;
    }

    private static List<Element> constructTriggerElement(Document document, String queryExpression) throws StormQueryConstructionException {
        ExecutionPlanRuntime executionPlanRuntime = EventProcessorValueHolder.getSiddhiManager().createExecutionPlanRuntime(queryExpression);
        Map streamDefinitionMap = executionPlanRuntime.getStreamDefinitionMap();
        executionPlanRuntime.shutdown();
        ExecutionPlan executionPlan = SiddhiCompiler.parse((String)queryExpression);
        ArrayList<Element> triggerElementList = new ArrayList<Element>();
        for (Map.Entry entry : executionPlan.getTriggerDefinitionMap().entrySet()) {
            Element triggerElement = document.createElement("trigger");
            ParallelismInfoHolder holder = new ParallelismInfoHolder(1, false);
            StormQueryPlanBuilder.setAttributes(triggerElement, (String)entry.getKey(), holder);
            String getTriggerDefinition = EventProcessorUtil.getTriggerDefinitionString((TriggerDefinition)entry.getValue());
            Element triggerDefinitionElement = document.createElement("trigger-definition");
            triggerDefinitionElement.setTextContent(getTriggerDefinition);
            triggerElement.appendChild(triggerDefinitionElement);
            String outputStreamDefinition = EventProcessorUtil.getDefinitionString((AbstractDefinition)streamDefinitionMap.get(entry.getKey()));
            Element outputStreamElement = document.createElement("output-stream");
            outputStreamElement.setTextContent(outputStreamDefinition);
            triggerElement.appendChild(outputStreamElement);
            triggerElementList.add(triggerElement);
        }
        return triggerElementList;
    }

    private static List<Element> constructProcessorElement(Document document, String queryExpressions, List<String> importedStreams, List<String> exportedStreams) throws SiddhiParserException, StormQueryConstructionException {
        ExecutionPlanRuntime executionPlanRuntime = EventProcessorValueHolder.getSiddhiManager().createExecutionPlanRuntime(queryExpressions);
        Map streamDefinitionMap = executionPlanRuntime.getStreamDefinitionMap();
        executionPlanRuntime.shutdown();
        ArrayList<Element> processorElementList = new ArrayList<Element>();
        List<String> stringQueryList = SiddhiQLStormQuerySplitter.split(queryExpressions);
        List<String> eventTableDefinitionList = SiddhiQLStormQuerySplitter.getEventTableList(queryExpressions);
        ExecutionPlan executionPlan = SiddhiCompiler.parse((String)queryExpressions);
        List executionElements = executionPlan.getExecutionElementList();
        Set<String> eventTableIdSet = executionPlan.getTableDefinitionMap().keySet();
        Map<String, QueryGroupInfoHolder> groupIdToQueryMap = StormQueryPlanBuilder.getGroupIdToQueryMap(eventTableIdSet, executionElements, stringQueryList, exportedStreams);
        for (Map.Entry<String, QueryGroupInfoHolder> entry : groupIdToQueryMap.entrySet()) {
            String name = entry.getKey();
            QueryGroupInfoHolder infoHolder = entry.getValue();
            ParallelismInfoHolder holder = StormQueryPlanBuilder.getParallelismForGroup(entry.getKey(), infoHolder.getExecutionElements());
            Element processor = document.createElement("event-processor");
            StormQueryPlanBuilder.setAttributes(processor, name, holder);
            Element tableDefinitions = document.createElement("table-definitions");
            ArrayList<String> querySpecificEventTableDefinitionList = new ArrayList<String>();
            ArrayList<String> querySpecificEventTableIdList = new ArrayList<String>();
            String stringQueries = StormQueryPlanBuilder.getQueryString(entry.getValue().getStringQueries());
            for (String evenTableId : eventTableIdSet) {
                if (!stringQueries.contains(evenTableId)) continue;
                for (String evenTableDefinition : eventTableDefinitionList) {
                    if (!evenTableDefinition.contains(evenTableId)) continue;
                    querySpecificEventTableDefinitionList.add(evenTableDefinition);
                    querySpecificEventTableIdList.add(evenTableId);
                }
            }
            String stringTableDefinitions = StormQueryPlanBuilder.getEventTableDefinitionString(querySpecificEventTableDefinitionList);
            tableDefinitions.setTextContent(stringTableDefinitions);
            processor.appendChild(tableDefinitions);
            ArrayList<String> inputDefinitionIds = new ArrayList<String>(infoHolder.getInputDefinitionIds());
            inputDefinitionIds.removeAll(querySpecificEventTableIdList);
            Element inputStream = StormQueryPlanBuilder.getProcessorInputStream(document, inputDefinitionIds, streamDefinitionMap, infoHolder.getPartitionFieldMap());
            processor.appendChild(inputStream);
            Element queries = document.createElement("queries");
            queries.setTextContent(stringQueries);
            processor.appendChild(queries);
            Element outputStream = StormQueryPlanBuilder.getProcessorOutputStream(document, new ArrayList<String>(entry.getValue().getOutputDefinitionIds()), streamDefinitionMap);
            processor.appendChild(outputStream);
            processorElementList.add(processor);
        }
        return processorElementList;
    }

    private static void setAttributes(Element processor, String name, ParallelismInfoHolder holder) throws StormQueryConstructionException {
        if (name.matches(".*\\s+.*")) {
            throw new StormQueryConstructionException("Query name '" + name + "' is not valid, it must not contain spaces.");
        }
        String parallel = String.valueOf(holder.getParallelism());
        Boolean enforceParallelism = holder.getIsEnforced();
        processor.setAttribute("name", name);
        processor.setAttribute("parallel", parallel);
        processor.setAttribute("enforceParallel", String.valueOf(enforceParallelism));
    }

    private static Map<String, QueryGroupInfoHolder> getGroupIdToQueryMap(Set<String> eventTableIdSet, List<ExecutionElement> executionElements, List<String> stringQueryList, List<String> exportedStreams) throws StormQueryConstructionException {
        HashMap<String, QueryGroupInfoHolder> groupIdToQueryMap = new HashMap<String, QueryGroupInfoHolder>();
        for (int i = 0; i < executionElements.size(); ++i) {
            String name = StormQueryPlanBuilder.getName(executionElements.get(i).getAnnotations());
            String groupId = StormQueryPlanBuilder.getExecuteGroup(executionElements.get(i).getAnnotations());
            if (groupId == null) {
                groupId = name;
            }
            int parallel = StormQueryPlanBuilder.getParallelism(executionElements.get(i).getAnnotations(), "parallel");
            if (executionElements.get(i) instanceof Query) {
                Query query = (Query)executionElements.get(i);
                Boolean enforceParallelism = StormQueryPlanBuilder.validateParallelism(query, parallel, stringQueryList.get(i));
                QueryGroupInfoHolder infoHolder = (QueryGroupInfoHolder)groupIdToQueryMap.get(groupId);
                if (infoHolder != null) {
                    infoHolder.addExecutionElement(new ExecutionElementInfoHolder((ExecutionElement)query, parallel, enforceParallelism));
                    infoHolder.addQueryString(stringQueryList.get(i));
                } else {
                    infoHolder = new QueryGroupInfoHolder(groupId);
                    infoHolder.addQueryString(stringQueryList.get(i));
                    infoHolder.addExecutionElement(new ExecutionElementInfoHolder((ExecutionElement)query, parallel, enforceParallelism));
                    groupIdToQueryMap.put(groupId, infoHolder);
                }
                infoHolder.getOutputDefinitionIds().removeAll(eventTableIdSet);
                continue;
            }
            Partition partition = (Partition)executionElements.get(i);
            for (Query query : partition.getQueryList()) {
                StormQueryPlanBuilder.validateParallelism(query, -1, stringQueryList.get(i));
            }
            QueryGroupInfoHolder infoHolder = (QueryGroupInfoHolder)groupIdToQueryMap.get(groupId);
            if (infoHolder != null) {
                throw new StormQueryConstructionException("Error deploying partition " + groupId + ". Query, Partition or execute group of same name has been defined earlier");
            }
            infoHolder = new QueryGroupInfoHolder(groupId);
            infoHolder.addExecutionElement(new ExecutionElementInfoHolder((ExecutionElement)partition, parallel, false));
            infoHolder.addQueryString(stringQueryList.get(i));
            groupIdToQueryMap.put(groupId, infoHolder);
        }
        exportedStreams.removeAll(eventTableIdSet);
        ArrayList<String> exportedStreamIds = new ArrayList<String>(exportedStreams.size());
        for (String definitionString : exportedStreams) {
            StreamDefinition definition = SiddhiCompiler.parseStreamDefinition((String)definitionString);
            exportedStreamIds.add(definition.getId());
        }
        StormQueryPlanBuilder.removeUnusedStreams(groupIdToQueryMap, exportedStreamIds);
        return groupIdToQueryMap;
    }

    private static Boolean validateParallelism(Query query, int parallel, String queryString) throws StormQueryConstructionException {
        if (parallel != -1) {
            if (!(query.getInputStream() instanceof BasicSingleInputStream)) {
                if (parallel > 1) {
                    throw new StormQueryConstructionException("Error in deploying query: " + queryString + " Parallelism has to be 1 for window, join and pattern queries. Partitioning can be used to facilitate such scenarios");
                }
                return true;
            }
            return false;
        }
        for (Annotation annotation : query.getAnnotations()) {
            if (!annotation.getName().equals("dist")) continue;
            throw new StormQueryConstructionException("Error in deploying query: " + queryString + ". Query level @dist type annotations are not supported for queries inside partitions. Please resubmit the execution plan moving those annotation to Partition level.");
        }
        return false;
    }

    private static void removeUnusedStreams(Map<String, QueryGroupInfoHolder> groupIdToQueryMap, List<String> exportedStreams) {
        for (Map.Entry<String, QueryGroupInfoHolder> entry : groupIdToQueryMap.entrySet()) {
            Iterator<String> iterator;
            QueryGroupInfoHolder holder = entry.getValue();
            if (holder.getInputDefinitionIds().size() > 1) {
                iterator = holder.getInputDefinitionIds().iterator();
                while (iterator.hasNext()) {
                    String streamId = iterator.next();
                    if (!holder.getOutputDefinitionIds().contains(streamId)) continue;
                    iterator.remove();
                }
            }
            if (holder.getOutputDefinitionIds().size() <= 1) continue;
            iterator = holder.getOutputDefinitionIds().iterator();
            while (iterator.hasNext()) {
                Boolean isUnused = true;
                String streamId = iterator.next();
                if (exportedStreams.contains(streamId)) continue;
                for (Map.Entry<String, QueryGroupInfoHolder> entry2 : groupIdToQueryMap.entrySet()) {
                    if (entry.getKey().equals(entry2.getKey()) || !entry2.getValue().getInputDefinitionIds().contains(streamId)) continue;
                    isUnused = false;
                    break;
                }
                if (!isUnused.booleanValue()) continue;
                iterator.remove();
            }
        }
    }

    private static String getName(List<Annotation> annotations) {
        String name = UUID.randomUUID().toString();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.getName().equals("name")) continue;
                name = ((org.wso2.siddhi.query.api.annotation.Element)annotation.getElements().get(0)).getValue();
            }
        }
        return name;
    }

    private static int getParallelism(List<Annotation> annotations, String elementKey) {
        int parallelism = 1;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.getName().equals("dist") || annotation.getElement(elementKey) == null) continue;
                parallelism = Integer.parseInt(annotation.getElement(elementKey));
                if (parallelism == 0) {
                    parallelism = 1;
                }
                return parallelism;
            }
        }
        return parallelism;
    }

    private static String getExecuteGroup(List<Annotation> annotations) {
        String id = null;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.getName().equals("dist") || annotation.getElement("execGroup") == null) continue;
                id = annotation.getElement("execGroup");
            }
        }
        return id;
    }

    private static String getQueryString(List<String> stringQueries) {
        StringBuilder builder = new StringBuilder();
        for (String query : stringQueries) {
            builder.append(query.trim()).append(";");
        }
        return builder.toString();
    }

    private static String getEventTableDefinitionString(List<String> eventTableDefinitionList) {
        StringBuilder builder = new StringBuilder();
        for (String eventTableDefinition : eventTableDefinitionList) {
            builder.append(eventTableDefinition.trim()).append(";");
        }
        return builder.toString();
    }

    private static ParallelismInfoHolder getParallelismForGroup(String groupId, List<ExecutionElementInfoHolder> executionElementHolders) throws StormQueryConstructionException {
        Boolean isEnforced = false;
        HashSet<Integer> parallelism = new HashSet<Integer>();
        for (ExecutionElementInfoHolder element : executionElementHolders) {
            parallelism.add(element.getParallelismInfoHolder().getParallelism());
            if (!element.getParallelismInfoHolder().getIsEnforced().booleanValue()) continue;
            isEnforced = true;
        }
        if (parallelism.size() == 1) {
            return new ParallelismInfoHolder((Integer)parallelism.iterator().next(), isEnforced);
        }
        throw new StormQueryConstructionException("Parallelism for each query in a query group should be same. Multiple parallel values encountered in query group " + groupId);
    }

    private static Element getProcessorOutputStream(Document document, List<String> streamIds, Map<String, AbstractDefinition> streamDefinitionMap) {
        Element outputStream = document.createElement("output-streams");
        for (String streamId : streamIds) {
            Element stream = StormQueryPlanBuilder.getStreamElement(document, EventProcessorUtil.getDefinitionString(streamDefinitionMap.get(streamId)));
            outputStream.appendChild(stream);
        }
        return outputStream;
    }

    private static Element getProcessorInputStream(Document document, List<String> streamIds, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, String> partitionFieldMap) {
        Element inputStream = document.createElement("input-streams");
        for (String streamId : streamIds) {
            String attribute;
            Element stream = StormQueryPlanBuilder.getStreamElement(document, EventProcessorUtil.getDefinitionString(streamDefinitionMap.get(streamId)));
            if (partitionFieldMap != null && (attribute = partitionFieldMap.get(streamId)) != null) {
                stream.setAttribute("partition", attribute);
            }
            inputStream.appendChild(stream);
        }
        return inputStream;
    }

    private static Element getStreamElement(Document document, String definitionQuery) {
        Element stream = document.createElement("stream");
        stream.setTextContent(definitionQuery);
        return stream;
    }
}

