/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.event.processor.core.exception.StormQueryConstructionException;
import org.wso2.carbon.event.processor.core.internal.storm.util.ExecutionElementInfoHolder;
import org.wso2.siddhi.query.api.execution.partition.Partition;
import org.wso2.siddhi.query.api.execution.partition.PartitionType;
import org.wso2.siddhi.query.api.execution.partition.RangePartitionType;
import org.wso2.siddhi.query.api.execution.partition.ValuePartitionType;
import org.wso2.siddhi.query.api.execution.query.Query;
import org.wso2.siddhi.query.api.expression.Variable;

public class QueryGroupInfoHolder {
    private String groupId;
    private List<String> stringQueries;
    private List<ExecutionElementInfoHolder> executionElements;
    private Set<String> inputDefinitionIds;
    private Set<String> outputDefinitionIds;
    private Map<String, String> partitionFieldMap = null;

    public QueryGroupInfoHolder(String groupId) {
        this.groupId = groupId;
        this.stringQueries = new ArrayList<String>();
        this.executionElements = new ArrayList<ExecutionElementInfoHolder>();
        this.inputDefinitionIds = new HashSet<String>();
        this.outputDefinitionIds = new HashSet<String>();
    }

    public void addQueryString(String query) {
        this.stringQueries.add(query);
    }

    public void addExecutionElement(ExecutionElementInfoHolder infoHolder) throws StormQueryConstructionException {
        if (infoHolder.getExecutionElement() instanceof Query) {
            this.inputDefinitionIds.addAll(((Query)infoHolder.getExecutionElement()).getInputStream().getUniqueStreamIds());
            this.outputDefinitionIds.add(((Query)infoHolder.getExecutionElement()).getOutputStream().getId());
        } else {
            Partition partition = (Partition)infoHolder.getExecutionElement();
            for (Query query : partition.getQueryList()) {
                for (String id : query.getInputStream().getUniqueStreamIds()) {
                    if (id.contains("#")) continue;
                    this.inputDefinitionIds.add(id);
                }
                this.outputDefinitionIds.add(query.getOutputStream().getId());
            }
            for (PartitionType type : partition.getPartitionTypeMap().values()) {
                if (type instanceof RangePartitionType) {
                    throw new StormQueryConstructionException("Error in deploying Partition:" + this.getStringQueries().get(0) + " Range partitioning is not supported in distributed deployment");
                }
                if (!(type instanceof ValuePartitionType)) continue;
                if (this.partitionFieldMap == null) {
                    this.partitionFieldMap = new HashMap<String, String>();
                }
                if (((ValuePartitionType)type).getExpression() instanceof Variable) {
                    Variable variable = (Variable)((ValuePartitionType)type).getExpression();
                    this.partitionFieldMap.put(type.getStreamId(), variable.getAttributeName());
                    continue;
                }
                throw new StormQueryConstructionException("Error in deploying partition:" + this.getStringQueries().get(0) + ". Only Expressions of Type Variable will be admitted for distributed processing");
            }
        }
        this.executionElements.add(infoHolder);
    }

    public List<String> getStringQueries() {
        return this.stringQueries;
    }

    public List<ExecutionElementInfoHolder> getExecutionElements() {
        return this.executionElements;
    }

    public Set<String> getInputDefinitionIds() {
        return this.inputDefinitionIds;
    }

    public Set<String> getOutputDefinitionIds() {
        return this.outputDefinitionIds;
    }

    public Map<String, String> getPartitionFieldMap() {
        return this.partitionFieldMap;
    }
}

