/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.util;

import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;

public class ComponentInfoHolder {
    private ComponentType componentType;
    private String componentName = null;
    private Object declarer;
    private Map<String, StreamDefinition> inputStreams = new HashMap<String, StreamDefinition>();
    private Map<String, String> inputStreamPartitoningFields = new HashMap<String, String>();
    private Map<String, StreamDefinition> outputStreams = new HashMap<String, StreamDefinition>();
    private int parallelism = 1;
    private String query;

    public ComponentInfoHolder(String componentName, ComponentType componentType) {
        this.componentName = componentName;
        this.componentType = componentType;
    }

    public void addSiddhiQuery(String query) {
        this.query = query;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public void addInputStream(String streamDefinition) {
        StreamDefinition siddhiStreamDefinition = SiddhiCompiler.parseStreamDefinition((String)streamDefinition);
        this.inputStreams.put(siddhiStreamDefinition.getId(), siddhiStreamDefinition);
    }

    public void addStreamPartitioningField(String streamId, String partitioningField) {
        if (this.componentType != ComponentType.EVENT_RECEIVER_SPOUT) {
            this.inputStreamPartitoningFields.put(streamId, partitioningField);
        }
    }

    public void addOutputStream(String streamDefinition) {
        StreamDefinition siddhiStreamDefinition = SiddhiCompiler.parseStreamDefinition((String)streamDefinition);
        this.outputStreams.put(siddhiStreamDefinition.getId(), siddhiStreamDefinition);
    }

    public String[] getInputStreamIds() {
        return this.inputStreams.keySet().toArray(new String[this.inputStreams.size()]);
    }

    public String[] getOutputStreamIds() {
        return this.outputStreams.keySet().toArray(new String[this.inputStreams.size()]);
    }

    public String getPartionenedField(String streamId) {
        return this.inputStreamPartitoningFields.get(streamId);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public void setDeclarer(Object declarer) {
        this.declarer = declarer;
    }

    public Object getDeclarer() {
        return this.declarer;
    }

    public static enum ComponentType {
        EVENT_RECEIVER_SPOUT,
        SIDDHI_BOLT,
        EVENT_PUBLISHER_BOLT,
        TRIGGER_SPOUT;

    }
}

