/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.status.monitor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.thrift.utils.HostAddressFinder;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.storm.StormTopologyManager;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.exception.DeploymentStatusMonitorException;
import org.wso2.carbon.event.processor.core.util.ExecutionPlanStatusHolder;
import org.wso2.carbon.event.processor.manager.commons.transport.server.ConnectionCallback;

public class StormStatusMonitor
implements ConnectionCallback {
    private static final Log log = LogFactory.getLog(StormStatusMonitor.class);
    private final String stormTopologyName;
    private final String executionPlanName;
    private final String executionPlanStatusHolderKey;
    private final ExecutorService executorService;
    private final int lockTimeout;
    private final String tenantDomain;
    private String hostIp = null;
    private AtomicInteger connectedCepReceiversCount;
    private int importedStreamsCount = 0;
    private AtomicInteger connectedPublisherBoltsCount;

    public StormStatusMonitor(int tenantId, String executionPlanName, int importedStreamsCount) throws DeploymentStatusMonitorException {
        if (EventProcessorValueHolder.getHazelcastInstance() == null) {
            throw new DeploymentStatusMonitorException("Couldn't initialize Distributed Deployment Status monitor as the hazelcast instance is null. Enable clustering and restart the server");
        }
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Thread pool- component - StormStatusMonitor.executorService;tenantId - " + tenantId + ";executionPlanName - " + executionPlanName).build());
        this.tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        this.connectedCepReceiversCount = new AtomicInteger(0);
        this.connectedPublisherBoltsCount = new AtomicInteger(0);
        try {
            this.hostIp = HostAddressFinder.findAddress((String)"localhost");
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.importedStreamsCount = importedStreamsCount;
        this.executionPlanName = executionPlanName;
        this.stormTopologyName = StormTopologyManager.getTopologyName(executionPlanName, tenantId);
        this.executionPlanStatusHolderKey = "org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui." + this.stormTopologyName;
        this.lockTimeout = EventProcessorValueHolder.getStormDeploymentConfiguration().getStatusLockTimeout();
        this.executorService.execute(new GlobalStatUpdater());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCepReceiverConnect() {
        block13: {
            HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
            if (hazelcastInstance != null && hazelcastInstance.getLifecycleService().isRunning()) {
                IMap executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
                try {
                    if (this.hostIp == null) {
                        this.hostIp = HostAddressFinder.findAddress((String)"localhost");
                    }
                    if (executionPlanStatusHolderIMap.tryLock((Object)this.executionPlanStatusHolderKey, (long)this.lockTimeout, TimeUnit.MILLISECONDS)) {
                        try {
                            ExecutionPlanStatusHolder executionPlanStatusHolder = (ExecutionPlanStatusHolder)executionPlanStatusHolderIMap.get((Object)this.stormTopologyName);
                            if (executionPlanStatusHolder == null) {
                                log.error((Object)("Couldn't increment connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as status object not initialized by manager."));
                            } else {
                                executionPlanStatusHolder.setCEPReceiverStatus(this.hostIp, this.connectedCepReceiversCount.incrementAndGet(), this.importedStreamsCount);
                                executionPlanStatusHolderIMap.replace((Object)this.stormTopologyName, (Object)executionPlanStatusHolder);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Incremented connected CEP receiver count as " + this.connectedCepReceiversCount.get() + " for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + ", for IP address: " + this.hostIp));
                                }
                            }
                            break block13;
                        }
                        finally {
                            executionPlanStatusHolderIMap.unlock((Object)this.executionPlanStatusHolderKey);
                        }
                    }
                    log.error((Object)("Couldn't increment connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition failed."));
                }
                catch (InterruptedException e) {
                    log.error((Object)("Couldn't increment connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition was interrupted."), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (SocketException e) {
                    log.error((Object)("Couldn't increment connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the host IP couldn't be found for this node."), (Throwable)e);
                }
            } else {
                log.error((Object)("Couldn't increment connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast instance is not active or not available."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCepReceiverDisconnect() {
        block13: {
            HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
            if (hazelcastInstance != null && hazelcastInstance.getLifecycleService().isRunning()) {
                IMap executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
                try {
                    if (this.hostIp == null) {
                        this.hostIp = HostAddressFinder.findAddress((String)"localhost");
                    }
                    if (executionPlanStatusHolderIMap.tryLock((Object)this.executionPlanStatusHolderKey, (long)this.lockTimeout, TimeUnit.MILLISECONDS)) {
                        try {
                            ExecutionPlanStatusHolder executionPlanStatusHolder = (ExecutionPlanStatusHolder)executionPlanStatusHolderIMap.get((Object)this.stormTopologyName);
                            if (executionPlanStatusHolder == null) {
                                log.error((Object)("Couldn't decrement connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as status object not initialized by manager."));
                            } else {
                                executionPlanStatusHolder.setCEPReceiverStatus(this.hostIp, this.connectedCepReceiversCount.decrementAndGet(), this.importedStreamsCount);
                                executionPlanStatusHolderIMap.replace((Object)this.stormTopologyName, (Object)executionPlanStatusHolder);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Decremented connected CEP receiver count as " + this.connectedCepReceiversCount.get() + " for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + ", for IP address: " + this.hostIp));
                                }
                            }
                            break block13;
                        }
                        finally {
                            executionPlanStatusHolderIMap.unlock((Object)this.executionPlanStatusHolderKey);
                        }
                    }
                    log.error((Object)("Couldn't decrement connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition failed."));
                }
                catch (InterruptedException e) {
                    log.error((Object)("Couldn't decrement connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition was interrupted."), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (SocketException e) {
                    log.error((Object)("Couldn't decrement connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the host IP couldn't be found for this node."), (Throwable)e);
                }
            } else {
                log.error((Object)("Couldn't decrement connected CEP receivers count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast instance is not active or not available."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPublisherBoltConnect() {
        block13: {
            HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
            if (hazelcastInstance != null && hazelcastInstance.getLifecycleService().isRunning()) {
                IMap executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
                try {
                    if (this.hostIp == null) {
                        this.hostIp = HostAddressFinder.findAddress((String)"localhost");
                    }
                    if (executionPlanStatusHolderIMap.tryLock((Object)this.executionPlanStatusHolderKey, (long)this.lockTimeout, TimeUnit.MILLISECONDS)) {
                        try {
                            ExecutionPlanStatusHolder executionPlanStatusHolder = (ExecutionPlanStatusHolder)executionPlanStatusHolderIMap.get((Object)this.stormTopologyName);
                            if (executionPlanStatusHolder == null) {
                                log.error((Object)("Couldn't increment connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as status object not initialized by manager."));
                            } else {
                                executionPlanStatusHolder.setConnectedPublisherBoltsCount(this.hostIp, this.connectedPublisherBoltsCount.incrementAndGet());
                                executionPlanStatusHolderIMap.replace((Object)this.stormTopologyName, (Object)executionPlanStatusHolder);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Incremented connected publisher bolt count as " + this.connectedPublisherBoltsCount.get() + " for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + ", for IP address: " + this.hostIp));
                                }
                            }
                            break block13;
                        }
                        finally {
                            executionPlanStatusHolderIMap.unlock((Object)this.executionPlanStatusHolderKey);
                        }
                    }
                    log.error((Object)("Couldn't increment connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition failed."));
                }
                catch (InterruptedException e) {
                    log.error((Object)("Couldn't increment connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition was interrupted."), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (SocketException e) {
                    log.error((Object)("Couldn't increment connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the host IP couldn't be found for this node."), (Throwable)e);
                }
            } else {
                log.error((Object)("Couldn't increment connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast instance is not active or not available."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPublisherBoltDisconnect() {
        block13: {
            HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
            if (hazelcastInstance != null && hazelcastInstance.getLifecycleService().isRunning()) {
                IMap executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
                try {
                    if (this.hostIp == null) {
                        this.hostIp = HostAddressFinder.findAddress((String)"localhost");
                    }
                    if (executionPlanStatusHolderIMap.tryLock((Object)this.executionPlanStatusHolderKey, (long)this.lockTimeout, TimeUnit.MILLISECONDS)) {
                        try {
                            ExecutionPlanStatusHolder executionPlanStatusHolder = (ExecutionPlanStatusHolder)executionPlanStatusHolderIMap.get((Object)this.stormTopologyName);
                            if (executionPlanStatusHolder == null) {
                                log.error((Object)("Couldn't decrement connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as status object not initialized by manager."));
                            } else {
                                executionPlanStatusHolder.setConnectedPublisherBoltsCount(this.hostIp, this.connectedPublisherBoltsCount.decrementAndGet());
                                executionPlanStatusHolderIMap.replace((Object)this.stormTopologyName, (Object)executionPlanStatusHolder);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Decremented connected publisher bolt count as " + this.connectedPublisherBoltsCount.get() + " for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + ", for IP address: " + this.hostIp));
                                }
                            }
                            break block13;
                        }
                        finally {
                            executionPlanStatusHolderIMap.unlock((Object)this.executionPlanStatusHolderKey);
                        }
                    }
                    log.error((Object)("Couldn't decrement connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition failed."));
                }
                catch (InterruptedException e) {
                    log.error((Object)("Couldn't decrement connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition was interrupted."), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (SocketException e) {
                    log.error((Object)("Couldn't decrement connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the host IP couldn't be found for this node."), (Throwable)e);
                }
            } else {
                log.error((Object)("Couldn't decrement connected publisher bolts count for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast instance is not active or not available."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hazelcastListenerCallback() {
        block13: {
            HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
            if (hazelcastInstance != null && hazelcastInstance.getLifecycleService().isRunning()) {
                IMap executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
                try {
                    if (this.hostIp == null) {
                        this.hostIp = HostAddressFinder.findAddress((String)"localhost");
                    }
                    if (executionPlanStatusHolderIMap.tryLock((Object)this.executionPlanStatusHolderKey, (long)this.lockTimeout, TimeUnit.MILLISECONDS)) {
                        try {
                            ExecutionPlanStatusHolder executionPlanStatusHolder = (ExecutionPlanStatusHolder)executionPlanStatusHolderIMap.get((Object)this.stormTopologyName);
                            if (executionPlanStatusHolder == null) {
                                log.error((Object)("Couldn't update distributed deployment status for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as status object not initialized by manager."));
                            } else {
                                executionPlanStatusHolder.setCEPReceiverStatus(this.hostIp, this.connectedCepReceiversCount.get(), this.importedStreamsCount);
                                executionPlanStatusHolder.setConnectedPublisherBoltsCount(this.hostIp, this.connectedPublisherBoltsCount.get());
                                executionPlanStatusHolderIMap.replace((Object)this.stormTopologyName, (Object)executionPlanStatusHolder);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Updated distributed deployment status as follows. \nConnected CEP receivers count: " + this.connectedCepReceiversCount.get() + "\nConnected publisher bolts count: " + this.connectedPublisherBoltsCount.get() + "\nfor execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + ", for IP address: " + this.hostIp));
                                }
                            }
                            break block13;
                        }
                        finally {
                            executionPlanStatusHolderIMap.unlock((Object)this.executionPlanStatusHolderKey);
                        }
                    }
                    log.error((Object)("Couldn't update distributed deployment status for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition failed."));
                }
                catch (InterruptedException e) {
                    log.error((Object)("Couldn't update distributed deployment status for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast lock acquisition was interrupted."), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (SocketException e) {
                    log.error((Object)("Couldn't update distributed deployment status for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the host IP couldn't be found for this node."), (Throwable)e);
                }
            } else {
                log.error((Object)("Couldn't update distributed deployment status for execution plan: " + this.executionPlanName + ", for tenant-domain: " + this.tenantDomain + " as the hazelcast instance is not active or not available."));
            }
        }
    }

    public void shutdown() {
        this.executorService.shutdownNow();
    }

    static /* synthetic */ String access$000(StormStatusMonitor x0) {
        return x0.hostIp;
    }

    static /* synthetic */ String access$002(StormStatusMonitor x0, String x1) {
        x0.hostIp = x1;
        return x0.hostIp;
    }

    static /* synthetic */ String access$100(StormStatusMonitor x0) {
        return x0.executionPlanStatusHolderKey;
    }

    static /* synthetic */ int access$200(StormStatusMonitor x0) {
        return x0.lockTimeout;
    }

    static /* synthetic */ String access$300(StormStatusMonitor x0) {
        return x0.stormTopologyName;
    }

    static /* synthetic */ String access$400(StormStatusMonitor x0) {
        return x0.executionPlanName;
    }

    static /* synthetic */ String access$500(StormStatusMonitor x0) {
        return x0.tenantDomain;
    }

    static /* synthetic */ Log access$600() {
        return log;
    }

    static /* synthetic */ AtomicInteger access$700(StormStatusMonitor x0) {
        return x0.connectedCepReceiversCount;
    }

    static /* synthetic */ int access$800(StormStatusMonitor x0) {
        return x0.importedStreamsCount;
    }

    static /* synthetic */ AtomicInteger access$900(StormStatusMonitor x0) {
        return x0.connectedPublisherBoltsCount;
    }

    class GlobalStatUpdater
    implements Runnable {
        private final int updateRate = EventProcessorValueHolder.getStormDeploymentConfiguration().getStatusUpdateInterval();

        GlobalStatUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                if ((hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance()) != null && hazelcastInstance.getLifecycleService().isRunning()) {
                    executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
                    try {
                        if (StormStatusMonitor.access$000(StormStatusMonitor.this) == null) {
                            StormStatusMonitor.access$002(StormStatusMonitor.this, HostAddressFinder.findAddress((String)"localhost"));
                        }
                        if (executionPlanStatusHolderIMap.tryLock((Object)StormStatusMonitor.access$100(StormStatusMonitor.this), (long)StormStatusMonitor.access$200(StormStatusMonitor.this), TimeUnit.MILLISECONDS)) {
                            try {
                                executionPlanStatusHolder = (ExecutionPlanStatusHolder)executionPlanStatusHolderIMap.get((Object)StormStatusMonitor.access$300(StormStatusMonitor.this));
                                if (executionPlanStatusHolder == null) {
                                    StormStatusMonitor.access$600().error((Object)("Couldn't update distributed deployment status for execution plan: " + StormStatusMonitor.access$400(StormStatusMonitor.this) + ", for tenant-domain: " + StormStatusMonitor.access$500(StormStatusMonitor.this) + " as status object not initialized by manager."));
                                }
                                executionPlanStatusHolder.setCEPReceiverStatus(StormStatusMonitor.access$000(StormStatusMonitor.this), StormStatusMonitor.access$700(StormStatusMonitor.this).get(), StormStatusMonitor.access$800(StormStatusMonitor.this));
                                executionPlanStatusHolder.setConnectedPublisherBoltsCount(StormStatusMonitor.access$000(StormStatusMonitor.this), StormStatusMonitor.access$900(StormStatusMonitor.this).get());
                                executionPlanStatusHolderIMap.replace((Object)StormStatusMonitor.access$300(StormStatusMonitor.this), (Object)executionPlanStatusHolder);
                                if (!StormStatusMonitor.access$600().isDebugEnabled()) ** GOTO lbl34
                                StormStatusMonitor.access$600().debug((Object)("Updated distributed deployment status as follows. \nConnected CEP receivers count: " + StormStatusMonitor.access$700(StormStatusMonitor.this).get() + "\nConnected publisher bolts count: " + StormStatusMonitor.access$900(StormStatusMonitor.this).get() + "\nfor execution plan: " + StormStatusMonitor.access$400(StormStatusMonitor.this) + ", for tenant-domain: " + StormStatusMonitor.access$500(StormStatusMonitor.this) + ", for IP address: " + StormStatusMonitor.access$000(StormStatusMonitor.this)));
                            }
                            finally {
                                executionPlanStatusHolderIMap.unlock((Object)StormStatusMonitor.access$100(StormStatusMonitor.this));
                            }
                        }
                        StormStatusMonitor.access$600().error((Object)("Couldn't update distributed deployment status for execution plan: " + StormStatusMonitor.access$400(StormStatusMonitor.this) + ", for tenant-domain: " + StormStatusMonitor.access$500(StormStatusMonitor.this) + " as the hazelcast lock acquisition failed."));
                    }
                    catch (InterruptedException e) {
                        StormStatusMonitor.access$600().error((Object)("Couldn't update distributed deployment status for execution plan: " + StormStatusMonitor.access$400(StormStatusMonitor.this) + ", for tenant-domain: " + StormStatusMonitor.access$500(StormStatusMonitor.this) + " as the hazelcast lock acquisition was interrupted."), (Throwable)e);
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (SocketException e) {
                        StormStatusMonitor.access$600().error((Object)("Couldn't update distributed deployment status for execution plan: " + StormStatusMonitor.access$400(StormStatusMonitor.this) + ", for tenant-domain: " + StormStatusMonitor.access$500(StormStatusMonitor.this) + " as the host IP couldn't be found for this node."), (Throwable)e);
                    }
                } else {
                    StormStatusMonitor.access$600().error((Object)("Couldn't update distributed deployment status for execution plan: " + StormStatusMonitor.access$400(StormStatusMonitor.this) + ", for tenant-domain: " + StormStatusMonitor.access$500(StormStatusMonitor.this) + " as the hazelcast instance is not active or not available."));
                }
lbl34:
                // 6 sources

                try {
                    Thread.sleep(this.updateRate);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (StormStatusMonitor.access$600().isDebugEnabled()) {
                        StormStatusMonitor.access$600().debug((Object)("GlobalStatUpdater was interrupted, hence returning. Details: execution plan name: " + StormStatusMonitor.access$400(StormStatusMonitor.this) + ", tenant domain: " + StormStatusMonitor.access$500(StormStatusMonitor.this)));
                    }
                    return;
                }
            }
        }
    }
}

