/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.status.monitor;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.storm.StormTopologyManager;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.StormStatusMonitor;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.exception.DeploymentStatusMonitorException;

public class StormStatusMapListener {
    private static final Log log = LogFactory.getLog(StormStatusMapListener.class);
    private final String listenerId;
    private final HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
    private final StormStatusMonitor stormStatusMonitor;
    private String executionPlanName;
    private int tenantId;

    public StormStatusMapListener(String executionPlanName, int tenantId, StormStatusMonitor stormStatusMonitor) throws DeploymentStatusMonitorException {
        if (this.hazelcastInstance == null) {
            throw new DeploymentStatusMonitorException("Couldn't initialize Distributed Deployment Status monitor as the hazelcast instance is not available. Enable clustering and restart the server");
        }
        if (!this.hazelcastInstance.getLifecycleService().isRunning()) {
            throw new DeploymentStatusMonitorException("Couldn't initialize Distributed Deployment Status monitor as the hazelcast instance is not active.");
        }
        this.executionPlanName = executionPlanName;
        this.tenantId = tenantId;
        String stormTopologyName = StormTopologyManager.getTopologyName(executionPlanName, tenantId);
        this.listenerId = this.hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui").addEntryListener((MapListener)new MapListenerImpl(), (Object)stormTopologyName, true);
        this.stormStatusMonitor = stormStatusMonitor;
    }

    public void removeEntryListener() {
        if (this.hazelcastInstance == null) {
            log.error((Object)("Couldn't unregister entry listener for execution plan: " + this.executionPlanName + ", for tenant-ID: " + this.tenantId + " as the hazelcast instance is not available."));
        } else if (this.hazelcastInstance.getLifecycleService().isRunning()) {
            log.error((Object)("Couldn't unregister entry listener for execution plan: " + this.executionPlanName + ", for tenant-ID: " + this.tenantId + " as the hazelcast instance is not active."));
        } else {
            this.hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui").removeEntryListener(this.listenerId);
        }
    }

    private class MapListenerImpl
    implements EntryAddedListener,
    EntryUpdatedListener {
        private MapListenerImpl() {
        }

        public void entryAdded(EntryEvent entryEvent) {
            if (!entryEvent.getMember().localMember()) {
                StormStatusMapListener.this.stormStatusMonitor.hazelcastListenerCallback();
            }
        }

        public void entryUpdated(EntryEvent entryEvent) {
            if (!entryEvent.getMember().localMember()) {
                StormStatusMapListener.this.stormStatusMonitor.hazelcastListenerCallback();
            }
        }
    }
}

