/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.status.monitor;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.storm.StormTopologyManager;
import org.wso2.carbon.event.processor.core.util.ExecutionPlanStatusHolder;

public class StormStatusHolderInitializer {
    private static Log log = LogFactory.getLog(StormStatusHolderInitializer.class);

    public static void initializeStatusHolder(String executionPlanName, int tenantId, int parallel) {
        String stormTopologyName = StormTopologyManager.getTopologyName(executionPlanName, tenantId);
        HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
        if (hazelcastInstance != null && hazelcastInstance.getLifecycleService().isRunning()) {
            IMap executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
            ExecutionPlanStatusHolder executionPlanStatusHolder = new ExecutionPlanStatusHolder(parallel);
            executionPlanStatusHolderIMap.put((Object)stormTopologyName, (Object)executionPlanStatusHolder);
        } else {
            log.error((Object)("Couldn't initialize status info object for execution plan: " + executionPlanName + ", for tenant-ID: " + tenantId + " as the hazelcast instance is not active or not available."));
        }
    }
}

