/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.manager;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.wso2.carbon.event.processor.common.storm.manager.service.StormManagerService;
import org.wso2.carbon.event.processor.common.storm.manager.service.exception.EndpointNotFoundException;
import org.wso2.carbon.event.processor.common.storm.manager.service.exception.NotStormCoordinatorException;

public class StormManagerServiceImpl
implements StormManagerService.Iface {
    private static Log log = LogFactory.getLog(StormManagerServiceImpl.class);
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    private ConcurrentHashMap<String, Set<Endpoint>> stormReceivers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<Endpoint>> cepPublishers = new ConcurrentHashMap();
    private boolean isStormCoordinator;
    private String hostPort;

    public StormManagerServiceImpl(String hostPort) {
        this.hostPort = hostPort;
    }

    public void registerStormReceiver(int tenantId, String executionPlanName, String hostName, int port) throws NotStormCoordinatorException, TException {
        if (!this.isStormCoordinator) {
            throw new NotStormCoordinatorException(this.hostPort + " not a storm coordinator");
        }
        StormManagerServiceImpl.insertToCollection(this.stormReceivers, StormManagerServiceImpl.constructKey(tenantId, executionPlanName), new Endpoint(port, hostName));
    }

    public void registerCEPPublisher(int tenantId, String executionPlanName, String hostName, int port) throws NotStormCoordinatorException, TException {
        if (!this.isStormCoordinator) {
            throw new NotStormCoordinatorException(this.hostPort + " not a storm coordinator");
        }
        StormManagerServiceImpl.insertToCollection(this.cepPublishers, StormManagerServiceImpl.constructKey(tenantId, executionPlanName), new Endpoint(port, hostName));
    }

    public synchronized String getStormReceiver(int tenantId, String executionPlanName, String cepReceiverHostName) throws NotStormCoordinatorException, EndpointNotFoundException, TException {
        if (!this.isStormCoordinator) {
            throw new NotStormCoordinatorException(this.hostPort + " not a storm coordinator");
        }
        Set<Endpoint> endpointSet = this.stormReceivers.get(StormManagerServiceImpl.constructKey(tenantId, executionPlanName));
        Endpoint selectedEndpoint = this.getEndpoint(endpointSet, cepReceiverHostName);
        if (null != selectedEndpoint) {
            return selectedEndpoint.getHostName() + ":" + selectedEndpoint.getPort();
        }
        throw new EndpointNotFoundException("No Storm Receiver for executionPlanName: " + executionPlanName + " of tenantId:" + tenantId + " for CEP Receiver form:" + cepReceiverHostName);
    }

    public synchronized String getCEPPublisher(int tenantId, String executionPlanName, String stormPublisherHostName) throws NotStormCoordinatorException, EndpointNotFoundException, TException {
        if (!this.isStormCoordinator) {
            throw new NotStormCoordinatorException(this.hostPort + " not a storm coordinator");
        }
        Set<Endpoint> endpointSet = this.cepPublishers.get(StormManagerServiceImpl.constructKey(tenantId, executionPlanName));
        Endpoint selectedEndpoint = this.getEndpoint(endpointSet, stormPublisherHostName);
        if (null != selectedEndpoint) {
            return selectedEndpoint.getHostName() + ":" + selectedEndpoint.getPort();
        }
        throw new EndpointNotFoundException("No CEP Publisher for executionPlanName: " + executionPlanName + " of tenantId:" + tenantId + " for Storm Publisher form:" + stormPublisherHostName);
    }

    public synchronized void deleteExecPlanEndpoints(int tenantId, String executionPlanName) {
        Set<Endpoint> endpointSet = this.cepPublishers.get(StormManagerServiceImpl.constructKey(tenantId, executionPlanName));
        if (endpointSet != null) {
            this.cepPublishers.remove(StormManagerServiceImpl.constructKey(tenantId, executionPlanName));
        }
        if ((endpointSet = this.stormReceivers.get(StormManagerServiceImpl.constructKey(tenantId, executionPlanName))) != null) {
            this.stormReceivers.remove(StormManagerServiceImpl.constructKey(tenantId, executionPlanName));
        }
        log.info((Object)("Removed all end point details related to '" + StormManagerServiceImpl.constructKey(tenantId, executionPlanName) + "' from Manager service."));
    }

    private synchronized Endpoint getEndpoint(Set<Endpoint> endpointSet, String requesterIp) {
        Endpoint selectedEndpoint = null;
        HashSet<Endpoint> sameHostEndpoints = new HashSet<Endpoint>();
        if (endpointSet != null && !endpointSet.isEmpty()) {
            if (!"".equals(requesterIp)) {
                for (Endpoint endpoint : endpointSet) {
                    if (!endpoint.getHostName().equals(requesterIp)) continue;
                    sameHostEndpoints.add(endpoint);
                }
            }
            if ((selectedEndpoint = !sameHostEndpoints.isEmpty() ? this.selectEndpoint(sameHostEndpoints) : this.selectEndpoint(endpointSet)) != null) {
                selectedEndpoint.setConnectionCount(selectedEndpoint.getConnectionCount() + 1);
            }
        }
        return selectedEndpoint;
    }

    private synchronized Endpoint selectEndpoint(Set<Endpoint> endpointSet) {
        Endpoint selectedEndpoint = null;
        int minConnectionCount = Integer.MAX_VALUE;
        for (Endpoint endpoint : endpointSet) {
            if (endpoint.getConnectionCount() >= minConnectionCount) continue;
            if (endpoint.getLastRegisterTimestamp() >= System.currentTimeMillis() - 60000L) {
                minConnectionCount = endpoint.getConnectionCount();
                selectedEndpoint = endpoint;
                continue;
            }
            log.warn((Object)("Ignoring endpoint " + endpoint.getHostName() + ":" + endpoint.getPort() + " because it has not sent a heart beat for " + (int)Math.floor((System.currentTimeMillis() - endpoint.getLastRegisterTimestamp()) / 60000L) + " min(s)"));
        }
        return selectedEndpoint;
    }

    private static synchronized void insertToCollection(ConcurrentHashMap<String, Set<Endpoint>> collection, String key, Endpoint endpoint) {
        Set<Endpoint> endpointSet = collection.get(key);
        boolean isHeartbeat = false;
        if (endpointSet == null) {
            endpointSet = new HashSet<Endpoint>();
            collection.put(key, endpointSet);
        } else {
            for (Endpoint currentEndpoint : endpointSet) {
                if (!currentEndpoint.equals(endpoint)) continue;
                isHeartbeat = true;
                currentEndpoint.updateLastRegisteredTimestamp();
                break;
            }
        }
        if (!isHeartbeat) {
            endpointSet.add(endpoint);
        }
    }

    private static String constructKey(int tenantId, String executionPlanName) {
        return tenantId + ":" + executionPlanName;
    }

    public void setStormCoordinator(boolean isStormCoordinator) {
        this.isStormCoordinator = isStormCoordinator;
    }

    public boolean isStormCoordinator() {
        return this.isStormCoordinator;
    }

    private class Endpoint {
        private int port;
        private String hostName;
        private int connectionCount = 0;
        private long lastRegisterTimestamp;

        Endpoint(int port, String hostName) {
            this.port = port;
            this.hostName = hostName;
            this.lastRegisterTimestamp = System.currentTimeMillis();
        }

        public long getLastRegisterTimestamp() {
            return this.lastRegisterTimestamp;
        }

        public void updateLastRegisteredTimestamp() {
            this.lastRegisterTimestamp = System.currentTimeMillis();
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        public void setConnectionCount(int connections) {
            this.connectionCount = connections;
        }

        public int getConnectionCount() {
            return this.connectionCount;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Endpoint argument = (Endpoint)object;
            return this.hostName.equals(argument.getHostName()) && this.port == argument.getPort();
        }
    }
}

