/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.manager;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.event.processor.common.storm.manager.service.StormManagerService;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.storm.manager.StormManagerServiceImpl;

public class StormManagerServer {
    private static final String STORM_HZ_MAP_ACTIVE_MANAGER_KEY = "storm.hazelcast.map.active.manager.key";
    private static final String STORM_ROLE_TO_MEMBERSHIP_HZ_MAP = "storm.role.membership.hazelcast.map";
    private static Log log = LogFactory.getLog(StormManagerServer.class);
    private TThreadPoolServer stormManagerServer;
    private StormManagerServiceImpl stormManagerService;
    private IMap<String, String> roleToMembershipMap;
    HazelcastInstance hazelcastInstance;
    private String myHazelcastId;
    private Future stateChecker = null;
    private ScheduledExecutorService executorService;

    public StormManagerServer(String hostName, int port) {
        try {
            this.stormManagerService = new StormManagerServiceImpl(hostName + ":" + port);
            TServerSocket serverTransport = new TServerSocket(new InetSocketAddress(hostName, port));
            StormManagerService.Processor processor = new StormManagerService.Processor((StormManagerService.Iface)this.stormManagerService);
            this.stormManagerServer = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor));
            Thread thread = new Thread(new ServerThread((TServer)this.stormManagerServer));
            thread.start();
            log.info((Object)("CEP Storm Management Thrift Server started on " + hostName + ":" + port));
            this.executorService = new ScheduledThreadPoolExecutor(3, new ThreadFactoryBuilder().setNameFormat("Thread pool- component - StormManagerServer.executorService").build());
        }
        catch (TTransportException e) {
            log.error((Object)("Cannot start Storm Manager Server on " + hostName + ":" + port), (Throwable)e);
        }
    }

    public void setHzaelCastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
        this.roleToMembershipMap = hazelcastInstance.getMap(STORM_ROLE_TO_MEMBERSHIP_HZ_MAP);
        this.myHazelcastId = hazelcastInstance.getCluster().getLocalMember().getUuid();
    }

    public void stop() {
        this.stormManagerServer.stop();
        this.executorService.shutdown();
        if (this.stateChecker != null) {
            this.stateChecker.cancel(false);
        }
    }

    public void onExecutionPlanRemove(String excPlanName, int tenantId) {
        this.stormManagerService.deleteExecPlanEndpoints(tenantId, excPlanName);
    }

    public void setStormCoordinator(boolean isCoordinator) {
        this.stormManagerService.setStormCoordinator(isCoordinator);
        if (!isCoordinator) {
            this.stateChecker = this.executorService.schedule(new PeriodicStateChanger(), 10000L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isStormCoordinator() {
        return this.stormManagerService.isStormCoordinator();
    }

    public void verifyState() {
        if (this.isStormCoordinator() && this.roleToMembershipMap != null && this.roleToMembershipMap.get((Object)STORM_HZ_MAP_ACTIVE_MANAGER_KEY) != null && !((String)this.roleToMembershipMap.get((Object)STORM_HZ_MAP_ACTIVE_MANAGER_KEY)).equals(this.myHazelcastId)) {
            log.info((Object)("Resigning as storm coordinator as there's another storm coordinator available in the cluster with member id " + (String)this.roleToMembershipMap.get((Object)STORM_HZ_MAP_ACTIVE_MANAGER_KEY)));
            this.setStormCoordinator(false);
        }
    }

    public synchronized void tryBecomeCoordinator() {
        HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
        if (hazelcastInstance != null && !this.isStormCoordinator()) {
            ILock lock = hazelcastInstance.getLock("StormCoordinator");
            boolean isCoordinator = lock.tryLock();
            this.setStormCoordinator(isCoordinator);
            if (isCoordinator) {
                log.info((Object)("Node became the Storm coordinator with member id " + this.myHazelcastId));
                if (this.roleToMembershipMap != null) {
                    this.roleToMembershipMap.put((Object)STORM_HZ_MAP_ACTIVE_MANAGER_KEY, (Object)this.myHazelcastId);
                }
            }
        }
    }

    class PeriodicStateChanger
    implements Runnable {
        PeriodicStateChanger() {
        }

        @Override
        public void run() {
            StormManagerServer.this.tryBecomeCoordinator();
        }
    }

    static class ServerThread
    implements Runnable {
        private TServer server;

        ServerThread(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.serve();
        }
    }
}

