/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm.compiler;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.wso2.siddhi.query.compiler.SiddhiQLBaseVisitor;
import org.wso2.siddhi.query.compiler.SiddhiQLLexer;
import org.wso2.siddhi.query.compiler.SiddhiQLParser;
import org.wso2.siddhi.query.compiler.internal.SiddhiErrorListener;

public class SiddhiQLStormQuerySplitter
extends SiddhiQLBaseVisitor {
    public static List<String> split(String source) {
        ANTLRInputStream input = new ANTLRInputStream(source);
        SiddhiQLLexer lexer = new SiddhiQLLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)SiddhiErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SiddhiQLParser parser = new SiddhiQLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)SiddhiErrorListener.INSTANCE);
        SiddhiQLParser.ParseContext tree = parser.parse();
        SiddhiQLStormQuerySplitter eval = new SiddhiQLStormQuerySplitter();
        List queryList = (List)eval.visit((ParseTree)tree);
        return queryList;
    }

    public static List<String> getEventTableList(String source) {
        ANTLRInputStream input = new ANTLRInputStream(source);
        SiddhiQLLexer lexer = new SiddhiQLLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)SiddhiErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SiddhiQLParser parser = new SiddhiQLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)SiddhiErrorListener.INSTANCE);
        SiddhiQLParser.ParseContext tree = parser.parse();
        SiddhiQLStormQuerySplitter eval = new SiddhiQLStormQuerySplitter();
        ArrayList<String> eventTableList = new ArrayList<String>();
        SiddhiQLParser.Execution_planContext ctx = tree.execution_plan();
        for (SiddhiQLParser.Definition_tableContext executionElementContext : ctx.definition_table()) {
            String query = (String)eval.visit((ParseTree)executionElementContext);
            eventTableList.add(query);
        }
        return eventTableList;
    }

    public Object visitParse(@NotNull SiddhiQLParser.ParseContext ctx) {
        return this.visit((ParseTree)ctx.execution_plan());
    }

    public List<String> visitExecution_plan(@NotNull SiddhiQLParser.Execution_planContext ctx) {
        ArrayList<String> stringQueryList = new ArrayList<String>();
        for (SiddhiQLParser.Execution_elementContext executionElementContext : ctx.execution_element()) {
            String query = (String)this.visit((ParseTree)executionElementContext);
            stringQueryList.add(query);
        }
        return stringQueryList;
    }

    public String visitQuery(@NotNull SiddhiQLParser.QueryContext ctx) {
        int a = ctx.start.getStartIndex();
        int b = ctx.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        return ctx.start.getInputStream().getText(interval);
    }

    public String visitPartition(@NotNull SiddhiQLParser.PartitionContext ctx) {
        int a = ctx.start.getStartIndex();
        int b = ctx.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        return ctx.start.getInputStream().getText(interval);
    }

    public String visitDefinition_table(@NotNull SiddhiQLParser.Definition_tableContext ctx) {
        int a = ctx.start.getStartIndex();
        int b = ctx.stop.getStopIndex();
        Interval interval = new Interval(a, b);
        return ctx.start.getInputStream().getText(interval);
    }
}

