/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm;

import backtype.storm.StormSubmitter;
import backtype.storm.generated.AlreadyAliveException;
import backtype.storm.generated.InvalidTopologyException;
import backtype.storm.generated.KillOptions;
import backtype.storm.generated.Nimbus;
import backtype.storm.generated.NotAliveException;
import backtype.storm.generated.StormTopology;
import backtype.storm.generated.TopologyInitialStatus;
import backtype.storm.generated.TopologySummary;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.utils.NimbusClient;
import backtype.storm.utils.Utils;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift7.TException;
import org.json.simple.JSONValue;
import org.w3c.dom.Document;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.exception.ServerUnavailableException;
import org.wso2.carbon.event.processor.core.exception.StormDeploymentException;
import org.wso2.carbon.event.processor.core.exception.StormQueryConstructionException;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.storm.util.StormQueryPlanBuilder;
import org.wso2.carbon.event.processor.core.internal.storm.util.StormTopologyConstructor;
import org.wso2.carbon.event.processor.core.util.DistributedModeConstants;
import org.wso2.carbon.event.processor.core.util.ExecutionPlanStatusHolder;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.carbon.utils.CarbonUtils;
import org.yaml.snakeyaml.Yaml;

public class StormTopologyManager {
    private Map stormConfig;
    private String jarLocation;
    private static final Log log = LogFactory.getLog(StormTopologyManager.class);
    private final ConcurrentHashMap<String, TopologySubmitter> toDeployTopologies = new ConcurrentHashMap();
    private TopologyManagerThreadFactory topologyManagerThreadFactory = new TopologyManagerThreadFactory("Storm Deployment");
    private final int lockTimeout;

    public StormTopologyManager() {
        String stormConfigDirPath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "cep" + File.separator + "storm";
        try {
            FileInputStream stormConf = new FileInputStream(new File(stormConfigDirPath + File.separator + "storm.yaml"));
            Yaml yaml = new Yaml();
            Map data = (Map)yaml.load((InputStream)stormConf);
            if (data != null) {
                this.stormConfig = Utils.readDefaultConfig();
                this.stormConfig.putAll(data);
            } else {
                this.stormConfig = Utils.readStormConfig();
            }
        }
        catch (FileNotFoundException e) {
            log.warn((Object)"Error occurred while reading storm configurations using default configurations", (Throwable)e);
        }
        DistributedConfiguration stormDeploymentConfiguration = EventProcessorValueHolder.getStormDeploymentConfiguration();
        this.lockTimeout = stormDeploymentConfiguration.getStatusLockTimeout();
        this.jarLocation = stormConfigDirPath + File.separator + EventProcessorValueHolder.getStormDeploymentConfiguration().getJar();
    }

    public List<TopologySummary> getTopologies() throws StormDeploymentException {
        try {
            Nimbus.Client client = NimbusClient.getConfiguredClient((Map)this.stormConfig).getClient();
            return client.getClusterInfo().get_topologies();
        }
        catch (TException e) {
            throw new StormDeploymentException("Cannot get topologies from storm cluster", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTopology(ExecutionPlanConfiguration configuration, List<String> importStreams, List<String> exportStreams, int tenantId, int resubmitRetryInterval) throws StormDeploymentException, ExecutionPlanConfigurationException {
        TopologyBuilder builder;
        Object stormQueryPlan;
        String executionPlanName = configuration.getName();
        String topologyName = StormTopologyManager.getTopologyName(executionPlanName, tenantId);
        try {
            Document document = StormQueryPlanBuilder.constructStormQueryPlanXML(configuration, importStreams, exportStreams);
            stormQueryPlan = this.getStringQueryPlan(document);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Following is the generated Storm query plan for execution plan: " + configuration.getName() + "\n" + (String)stormQueryPlan));
            }
            builder = StormTopologyConstructor.constructTopologyBuilder((String)stormQueryPlan, executionPlanName, tenantId, EventProcessorValueHolder.getStormDeploymentConfiguration());
        }
        catch (XMLStreamException e) {
            throw new StormDeploymentException("Invalid Config for Execution Plan " + executionPlanName + " for tenant " + tenantId, e);
        }
        catch (TransformerException e) {
            throw new StormDeploymentException("Error while converting to storm query plan string. Execution plan: " + executionPlanName + " Tenant: " + tenantId, e);
        }
        catch (StormQueryConstructionException e) {
            throw new StormDeploymentException("Error while converting to XML storm query plan. Execution plan: " + executionPlanName + " Tenant: " + tenantId + ". " + e.getMessage(), e);
        }
        TopologySubmitter topologySubmitter = new TopologySubmitter(executionPlanName, builder.createTopology(), tenantId, resubmitRetryInterval);
        stormQueryPlan = this.toDeployTopologies;
        synchronized (stormQueryPlan) {
            this.toDeployTopologies.put(topologyName, topologySubmitter);
        }
        Thread deploymentThread = this.topologyManagerThreadFactory.newThread(topologySubmitter);
        deploymentThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killTopology(String executionPlanName, int tenantId) throws StormDeploymentException {
        try {
            ConcurrentHashMap<String, TopologySubmitter> concurrentHashMap = this.toDeployTopologies;
            synchronized (concurrentHashMap) {
                this.toDeployTopologies.remove(StormTopologyManager.getTopologyName(executionPlanName, tenantId));
            }
            log.info((Object)("Killing storm topology '" + executionPlanName + "' of tenant '" + tenantId + "'"));
            Nimbus.Client client = NimbusClient.getConfiguredClient((Map)this.stormConfig).getClient();
            client.killTopologyWithOpts(StormTopologyManager.getTopologyName(executionPlanName, tenantId), new KillOptions());
        }
        catch (NotAliveException client) {
        }
        catch (TException e) {
            throw new StormDeploymentException("Error connecting to Storm", e);
        }
    }

    private String getStringQueryPlan(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return sw.toString();
    }

    public static String getTopologyName(String executionPlanName, int tenantId) {
        return executionPlanName + "[" + tenantId + "]";
    }

    class TopologyManagerThreadFactory
    implements ThreadFactory {
        final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        public TopologyManagerThreadFactory(String threadPoolExecutorName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "TopologyManager-" + threadPoolExecutorName + "-pool-" + this.poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    class TopologySubmitter
    implements Runnable {
        private final String topologyName;
        StormTopology topology;
        int retryInterval;

        public TopologySubmitter(String executionPlanName, StormTopology topology, int tenantId, int resubmitRetryInterval) {
            this.topologyName = StormTopologyManager.getTopologyName(executionPlanName, tenantId);
            this.topology = topology;
            this.retryInterval = resubmitRetryInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String jobPrefix = "TopologySubmitterJob:" + Thread.currentThread().getId() + ", ";
            log.info((Object)(jobPrefix + "Job started to submit storm topology '" + this.topologyName + "'."));
            while (true) {
                if (!this.isToBeDeployed()) {
                    log.info((Object)(jobPrefix + "Aborting Storm deployment of '" + this.topologyName + "', as current job is outdated."));
                    return;
                }
                try {
                    if (this.isTopologyExist()) {
                        this.updateExecutionPlanStatusInStorm(this.topologyName, DistributedModeConstants.TopologyState.CLEANING);
                        log.info((Object)(jobPrefix + "Killing already existing storm topology '" + this.topologyName + "' to re-submit"));
                        KillOptions options = new KillOptions();
                        options.set_wait_secs(10);
                        try {
                            Nimbus.Client client = NimbusClient.getConfiguredClient((Map)StormTopologyManager.this.stormConfig).getClient();
                            client.killTopologyWithOpts(this.topologyName, options);
                            this.waitForTopologyToBeRemoved(jobPrefix);
                        }
                        catch (NotAliveException e) {
                            log.info((Object)(jobPrefix + "Topology '" + this.topologyName + "' is not alive to kill"));
                        }
                        catch (TException e) {
                            log.error((Object)(jobPrefix + "Error connecting to storm when trying to kill topology '" + this.topologyName + "'"), (Throwable)e);
                            log.info((Object)(jobPrefix + "Retrying to kill topology '" + this.topologyName + "' in " + this.retryInterval + " ms"));
                            try {
                                Thread.sleep(this.retryInterval);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        continue;
                    }
                    this.updateExecutionPlanStatusInStorm(this.topologyName, DistributedModeConstants.TopologyState.DEPLOYING);
                    try {
                        String jsonConf = JSONValue.toJSONString((Object)StormTopologyManager.this.stormConfig);
                        ConcurrentHashMap concurrentHashMap = StormTopologyManager.this.toDeployTopologies;
                        synchronized (concurrentHashMap) {
                            if (this.isToBeDeployed()) {
                                String uploadedJarLocation = StormSubmitter.submitJar((Map)StormTopologyManager.this.stormConfig, (String)StormTopologyManager.this.jarLocation);
                                Nimbus.Client client = NimbusClient.getConfiguredClient((Map)StormTopologyManager.this.stormConfig).getClient();
                                client.submitTopology(this.topologyName, uploadedJarLocation, jsonConf, this.topology);
                                StormTopologyManager.this.toDeployTopologies.remove(this.topologyName);
                                log.info((Object)(jobPrefix + "Successfully submitted storm topology '" + this.topologyName + "'"));
                                this.waitForTopologyToBeActive(client, jobPrefix, this.topologyName);
                                return;
                            }
                            log.info((Object)(jobPrefix + "Aborting Storm deployment of '" + this.topologyName + "', as current job is outdated."));
                            return;
                        }
                    }
                    catch (InvalidTopologyException e) {
                        log.error((Object)(jobPrefix + "Cannot deploy, Invalid Storm topology '" + this.topologyName + "' found."), (Throwable)e);
                        return;
                    }
                    catch (AlreadyAliveException e) {
                        log.warn((Object)(jobPrefix + "Topology '" + this.topologyName + "' already existing. Trying to kill and re-submit"), (Throwable)e);
                        continue;
                    }
                    catch (TException e) {
                        log.error((Object)(jobPrefix + "Error connecting to storm when trying to submit topology '" + this.topologyName + "'"), (Throwable)e);
                        log.info((Object)(jobPrefix + "Retrying to submit topology '" + this.topologyName + "' in " + this.retryInterval + " ms"));
                        try {
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
                catch (ServerUnavailableException e) {
                    log.error((Object)(jobPrefix + e.getMessage()), (Throwable)e);
                    log.info((Object)(jobPrefix + "Retrying to submit topology '" + this.topologyName + "' in " + this.retryInterval + " ms"));
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isToBeDeployed() {
            ConcurrentHashMap concurrentHashMap = StormTopologyManager.this.toDeployTopologies;
            synchronized (concurrentHashMap) {
                TopologySubmitter existingTopologySubmitter = (TopologySubmitter)StormTopologyManager.this.toDeployTopologies.get(this.topologyName);
                return existingTopologySubmitter != null && existingTopologySubmitter.equals(this);
            }
        }

        private boolean isTopologyExist() throws ServerUnavailableException {
            try {
                Nimbus.Client client = NimbusClient.getConfiguredClient((Map)StormTopologyManager.this.stormConfig).getClient();
                List topologies = client.getClusterInfo().get_topologies();
                for (TopologySummary topologySummary : topologies) {
                    if (!topologySummary.get_name().equals(this.topologyName)) continue;
                    return true;
                }
                return false;
            }
            catch (TException e) {
                throw new ServerUnavailableException("Error connecting to storm when trying to check whether topology '" + this.topologyName + "' exist", e);
            }
            catch (RuntimeException e) {
                throw new ServerUnavailableException("Runtime Exception connecting to storm when trying to check whether topology '" + this.topologyName + "' exist", e);
            }
        }

        private void waitForTopologyToBeActive(Nimbus.Client client, String jobPrefix, String topologyName) throws TException {
            TopologySummary thisTopologySummary = null;
            while (thisTopologySummary == null) {
                List topologySummaryList = client.getClusterInfo().get_topologies();
                for (TopologySummary topologySummary : topologySummaryList) {
                    if (!topologySummary.get_name().equals(topologyName)) continue;
                    thisTopologySummary = topologySummary;
                }
                if (thisTopologySummary != null) continue;
                try {
                    Thread.sleep(2000L);
                    log.info((Object)(jobPrefix + "Waiting until '" + topologyName + "' has been submitted to Storm cluster"));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.updateExecutionPlanStatusInStorm(topologyName, DistributedModeConstants.TopologyState.UNKNOWN);
                    log.error((Object)("Could not verify whether " + topologyName + "' has been submitted to Storm cluster or not as the verifier got interrupted. Setting distributed deployment status as UNKNOWN"));
                    return;
                }
            }
            while (true) {
                if (thisTopologySummary.get_status().equals(TopologyInitialStatus.ACTIVE.toString())) {
                    this.updateExecutionPlanStatusInStorm(topologyName, DistributedModeConstants.TopologyState.ACTIVE);
                    log.info((Object)(jobPrefix + "Topology '" + topologyName + "' found to be active in Storm cluster"));
                    return;
                }
                try {
                    log.info((Object)(jobPrefix + "Waiting until '" + topologyName + "' becomes active in Storm cluster"));
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        private void waitForTopologyToBeRemoved(String jobPrefix) throws TException, ServerUnavailableException {
            log.info((Object)(jobPrefix + "Waiting for topology '" + this.topologyName + "' to be removed from Storm cluster"));
            try {
                while (this.isTopologyExist()) {
                    Thread.sleep(5000L);
                }
                Thread.sleep(2000L);
                log.info((Object)(jobPrefix + "Topology '" + this.topologyName + "' removed from Storm cluster"));
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateExecutionPlanStatusInStorm(String stormTopologyName, DistributedModeConstants.TopologyState topologyState) {
            block10: {
                String executionPlanStatusHolderKey = "org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui." + stormTopologyName;
                HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
                if (hazelcastInstance != null && hazelcastInstance.getLifecycleService().isRunning()) {
                    IMap executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
                    try {
                        if (executionPlanStatusHolderIMap.tryLock((Object)executionPlanStatusHolderKey, (long)StormTopologyManager.this.lockTimeout, TimeUnit.MILLISECONDS)) {
                            try {
                                ExecutionPlanStatusHolder executionPlanStatusHolder = (ExecutionPlanStatusHolder)executionPlanStatusHolderIMap.get((Object)stormTopologyName);
                                if (executionPlanStatusHolder == null) {
                                    log.error((Object)("Couldn't update topology status for topology:" + this.topologyName + " as status object not initialized by manager."));
                                } else {
                                    executionPlanStatusHolder.setStormTopologyStatus(topologyState);
                                    executionPlanStatusHolderIMap.replace((Object)stormTopologyName, (Object)executionPlanStatusHolder);
                                }
                                break block10;
                            }
                            finally {
                                executionPlanStatusHolderIMap.unlock((Object)executionPlanStatusHolderKey);
                            }
                        }
                        log.error((Object)("Couldn't update topology status for topology:" + this.topologyName + " as the hazelcast lock acquisition failed."));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error((Object)("Couldn't update topology status for topology:" + this.topologyName + " as the hazelcast lock acquisition was interrupted."), (Throwable)e);
                    }
                } else {
                    log.error((Object)("Couldn't update topology status for topology:" + this.topologyName + " as the hazelcast instance is not active or not available."));
                }
            }
        }
    }
}

