/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.wso2.carbon.databridge.commons.thrift.utils.HostAddressFinder;
import org.wso2.carbon.event.processor.common.storm.manager.service.StormManagerService;
import org.wso2.carbon.event.processor.common.util.ThroughputProbe;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.internal.listener.SiddhiOutputStreamListener;
import org.wso2.carbon.event.processor.manager.commons.transport.server.ConnectionCallback;
import org.wso2.carbon.event.processor.manager.commons.transport.server.StreamCallback;
import org.wso2.carbon.event.processor.manager.commons.transport.server.TCPEventServer;
import org.wso2.carbon.event.processor.manager.commons.transport.server.TCPEventServerConfig;
import org.wso2.carbon.event.processor.manager.commons.utils.HostAndPort;
import org.wso2.carbon.event.processor.manager.commons.utils.Utils;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class SiddhiStormOutputEventListener
implements StreamCallback {
    private static final Log log = LogFactory.getLog(SiddhiStormOutputEventListener.class);
    private ExecutionPlanConfiguration executionPlanConfiguration;
    private int listeningPort;
    private int tenantId;
    private final DistributedConfiguration stormDeploymentConfig;
    private String thisHostIp;
    private HashMap<String, SiddhiOutputStreamListener> streamNameToOutputStreamListenerMap = new HashMap();
    private TCPEventServer tcpEventServer;
    private String logPrefix = "";
    private ExecutorService executorService;
    private int heartbeatInterval;
    private ThroughputProbe inputThroughputProbe;
    private final ConnectionCallback connectionCallback;

    public SiddhiStormOutputEventListener(ExecutionPlanConfiguration executionPlanConfiguration, int tenantId, DistributedConfiguration stormDeploymentConfig, ConnectionCallback connectionCallback) {
        this.executionPlanConfiguration = executionPlanConfiguration;
        this.tenantId = tenantId;
        this.stormDeploymentConfig = stormDeploymentConfig;
        this.heartbeatInterval = stormDeploymentConfig.getManagementHeartbeatInterval();
        this.connectionCallback = connectionCallback;
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Thread pool- component - SiddhiStormOutputEventListener.executorService;tenantId - " + tenantId + ";executionPlanName - " + executionPlanConfiguration.getName()).build());
        this.init();
    }

    private void init() {
        this.logPrefix = "[" + this.tenantId + ":" + this.executionPlanConfiguration.getName() + ":CEPPublisher] ";
        log.info((Object)(this.logPrefix + "Initializing storm output event listener"));
        this.inputThroughputProbe = new ThroughputProbe(this.logPrefix + "-Receive", 10);
        this.inputThroughputProbe.startSampling();
        try {
            this.thisHostIp = HostAddressFinder.findAddress((String)"localhost");
            this.listeningPort = this.findPort(this.thisHostIp);
            TCPEventServerConfig configs = new TCPEventServerConfig(this.thisHostIp, this.listeningPort);
            this.tcpEventServer = new TCPEventServer(configs, (StreamCallback)this, this.connectionCallback);
            this.tcpEventServer.start();
            this.executorService.execute(new Registrar());
        }
        catch (Exception e) {
            log.error((Object)(this.logPrefix + "Failed to start event listener"), (Throwable)e);
        }
    }

    public void registerOutputStreamListener(StreamDefinition siddhiStreamDefinition, SiddhiOutputStreamListener outputStreamListener) {
        log.info((Object)(this.logPrefix + "Registering output stream listener for Siddhi stream : " + siddhiStreamDefinition.getId()));
        this.streamNameToOutputStreamListenerMap.put(siddhiStreamDefinition.getId(), outputStreamListener);
        this.tcpEventServer.addStreamDefinition(siddhiStreamDefinition);
    }

    public void receive(String streamId, long timestamp, Object[] eventData, Map<String, String> arbitraryMapData) {
        SiddhiOutputStreamListener outputStreamListener = this.streamNameToOutputStreamListenerMap.get(streamId);
        if (outputStreamListener != null) {
            outputStreamListener.sendEvent(new Event(timestamp, eventData));
            this.inputThroughputProbe.update();
        } else {
            log.warn((Object)("Cannot find output event listener for stream " + streamId + " in execution plan " + this.executionPlanConfiguration.getName() + " of tenant " + this.tenantId + ". Discarding Event:" + streamId + ":" + Arrays.deepToString(eventData) + "@" + timestamp));
        }
    }

    private int findPort(String host) throws Exception {
        for (int i = this.stormDeploymentConfig.getTransportMinPort(); i <= this.stormDeploymentConfig.getTransportMaxPort(); ++i) {
            if (Utils.isPortUsed((int)i, (String)host)) continue;
            return i;
        }
        throw new Exception("Cannot find free port in range " + this.stormDeploymentConfig.getTransportMinPort() + "~" + this.stormDeploymentConfig.getTransportMaxPort());
    }

    public void shutdown() {
        this.executorService.shutdown();
        this.tcpEventServer.shutdown();
    }

    class Registrar
    implements Runnable {
        private String managerHost;
        private int managerPort;

        Registrar() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info((Object)(SiddhiStormOutputEventListener.this.logPrefix + "Registering CEP publisher for " + SiddhiStormOutputEventListener.this.thisHostIp + ":" + SiddhiStormOutputEventListener.this.listeningPort));
            while (true) {
                block13: {
                    if (this.registerCEPPublisherWithStormMangerService()) {
                        while (true) {
                            TSocket transport = null;
                            try {
                                transport = new TSocket(this.managerHost, this.managerPort);
                                TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
                                transport.open();
                                StormManagerService.Client client = new StormManagerService.Client((TProtocol)protocol);
                                client.registerCEPPublisher(SiddhiStormOutputEventListener.this.tenantId, SiddhiStormOutputEventListener.this.executionPlanConfiguration.getName(), SiddhiStormOutputEventListener.this.thisHostIp, SiddhiStormOutputEventListener.this.listeningPort);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)(SiddhiStormOutputEventListener.this.logPrefix + "Successfully registered CEP publisher for " + SiddhiStormOutputEventListener.this.thisHostIp + ":" + SiddhiStormOutputEventListener.this.listeningPort));
                                }
                                try {
                                    Thread.sleep(SiddhiStormOutputEventListener.this.heartbeatInterval);
                                }
                                catch (InterruptedException e1) {
                                    Thread.currentThread().interrupt();
                                }
                                continue;
                            }
                            catch (Exception e) {
                                log.error((Object)(SiddhiStormOutputEventListener.this.logPrefix + "Error in registering CEP publisher for " + SiddhiStormOutputEventListener.this.thisHostIp + ":" + SiddhiStormOutputEventListener.this.listeningPort + " with manager " + this.managerHost + ":" + this.managerPort + ". Trying next manager after " + SiddhiStormOutputEventListener.this.heartbeatInterval + "ms"), (Throwable)e);
                                break block13;
                            }
                            finally {
                                if (transport == null) continue;
                                transport.close();
                                continue;
                            }
                            break;
                        }
                    }
                    log.error((Object)(SiddhiStormOutputEventListener.this.logPrefix + "Error registering CEP publisher with current manager. Retrying after " + SiddhiStormOutputEventListener.this.heartbeatInterval + "ms"));
                }
                try {
                    Thread.sleep(SiddhiStormOutputEventListener.this.heartbeatInterval);
                    continue;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean registerCEPPublisherWithStormMangerService() {
            TSocket transport = null;
            for (HostAndPort endpoint : SiddhiStormOutputEventListener.this.stormDeploymentConfig.getManagers()) {
                try {
                    transport = new TSocket(endpoint.getHostName(), endpoint.getPort());
                    TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
                    transport.open();
                    StormManagerService.Client client = new StormManagerService.Client((TProtocol)protocol);
                    client.registerCEPPublisher(SiddhiStormOutputEventListener.this.tenantId, SiddhiStormOutputEventListener.this.executionPlanConfiguration.getName(), SiddhiStormOutputEventListener.this.thisHostIp, SiddhiStormOutputEventListener.this.listeningPort);
                    log.info((Object)(SiddhiStormOutputEventListener.this.logPrefix + "Successfully registered CEP publisher for " + SiddhiStormOutputEventListener.this.thisHostIp + ":" + SiddhiStormOutputEventListener.this.listeningPort + "  with manager service at" + endpoint.getHostName() + ":" + endpoint.getPort()));
                    this.managerHost = endpoint.getHostName();
                    this.managerPort = endpoint.getPort();
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    log.error((Object)(SiddhiStormOutputEventListener.this.logPrefix + "Error in registering CEP publisher for " + SiddhiStormOutputEventListener.this.thisHostIp + ":" + SiddhiStormOutputEventListener.this.listeningPort + " with manager " + endpoint.getHostName() + ":" + endpoint.getPort() + ". Trying next manager"), (Throwable)e);
                }
                finally {
                    if (transport == null) continue;
                    transport.close();
                }
            }
            return false;
        }
    }
}

