/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.storm;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.common.util.AsyncEventPublisher;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.internal.listener.AbstractSiddhiInputEventDispatcher;
import org.wso2.carbon.event.processor.core.internal.util.EventProcessorUtil;
import org.wso2.carbon.event.processor.manager.commons.transport.server.ConnectionCallback;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class SiddhiStormInputEventDispatcher
extends AbstractSiddhiInputEventDispatcher {
    private static final Log log = LogFactory.getLog(SiddhiStormInputEventDispatcher.class);
    private final DistributedConfiguration stormDeploymentConfig;
    private StreamDefinition siddhiStreamDefinition;
    private String logPrefix;
    private ExecutorService executorService;
    private AsyncEventPublisher asyncEventPublisher;
    private final ConnectionCallback connectionCallback;

    public SiddhiStormInputEventDispatcher(org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition, String siddhiStreamId, ExecutionPlanConfiguration executionPlanConfiguration, int tenantId, DistributedConfiguration stormDeploymentConfig, ConnectionCallback connectionCallback) {
        super(streamDefinition.getStreamId(), siddhiStreamId, executionPlanConfiguration, tenantId);
        this.stormDeploymentConfig = stormDeploymentConfig;
        this.connectionCallback = connectionCallback;
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Thread pool- component - SiddhiStormInputEventDispatcher.executorService;tenantId - " + tenantId + ";executionPlanName - " + executionPlanConfiguration.getName() + ";streamDefinition - " + streamDefinition.getStreamId()).build());
        this.init(streamDefinition, siddhiStreamId, executionPlanConfiguration);
    }

    private void init(org.wso2.carbon.databridge.commons.StreamDefinition streamDefinition, String siddhiStreamName, ExecutionPlanConfiguration executionPlanConfiguration) {
        this.logPrefix = "[CEP Receiver|ExecPlan:" + executionPlanConfiguration.getName() + ", Tenant:" + this.tenantId + ", Stream:" + siddhiStreamName + "] ";
        try {
            this.siddhiStreamDefinition = EventProcessorUtil.convertToSiddhiStreamDefinition(streamDefinition, siddhiStreamName);
            HashSet<StreamDefinition> streamDefinitions = new HashSet<StreamDefinition>();
            streamDefinitions.add(this.siddhiStreamDefinition);
            this.asyncEventPublisher = new AsyncEventPublisher(AsyncEventPublisher.DestinationType.STORM_RECEIVER, streamDefinitions, this.stormDeploymentConfig.getManagers(), executionPlanConfiguration.getName(), this.tenantId, this.stormDeploymentConfig, this.connectionCallback);
            this.asyncEventPublisher.initializeConnection(false);
        }
        catch (Exception e) {
            log.error((Object)(this.logPrefix + "Failed to start event listener"), (Throwable)e);
        }
    }

    @Override
    public void sendEvent(Event event) throws InterruptedException {
        this.asyncEventPublisher.sendEvent(event.getData(), event.getTimestamp(), this.siddhiStreamDefinition.getId());
    }

    @Override
    public void shutdown() {
        this.asyncEventPublisher.shutdown();
        this.executorService.shutdown();
    }
}

