/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.persistence;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;

public class FileSystemPersistenceStore
implements PersistenceStore {
    private static final Log log = LogFactory.getLog(FileSystemPersistenceStore.class);
    private static final String folderSeparator = File.separator;
    private static String folder = "repository" + folderSeparator + "cep_persistence";
    private boolean purgeOldSnapshots = false;
    private Map<String, Queue<String>> lastTwoRevisionsMap = new HashMap<String, Queue<String>>();

    public void save(String queryPlanIdentifier, String revision, byte[] bytes) {
        String tenantId = this.getTenantId();
        File file = new File(folder + folderSeparator + tenantId + folderSeparator + queryPlanIdentifier + folderSeparator + revision);
        try {
            Files.createParentDirs((File)file);
            Files.write((byte[])bytes, (File)file);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saved revision " + revision + " of ExecutionPlan:" + queryPlanIdentifier + " to the file system."));
            }
            if (this.purgeOldSnapshots) {
                this.deleteOldRevisions(revision, queryPlanIdentifier);
            }
        }
        catch (IOException e) {
            log.error((Object)("Cannot load the revision " + revision + " of ExecutionPlan:" + queryPlanIdentifier + "from file system."), (Throwable)e);
        }
    }

    private void deleteOldRevisions(String currentRevision, String queryPlanIdentifier) {
        Queue<String> latestTwoRevisions = this.lastTwoRevisionsMap.get(queryPlanIdentifier);
        if (latestTwoRevisions == null) {
            latestTwoRevisions = new LinkedList<String>();
            this.lastTwoRevisionsMap.put(queryPlanIdentifier, latestTwoRevisions);
        }
        if (latestTwoRevisions.size() < 2) {
            latestTwoRevisions.add(currentRevision);
        } else {
            String revisionToDelete = latestTwoRevisions.remove();
            latestTwoRevisions.add(currentRevision);
            File fileToDelete = new File(folder + folderSeparator + this.getTenantId() + folderSeparator + queryPlanIdentifier + folderSeparator + revisionToDelete);
            boolean isDeleted = fileToDelete.delete();
            if (log.isDebugEnabled()) {
                if (isDeleted) {
                    log.debug((Object)("Failed to delete persistence file " + fileToDelete.getAbsolutePath()));
                } else {
                    log.debug((Object)("Persistence file deleted successfully " + fileToDelete.getAbsolutePath()));
                }
            }
        }
    }

    public byte[] load(String queryPlanIdentifier, String revision) {
        String tenantId = this.getTenantId();
        File file = new File(folder + folderSeparator + tenantId + folderSeparator + queryPlanIdentifier + folderSeparator + revision);
        try {
            byte[] bytes = Files.toByteArray((File)file);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded revision " + revision + " of ExecutionPlan:" + queryPlanIdentifier + " from the file system."));
            }
            return bytes;
        }
        catch (IOException e) {
            log.error((Object)("Cannot load the revision " + revision + " of ExecutionPlan:" + queryPlanIdentifier + "from file system."), (Throwable)e);
            return null;
        }
    }

    public String getLastRevision(String executionPlanIdentifier) {
        String tenantId = this.getTenantId();
        File dir = new File(folder + folderSeparator + tenantId + folderSeparator + executionPlanIdentifier);
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        String lastRevision = null;
        for (File file : files) {
            String fileName = file.getName();
            if (lastRevision != null && fileName.compareTo(lastRevision) <= 0) continue;
            lastRevision = fileName;
        }
        return lastRevision;
    }

    private String getTenantId() {
        return String.valueOf(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()).replaceAll("-", "M");
    }

    public void setProperties(Map properties) {
        folder = (String)properties.get("persistenceLocation");
        Object purgeOldSnapshotsPropertyValue = properties.get("purgeOldSnapshots");
        if (purgeOldSnapshotsPropertyValue != null && !purgeOldSnapshotsPropertyValue.toString().isEmpty()) {
            this.purgeOldSnapshots = purgeOldSnapshotsPropertyValue.toString().equalsIgnoreCase("true");
        }
    }
}

