/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.persistence;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.sql.DataSource;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.persistence.util.ExecutionInfo;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;

public class DBPersistenceStore
implements PersistenceStore {
    private static final Log log = LogFactory.getLog(DBPersistenceStore.class);
    private DataSource dataSource;
    private String tableName;
    private String dataSourceName;
    private ExecutionInfo executionInfo = null;
    private boolean purgeOldSnapshots = false;
    private Map<String, Queue<String>> lastTwoRevisionsMap = new HashMap<String, Queue<String>>();

    public void save(String executionPlanId, String revision, byte[] snapshot) {
        this.connect();
        if (this.executionInfo == null) {
            this.executionInfo = new ExecutionInfo();
            this.initializeDatabaseExecutionInfo();
        }
        this.createTableIfNotExist();
        this.saveRevision(executionPlanId, revision, snapshot);
        if (this.purgeOldSnapshots) {
            this.deleteRevision(executionPlanId, revision);
        }
    }

    public void setProperties(Map properties) {
        Object purgeOldSnapshotsPropertyValue;
        this.dataSourceName = (String)properties.get("DataSource");
        this.tableName = (String)properties.get("TableName");
        if (this.executionInfo == null) {
            this.executionInfo = new ExecutionInfo();
            this.initializeDatabaseExecutionInfo();
        }
        if ((purgeOldSnapshotsPropertyValue = properties.get("purgeOldSnapshots")) != null && !purgeOldSnapshotsPropertyValue.toString().isEmpty()) {
            this.purgeOldSnapshots = purgeOldSnapshotsPropertyValue.toString().equalsIgnoreCase("true");
        }
    }

    public byte[] load(String executionPlanId, String revision) {
        this.connect();
        String tenantId = this.getTenantId();
        if (this.executionInfo == null) {
            this.executionInfo = new ExecutionInfo();
            this.initializeDatabaseExecutionInfo();
        }
        return this.getRevision(executionPlanId, revision, tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getRevision(String executionPlanId, String revision, String tenantId) {
        PreparedStatement stmt = null;
        Connection con = null;
        byte[] blobAsBytes = null;
        try {
            try {
                con = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                log.error((Object)("Cannot establish connection to the data source" + this.dataSourceName), (Throwable)e);
            }
            stmt = con.prepareStatement(this.executionInfo.getPreparedSelectStatement());
            stmt.setString(1, revision);
            stmt.setString(2, tenantId);
            stmt.setString(3, executionPlanId);
            ResultSet resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                Blob blobSnapshot = resultSet.getBlob("snapshot");
                int blobLength = (int)blobSnapshot.length();
                blobAsBytes = blobSnapshot.getBytes(1L, blobLength);
            }
            this.cleanupConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error while retrieving revision " + revision + "of execution plan:" + executionPlanId + "from the database"), (Throwable)e);
                this.cleanupConnections(stmt, con);
            }
            catch (Throwable throwable) {
                this.cleanupConnections(stmt, con);
                throw throwable;
            }
        }
        return blobAsBytes;
    }

    public String getLastRevision(String executionPlanId) {
        String tenantId = this.getTenantId();
        this.connect();
        if (this.executionInfo == null) {
            this.executionInfo = new ExecutionInfo();
            this.initializeDatabaseExecutionInfo();
        }
        this.createTableIfNotExist();
        return this.getLastRevision(executionPlanId, tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastRevision(String executionPlanId, String tenantId) {
        PreparedStatement stmt = null;
        Connection con = null;
        String revision = "";
        try {
            try {
                con = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                log.error((Object)("Cannot establish connection to the data source" + this.dataSourceName), (Throwable)e);
            }
            stmt = con.prepareStatement(this.executionInfo.getPreparedSelectLastStatement());
            stmt.setString(1, tenantId);
            stmt.setString(2, executionPlanId);
            ResultSet resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                revision = String.valueOf(resultSet.getString("revision"));
            }
            this.cleanupConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error while retrieving last revision of execution plan:" + executionPlanId + "from the database"), (Throwable)e);
                this.cleanupConnections(stmt, con);
            }
            catch (Throwable throwable) {
                this.cleanupConnections(stmt, con);
                throw throwable;
            }
        }
        return revision;
    }

    /*
     * Loose catch block
     */
    public void connect() {
        Connection con = null;
        try {
            CarbonDataSource carbonDataSource = EventProcessorValueHolder.getDataSourceService().getDataSource(this.dataSourceName);
            this.dataSource = (DataSource)carbonDataSource.getDSObject();
            con = ((DataSource)carbonDataSource.getDSObject()).getConnection();
            this.cleanupConnections(null, con);
        }
        catch (DataSourceException e) {
            log.error((Object)("No data-source found by the dataSourceName: " + this.dataSourceName), (Throwable)e);
            this.cleanupConnections(null, con);
        }
        catch (SQLException e2) {
            log.error((Object)("Cannot establish connection to the data source" + this.dataSourceName), (Throwable)e2);
            this.cleanupConnections(null, con);
            {
                catch (Throwable throwable) {
                    this.cleanupConnections(null, con);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRevision(String executionPlanId, String revision, byte[] snapshot) {
        PreparedStatement stmt = null;
        Connection con = null;
        try {
            try {
                con = this.dataSource.getConnection();
                con.setAutoCommit(false);
            }
            catch (SQLException e) {
                log.error((Object)("Cannot establish connection to the data source" + this.dataSourceName), (Throwable)e);
            }
            stmt = con.prepareStatement(this.executionInfo.getPreparedInsertStatement());
            stmt.setString(1, this.getTenantId());
            stmt.setString(2, executionPlanId);
            stmt.setString(3, revision);
            stmt.setBlob(4, new SerialBlob(snapshot));
            stmt.executeUpdate();
            con.commit();
            this.cleanupConnections(stmt, con);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Error while saving revision" + revision + " of the execution plan" + executionPlanId + "to the database"), (Throwable)e);
                this.cleanupConnections(stmt, con);
            }
            catch (Throwable throwable) {
                this.cleanupConnections(stmt, con);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRevision(String executionPlanId, String currentRevision) {
        Queue<String> latestTwoRevisions = this.lastTwoRevisionsMap.get(executionPlanId);
        if (latestTwoRevisions == null) {
            latestTwoRevisions = new LinkedList<String>();
            this.lastTwoRevisionsMap.put(executionPlanId, latestTwoRevisions);
        }
        if (latestTwoRevisions.size() < 2) {
            latestTwoRevisions.add(currentRevision);
        } else {
            String revisionToDelete = latestTwoRevisions.remove();
            latestTwoRevisions.add(currentRevision);
            PreparedStatement stmt = null;
            Connection con = null;
            try {
                try {
                    con = this.dataSource.getConnection();
                    con.setAutoCommit(false);
                }
                catch (SQLException e) {
                    log.error((Object)("Cannot establish connection to the data source" + this.dataSourceName), (Throwable)e);
                }
                stmt = con.prepareStatement(this.executionInfo.getPreparedDeleteStatement());
                stmt.setString(1, revisionToDelete);
                stmt.setString(2, executionPlanId);
                stmt.setString(3, this.getTenantId());
                stmt.executeUpdate();
                con.commit();
                this.cleanupConnections(stmt, con);
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Error while deleting revision" + revisionToDelete + " of the execution plan" + executionPlanId + "to the database"), (Throwable)e);
                    this.cleanupConnections(stmt, con);
                }
                catch (Throwable throwable) {
                    this.cleanupConnections(stmt, con);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableIfNotExist() {
        if (!this.executionInfo.isTableExist()) {
            Statement stmt = null;
            Boolean tableExists = true;
            Connection con = null;
            try {
                block13: {
                    try {
                        con = this.dataSource.getConnection();
                        con.setAutoCommit(false);
                    }
                    catch (SQLException e) {
                        log.error((Object)("Cannot establish connection to the data source" + this.dataSourceName), (Throwable)e);
                    }
                    stmt = con.createStatement();
                    try {
                        stmt.executeQuery(this.executionInfo.getPreparedTableExistenceCheckStatement());
                        this.executionInfo.setTableExist(true);
                    }
                    catch (SQLException e) {
                        tableExists = false;
                        if (!log.isDebugEnabled()) break block13;
                        log.debug((Object)("Table " + this.tableName + " does not Exist. Table Will be created. "));
                    }
                }
                try {
                    if (!tableExists.booleanValue()) {
                        stmt.executeUpdate(this.executionInfo.getPreparedCreateTableStatement());
                        con.commit();
                        this.executionInfo.setTableExist(true);
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"Cannot Execute Create Table Query", (Throwable)e);
                }
                this.cleanupConnections(stmt, con);
            }
            catch (SQLException e) {
                log.error((Object)"Connection unavailable", (Throwable)e);
            }
            finally {
                this.cleanupConnections(stmt, con);
            }
        }
    }

    private void cleanupConnections(Statement stmt, Connection connection) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.error((Object)("unable to close statement." + e.getMessage()), (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)("unable to close connection." + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void initializeDatabaseExecutionInfo() {
        String createTableQuery = "CREATE TABLE " + this.tableName + " (id INT NOT NULL AUTO_INCREMENT, tenantId VARCHAR(100), executionPlanId VARCHAR(100),revision  VARCHAR(100),snapshot  BLOB,  PRIMARY KEY (id))";
        String insertTableRowQuery = "INSERT INTO " + this.tableName + " (tenantId, executionPlanId, revision, snapshot) VALUES (?, ?, ?,?)";
        String isTableExistQuery = "SELECT * FROM " + this.tableName + " limit 1";
        String selectTableQuery = "SELECT snapshot FROM " + this.tableName + " WHERE  revision = ? AND  tenantId = ? AND executionPlanId = ? ";
        String selectLastQuery = "SELECT revision FROM " + this.tableName + " WHERE tenantId = ? AND executionPlanId = ? ORDER BY id DESC  LIMIT 1";
        String deleteRevisionQuery = "DELETE FROM " + this.tableName + " WHERE revision = ? AND executionPlanId = ? AND tenantId = ?";
        this.executionInfo.setPreparedInsertStatement(insertTableRowQuery);
        this.executionInfo.setPreparedCreateTableStatement(createTableQuery);
        this.executionInfo.setPreparedTableExistenceCheckStatement(isTableExistQuery);
        this.executionInfo.setPreparedSelectStatement(selectTableQuery);
        this.executionInfo.setPreparedSelectLastStatement(selectLastQuery);
        this.executionInfo.setPreparedDeleteStatement(deleteRevisionQuery);
    }

    private String getTenantId() {
        return String.valueOf(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId()).replaceAll("-", "M");
    }
}

