/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.listener;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.util.EventProcessorUtil;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.EventProducerCallback;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.output.StreamCallback;

public class SiddhiOutputStreamListener
extends StreamCallback
implements EventProducer {
    protected final String siddhiStreamName;
    protected final int tenantId;
    protected final String tenantDomain;
    protected final boolean traceEnabled;
    protected final boolean statisticsEnabled;
    private final String streamId;
    private StreamDefinition streamDefinition;
    private int metaAttributeCount;
    private int correlationAttributeCount;
    private int payloadAttributeCount;
    protected String tracerPrefix;
    private Counter eventCounter;
    protected EventProducerCallback eventProducerCallback;
    private Log trace = LogFactory.getLog((String)"EVENT_TRACE_LOGGER");

    public SiddhiOutputStreamListener(String siddhiStreamName, String streamId, ExecutionPlanConfiguration executionPlanConfiguration, int tenantId) throws EventStreamConfigurationException {
        this.streamId = streamId;
        this.tenantId = tenantId;
        this.tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        this.streamDefinition = EventProcessorValueHolder.getEventStreamService().getStreamDefinition(streamId);
        this.metaAttributeCount = this.streamDefinition.getMetaData() != null ? this.streamDefinition.getMetaData().size() : 0;
        this.correlationAttributeCount = this.streamDefinition.getCorrelationData() != null ? this.streamDefinition.getCorrelationData().size() : 0;
        this.payloadAttributeCount = this.streamDefinition.getPayloadData() != null ? this.streamDefinition.getPayloadData().size() : 0;
        this.siddhiStreamName = siddhiStreamName;
        this.traceEnabled = executionPlanConfiguration.isTracingEnabled();
        this.statisticsEnabled = executionPlanConfiguration.isStatisticsEnabled() && EventProcessorValueHolder.isGlobalStatisticsEnabled();
        String metricId = "WSO2_CEP.ExecutionPlans." + executionPlanConfiguration.getName() + "." + "Streams" + "[+]" + "." + streamId.replaceAll("\\.", "_") + "." + "OutputEvents";
        if (this.statisticsEnabled) {
            this.eventCounter = MetricManager.counter((String)metricId, (Level[])new Level[]{Level.INFO, Level.INFO});
        }
        if (this.traceEnabled) {
            this.tracerPrefix = "TenantId : " + tenantId + ", " + "Event Processor" + " : " + executionPlanConfiguration.getName() + ", " + "Event Stream" + " : " + streamId + " (" + siddhiStreamName + "), after processing " + System.getProperty("line.separator");
        }
    }

    public void receive(Event[] events) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(this.tenantId);
            privilegedCarbonContext.setTenantDomain(this.tenantDomain);
            if (this.traceEnabled) {
                this.trace.info((Object)(this.tracerPrefix + Arrays.deepToString(events)));
            }
            if (this.statisticsEnabled) {
                this.eventCounter.inc((long)events.length);
            }
            if (this.eventProducerCallback != null) {
                this.eventProducerCallback.sendEvents(EventProcessorUtil.getWso2Events(this.streamDefinition, this.metaAttributeCount, this.correlationAttributeCount, this.payloadAttributeCount, events));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void sendEvent(Event event) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(this.tenantId);
            privilegedCarbonContext.setTenantDomain(this.tenantDomain);
            if (this.traceEnabled) {
                this.trace.info((Object)(this.tracerPrefix + event));
            }
            if (this.statisticsEnabled) {
                this.eventCounter.inc();
            }
            if (this.eventProducerCallback != null) {
                this.eventProducerCallback.sendEvent(EventProcessorUtil.getWso2Event(this.streamDefinition, this.metaAttributeCount, this.correlationAttributeCount, this.payloadAttributeCount, event.getTimestamp(), event.getData()));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setCallBack(EventProducerCallback eventProducerCallback) {
        this.eventProducerCallback = eventProducerCallback;
    }
}

