/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfigurationFile;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.internal.CarbonEventProcessorService;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.stream.core.EventStreamListener;

public class EventStreamListenerImpl
implements EventStreamListener {
    private static final Log log = LogFactory.getLog(EventStreamListenerImpl.class);

    public void removedEventStream(int tenantId, String streamName, String streamVersion) {
        CarbonEventProcessorService carbonEventProcessorService = EventProcessorValueHolder.getEventProcessorService();
        String streamNameWithVersion = DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)streamVersion);
        carbonEventProcessorService.deactivateActiveExecutionPlanConfigurations(streamNameWithVersion);
    }

    public void addedEventStream(int tenantId, String streamName, String streamVersion) {
        CarbonEventProcessorService carbonEventProcessorService = EventProcessorValueHolder.getEventProcessorService();
        String streamNameWithVersion = DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)streamVersion);
        try {
            carbonEventProcessorService.activateInactiveExecutionPlanConfigurations(ExecutionPlanConfigurationFile.Status.WAITING_FOR_DEPENDENCY, streamNameWithVersion);
        }
        catch (ExecutionPlanConfigurationException e) {
            log.error((Object)"Exception occurred while re-deploying the Event processor configuration files");
        }
    }
}

