/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.listener;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.stream.core.SiddhiEventConsumer;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.siddhi.core.event.Event;

public abstract class AbstractSiddhiInputEventDispatcher
implements SiddhiEventConsumer {
    private Log trace = LogFactory.getLog((String)"EVENT_TRACE_LOGGER");
    private static Log log = LogFactory.getLog(AbstractSiddhiInputEventDispatcher.class);
    protected final String streamId;
    protected String siddhiStreamId;
    protected Object owner;
    protected final int tenantId;
    private final boolean traceEnabled;
    private final boolean statisticsEnabled;
    private Counter eventCounter;
    private String tracerPrefix = "";

    public AbstractSiddhiInputEventDispatcher(String streamId, String siddhiStreamId, ExecutionPlanConfiguration executionPlanConfiguration, int tenantId) {
        this.streamId = streamId;
        this.siddhiStreamId = siddhiStreamId;
        this.owner = executionPlanConfiguration;
        this.tenantId = tenantId;
        this.traceEnabled = executionPlanConfiguration.isTracingEnabled();
        this.statisticsEnabled = executionPlanConfiguration.isStatisticsEnabled() && EventProcessorValueHolder.isGlobalStatisticsEnabled();
        String metricId = "WSO2_CEP.ExecutionPlans." + executionPlanConfiguration.getName() + "." + "Streams" + "[+]" + "." + streamId.replaceAll("\\.", "_") + "." + "InputEvents";
        if (this.statisticsEnabled) {
            this.eventCounter = MetricManager.counter((String)metricId, (Level[])new Level[]{Level.INFO, Level.INFO});
        }
        if (this.traceEnabled) {
            this.tracerPrefix = "TenantId : " + tenantId + ", " + "Event Processor" + " : " + executionPlanConfiguration.getName() + ", " + "Event Stream" + " : " + streamId + " (" + siddhiStreamId + "), before processing " + System.getProperty("line.separator");
        }
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void consumeEvents(Event[] events) {
        if (this.traceEnabled) {
            this.trace.info((Object)(this.tracerPrefix + Arrays.deepToString(events)));
        }
        for (Event event : events) {
            try {
                if (this.statisticsEnabled) {
                    this.eventCounter.inc();
                }
                this.sendEvent(event);
            }
            catch (InterruptedException e) {
                log.error((Object)("Error in dispatching events " + Arrays.deepToString(events) + " to Siddhi stream :" + this.siddhiStreamId));
            }
        }
    }

    public void consumeEvent(Event event) {
        try {
            if (this.traceEnabled) {
                this.trace.info((Object)(this.tracerPrefix + event));
            }
            if (this.statisticsEnabled) {
                this.eventCounter.inc();
            }
            this.sendEvent(event);
        }
        catch (InterruptedException e) {
            log.error((Object)("Error in dispatching event " + event + " to Siddhi stream :" + this.siddhiStreamId));
        }
    }

    public String getExecutionPlanName() {
        return ((ExecutionPlanConfiguration)this.owner).getName();
    }

    public abstract void sendEvent(Event var1) throws InterruptedException;

    public void shutdown() {
    }
}

