/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal.ds;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.event.processor.core.EventProcessorService;
import org.wso2.carbon.event.processor.core.internal.CarbonEventProcessorManagementService;
import org.wso2.carbon.event.processor.core.internal.CarbonEventProcessorService;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.listener.EventStreamListenerImpl;
import org.wso2.carbon.event.processor.core.internal.storm.StormTopologyManager;
import org.wso2.carbon.event.processor.core.internal.storm.manager.StormManagerServer;
import org.wso2.carbon.event.processor.manager.core.EventManagementService;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.PersistenceConfiguration;
import org.wso2.carbon.event.stream.core.EventStreamListener;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.siddhi.metrics.core.SiddhiMetricsFactory;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.config.StatisticsConfiguration;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.statistics.StatisticsTrackerFactory;

@Component(name="eventProcessorService.component", immediate=true)
public class EventProcessorServiceDS {
    private static final Log log = LogFactory.getLog(EventProcessorServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            this.checkIsStatsEnabled();
            CarbonEventProcessorService carbonEventProcessorService = new CarbonEventProcessorService();
            EventProcessorValueHolder.registerEventProcessorService(carbonEventProcessorService);
            CarbonEventProcessorManagementService carbonEventReceiverManagementService = new CarbonEventProcessorManagementService();
            EventProcessorValueHolder.registerProcessorManagementService(carbonEventReceiverManagementService);
            DistributedConfiguration stormDeploymentConfig = carbonEventProcessorService.getManagementInfo().getDistributedConfiguration();
            if (stormDeploymentConfig != null) {
                EventProcessorValueHolder.registerStormDeploymentConfiguration(stormDeploymentConfig);
                EventProcessorValueHolder.registerStormTopologyManager(new StormTopologyManager());
                if (stormDeploymentConfig.isManagerNode()) {
                    StormManagerServer stormManagerServer = new StormManagerServer(stormDeploymentConfig.getLocalManagerConfig().getHostName(), stormDeploymentConfig.getLocalManagerConfig().getPort());
                    EventProcessorValueHolder.registerStormManagerServer(stormManagerServer);
                }
            }
            context.getBundleContext().registerService(EventProcessorService.class.getName(), (Object)carbonEventProcessorService, null);
            context.getBundleContext().registerService(EventStreamListener.class.getName(), (Object)new EventStreamListenerImpl(), null);
            SiddhiManager siddhiManager = new SiddhiManager();
            EventProcessorValueHolder.registerSiddhiManager(siddhiManager);
            PersistenceConfiguration persistConfig = carbonEventProcessorService.getManagementInfo().getPersistenceConfiguration();
            if (persistConfig != null) {
                Class<?> clazz = Class.forName(persistConfig.getPersistenceClass());
                PersistenceStore persistenceStore = (PersistenceStore)clazz.newInstance();
                siddhiManager.setPersistenceStore(persistenceStore);
                persistenceStore.setProperties(persistConfig.getPropertiesMap());
                EventProcessorValueHolder.registerPersistenceConfiguration(persistConfig);
            }
            StatisticsConfiguration statisticsConfiguration = new StatisticsConfiguration((StatisticsTrackerFactory)new SiddhiMetricsFactory(EventProcessorValueHolder.isGlobalStatisticsEnabled()));
            statisticsConfiguration.setMatricPrefix("WSO2_CEP");
            siddhiManager.setStatisticsConfiguration(statisticsConfiguration);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed EventProcessorService");
            }
        }
        catch (Throwable e) {
            log.error((Object)("Could not create EventProcessorService: " + e.getMessage()), e);
        }
    }

    protected void checkIsStatsEnabled() {
        boolean disabled;
        ServerConfiguration config = ServerConfiguration.getInstance();
        String confStatisticsReporterDisabled = config.getFirstProperty("StatisticsReporterDisabled");
        if (!"".equals(confStatisticsReporterDisabled) && (disabled = Boolean.valueOf(confStatisticsReporterDisabled).booleanValue())) {
            return;
        }
        EventProcessorValueHolder.setGlobalStatisticsEnabled(true);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        try {
            StormManagerServer stormManagerServer = EventProcessorValueHolder.getStormManagerServer();
            if (stormManagerServer != null) {
                stormManagerServer.stop();
            }
        }
        catch (RuntimeException e) {
            log.error((Object)("Error in stopping Storm Manager Service : " + e.getMessage()), (Throwable)e);
        }
        EventProcessorValueHolder.getEventProcessorService().shutdown();
    }

    @Reference(name="eventStreamManager.service", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        EventProcessorValueHolder.registerEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        EventProcessorValueHolder.registerEventStreamService(null);
    }

    @Reference(name="hazelcast.instance.service", service=HazelcastInstance.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetHazelcastInstance")
    protected void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        EventProcessorValueHolder.registerHazelcastInstance(hazelcastInstance);
        StormManagerServer stormManagerServer = EventProcessorValueHolder.getStormManagerServer();
        if (stormManagerServer != null) {
            stormManagerServer.setHzaelCastInstance(hazelcastInstance);
            stormManagerServer.tryBecomeCoordinator();
        }
        hazelcastInstance.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                StormManagerServer stormManagerServer = EventProcessorValueHolder.getStormManagerServer();
                if (stormManagerServer != null) {
                    stormManagerServer.verifyState();
                }
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                StormManagerServer stormManagerServer = EventProcessorValueHolder.getStormManagerServer();
                if (stormManagerServer != null) {
                    stormManagerServer.tryBecomeCoordinator();
                }
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
        EventProcessorValueHolder.getEventProcessorService().notifyServiceAvailability("hazelcast.instance");
    }

    protected void unsetHazelcastInstance(HazelcastInstance hazelcastInstance) {
        EventProcessorValueHolder.registerHazelcastInstance(null);
    }

    @Reference(name="user.realm.delegating", service=UserRealm.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserRealm")
    protected void setUserRealm(UserRealm userRealm) {
        EventProcessorValueHolder.setUserRealm(userRealm);
    }

    protected void unsetUserRealm(UserRealm userRealm) {
        EventProcessorValueHolder.setUserRealm(null);
    }

    @Reference(name="org.wso2.carbon.ndatasource", service=DataSourceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDataSourceService")
    protected void setDataSourceService(DataSourceService dataSourceService) {
        EventProcessorValueHolder.setDataSourceService(dataSourceService);
    }

    protected void unsetDataSourceService(DataSourceService dataSourceService) {
        EventProcessorValueHolder.setDataSourceService(null);
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfiguration")
    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        EventProcessorValueHolder.setServerConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        EventProcessorValueHolder.setServerConfiguration(null);
    }

    @Reference(name="configuration.context", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContext")
    protected void setConfigurationContext(ConfigurationContextService configurationContext) {
        EventProcessorValueHolder.setConfigurationContext(configurationContext);
    }

    protected void unsetConfigurationContext(ConfigurationContextService configurationContext) {
        EventProcessorValueHolder.setConfigurationContext(null);
    }

    @Reference(name="eventManagement.service", service=EventManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventManagementService")
    protected void setEventManagementService(EventManagementService eventManagementService) {
        EventProcessorValueHolder.registerEventManagementService(eventManagementService);
    }

    protected void unsetEventManagementService(EventManagementService eventManagementService) {
        EventProcessorValueHolder.registerEventManagementService(null);
    }
}

