/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.lmax.disruptor.ExceptionHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.processor.core.EventProcessorService;
import org.wso2.carbon.event.processor.core.ExecutionPlan;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfigurationFile;
import org.wso2.carbon.event.processor.core.StreamConfiguration;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanDependencyValidationException;
import org.wso2.carbon.event.processor.core.exception.StormDeploymentException;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.listener.AbstractSiddhiInputEventDispatcher;
import org.wso2.carbon.event.processor.core.internal.listener.SiddhiInputEventDispatcher;
import org.wso2.carbon.event.processor.core.internal.listener.SiddhiOutputStreamListener;
import org.wso2.carbon.event.processor.core.internal.storm.SiddhiStormInputEventDispatcher;
import org.wso2.carbon.event.processor.core.internal.storm.SiddhiStormOutputEventListener;
import org.wso2.carbon.event.processor.core.internal.storm.StormTopologyManager;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.StormStatusMapListener;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.StormStatusMonitor;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.exception.DeploymentStatusMonitorException;
import org.wso2.carbon.event.processor.core.internal.util.EventProcessorConfigurationFilesystemInvoker;
import org.wso2.carbon.event.processor.core.internal.util.EventProcessorUtil;
import org.wso2.carbon.event.processor.core.internal.util.helper.EventProcessorHelper;
import org.wso2.carbon.event.processor.core.util.ExecutionPlanStatusHolder;
import org.wso2.carbon.event.processor.manager.core.config.DistributedConfiguration;
import org.wso2.carbon.event.processor.manager.core.config.ManagementModeInfo;
import org.wso2.carbon.event.processor.manager.core.config.Mode;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.SiddhiEventConsumer;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;
import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.output.StreamCallback;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.util.AnnotationHelper;
import org.wso2.siddhi.query.compiler.SiddhiCompiler;
import org.wso2.siddhi.query.compiler.exception.SiddhiParserException;

public class CarbonEventProcessorService
implements EventProcessorService {
    private static final Log log = LogFactory.getLog(CarbonEventProcessorService.class);
    private Map<Integer, ConcurrentHashMap<String, ExecutionPlan>> tenantSpecificExecutionPlans = new ConcurrentHashMap<Integer, ConcurrentHashMap<String, ExecutionPlan>>();
    private Map<Integer, List<ExecutionPlanConfigurationFile>> tenantSpecificExecutionPlanFiles = new ConcurrentHashMap<Integer, List<ExecutionPlanConfigurationFile>>();
    private ManagementModeInfo managementInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployExecutionPlan(String executionPlan) throws ExecutionPlanDependencyValidationException, ExecutionPlanConfigurationException {
        try {
            String eventProcessorConfigPath;
            org.wso2.siddhi.query.api.ExecutionPlan parsedExecutionPlan = SiddhiCompiler.parse((String)executionPlan);
            String executionPlanName = AnnotationHelper.getAnnotationElement((String)"name", null, (List)parsedExecutionPlan.getAnnotations()).getValue();
            if (this.isExecutionPlanAlreadyExist(executionPlanName)) {
                throw new ExecutionPlanConfigurationException(executionPlanName + " already registered as an execution in this tenant");
            }
            String repoPath = EventProcessorUtil.getAxisConfiguration().getRepository().getPath();
            File directory = new File(repoPath);
            if (!directory.exists()) {
                String string = repoPath.intern();
                synchronized (string) {
                    if (!directory.mkdir()) {
                        throw new ExecutionPlanConfigurationException("Cannot create directory to add tenant specific execution plan : " + executionPlanName);
                    }
                }
            }
            if (!(directory = new File(eventProcessorConfigPath = directory.getAbsolutePath() + File.separator + "executionplans")).exists()) {
                String string = eventProcessorConfigPath.intern();
                synchronized (string) {
                    if (!directory.mkdir()) {
                        throw new ExecutionPlanConfigurationException("Cannot create directory executionplans to add tenant specific  execution plan :" + executionPlanName);
                    }
                }
            }
            this.validateToRemoveInactiveExecutionPlanConfiguration(executionPlanName);
            EventProcessorConfigurationFilesystemInvoker.save(executionPlan, executionPlanName, executionPlanName + ".siddhiql");
        }
        catch (SiddhiParserException re) {
            throw new ExecutionPlanConfigurationException("Couldn't parse execution plan: \n" + executionPlan + "\n");
        }
    }

    @Override
    public void undeployInactiveExecutionPlan(String filename) throws ExecutionPlanConfigurationException {
        EventProcessorConfigurationFilesystemInvoker.delete(filename);
    }

    @Override
    public void undeployActiveExecutionPlan(String planName) throws ExecutionPlanConfigurationException {
        EventProcessorConfigurationFilesystemInvoker.delete(this.getExecutionPlanConfigurationFileByPlanName(planName).getFileName());
    }

    @Override
    public void editActiveExecutionPlan(String executionPlan, String executionPlanName) throws ExecutionPlanConfigurationException, ExecutionPlanDependencyValidationException {
        EventProcessorHelper.validateExecutionPlan(executionPlan);
        org.wso2.siddhi.query.api.ExecutionPlan parsedExecutionPlan = SiddhiCompiler.parse((String)executionPlan);
        String newExecutionPlanName = AnnotationHelper.getAnnotationElement((String)"name", null, (List)parsedExecutionPlan.getAnnotations()).getValue();
        if (!newExecutionPlanName.equals(executionPlanName) && this.isExecutionPlanAlreadyExist(newExecutionPlanName)) {
            throw new ExecutionPlanConfigurationException(newExecutionPlanName + " already registered as an execution in this tenant");
        }
        if (executionPlanName == null || executionPlanName.length() <= 0) {
            throw new ExecutionPlanConfigurationException("Invalid configuration provided, No execution plan name.");
        }
        ExecutionPlanConfigurationFile file = this.getExecutionPlanConfigurationFileByPlanName(executionPlanName);
        String fileName = file == null ? executionPlanName + ".siddhiql" : file.getFileName();
        EventProcessorConfigurationFilesystemInvoker.delete(fileName);
        EventProcessorConfigurationFilesystemInvoker.save(executionPlan, newExecutionPlanName, newExecutionPlanName + ".siddhiql");
    }

    @Override
    public void editInactiveExecutionPlan(String executionPlan, String filename) throws ExecutionPlanConfigurationException, ExecutionPlanDependencyValidationException {
        EventProcessorHelper.validateExecutionPlan(executionPlan);
        org.wso2.siddhi.query.api.ExecutionPlan parsedExecutionPlan = SiddhiCompiler.parse((String)executionPlan);
        String newExecutionPlanName = AnnotationHelper.getAnnotationElement((String)"name", null, (List)parsedExecutionPlan.getAnnotations()).getValue();
        EventProcessorConfigurationFilesystemInvoker.delete(filename);
        EventProcessorConfigurationFilesystemInvoker.save(executionPlan, newExecutionPlanName, filename);
    }

    public void addExecutionPlan(String executionPlan, boolean isEditable) throws ExecutionPlanConfigurationException {
        StreamDefinition streamDefinition;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        SiddhiManager siddhiManager = EventProcessorValueHolder.getSiddhiManager();
        EventProcessorHelper.loadDataSourceConfiguration(siddhiManager);
        ExecutionPlanRuntime executionPlanRuntime = null;
        org.wso2.siddhi.query.api.ExecutionPlan parsedExecutionPlan = SiddhiCompiler.parse((String)executionPlan);
        ExecutionPlanConfiguration executionPlanConfiguration = new ExecutionPlanConfiguration();
        executionPlanConfiguration.setExecutionPlan(executionPlan);
        String executionPlanName = AnnotationHelper.getAnnotationElement((String)"name", null, (List)parsedExecutionPlan.getAnnotations()).getValue();
        executionPlanConfiguration.setName(executionPlanName);
        Element executionPlanDescriptionElement = AnnotationHelper.getAnnotationElement((String)"description", null, (List)parsedExecutionPlan.getAnnotations());
        if (executionPlanDescriptionElement != null) {
            String executionPlanDescription = executionPlanDescriptionElement.getValue();
            executionPlanConfiguration.setDescription(executionPlanDescription);
        } else {
            executionPlanConfiguration.setDescription("");
        }
        Element isTracingEnabledElement = AnnotationHelper.getAnnotationElement((String)"trace", null, (List)parsedExecutionPlan.getAnnotations());
        if (isTracingEnabledElement != null) {
            String isTracingEnabled = isTracingEnabledElement.getValue();
            executionPlanConfiguration.setTracingEnabled(Boolean.valueOf(isTracingEnabled));
        } else {
            executionPlanConfiguration.setTracingEnabled(false);
        }
        Element isStatsEnabledElement = AnnotationHelper.getAnnotationElement((String)"statistics", null, (List)parsedExecutionPlan.getAnnotations());
        if (isStatsEnabledElement != null) {
            String isStatsEnabled = isStatsEnabledElement.getValue();
            executionPlanConfiguration.setStatisticsEnabled(Boolean.valueOf(isStatsEnabled));
        } else {
            executionPlanConfiguration.setStatisticsEnabled(false);
        }
        executionPlanConfiguration.setEditable(isEditable);
        ConcurrentHashMap<String, ExecutionPlan> tenantExecutionPlans = this.tenantSpecificExecutionPlans.get(tenantId);
        if (tenantExecutionPlans == null) {
            tenantExecutionPlans = new ConcurrentHashMap();
            this.tenantSpecificExecutionPlans.put(tenantId, tenantExecutionPlans);
        } else if (tenantExecutionPlans.get(executionPlanName) != null) {
            throw new ExecutionPlanConfigurationException("Execution plan with the same name already exists. Please remove it and retry.");
        }
        HashMap<String, String> importsMap = new HashMap<String, String>();
        HashMap<String, String> exportsMap = new HashMap<String, String>();
        for (Map.Entry entry : parsedExecutionPlan.getStreamDefinitionMap().entrySet()) {
            String streamVersion;
            String streamName;
            String[] streamIdComponents;
            String streamId;
            String siddhiStreamName = (String)entry.getKey();
            Element importElement = AnnotationHelper.getAnnotationElement((String)"Import", null, (List)((org.wso2.siddhi.query.api.definition.StreamDefinition)entry.getValue()).getAnnotations());
            Element exportElement = AnnotationHelper.getAnnotationElement((String)"Export", null, (List)((org.wso2.siddhi.query.api.definition.StreamDefinition)entry.getValue()).getAnnotations());
            if (importElement != null) {
                streamId = importElement.getValue();
                importsMap.put(siddhiStreamName, streamId);
                streamIdComponents = streamId.split(":");
                streamName = streamIdComponents[0];
                streamVersion = streamIdComponents[1];
                executionPlanConfiguration.addImportedStream(new StreamConfiguration(streamName, streamVersion, siddhiStreamName));
            }
            if (exportElement == null) continue;
            streamId = exportElement.getValue();
            exportsMap.put(siddhiStreamName, streamId);
            streamIdComponents = streamId.split(":");
            streamName = streamIdComponents[0];
            streamVersion = streamIdComponents[1];
            executionPlanConfiguration.addExportedStream(new StreamConfiguration(streamName, streamVersion, siddhiStreamName));
        }
        ConcurrentHashMap inputHandlerMap = new ConcurrentHashMap(importsMap.size());
        ArrayList<String> importDefinitions = new ArrayList<String>(executionPlanConfiguration.getImportedStreams().size());
        for (StreamConfiguration importedStreamConfiguration : executionPlanConfiguration.getImportedStreams()) {
            try {
                streamDefinition = EventProcessorValueHolder.getEventStreamService().getStreamDefinition(importedStreamConfiguration.getStreamId());
                importDefinitions.add(EventProcessorUtil.getDefinitionString(streamDefinition, importedStreamConfiguration.getSiddhiStreamName()));
            }
            catch (EventStreamConfigurationException streamIdComponents) {}
        }
        ArrayList<String> exportDefinitions = new ArrayList<String>(executionPlanConfiguration.getExportedStreams().size());
        for (StreamConfiguration exportedStreamConfiguration : executionPlanConfiguration.getExportedStreams()) {
            try {
                streamDefinition = EventProcessorValueHolder.getEventStreamService().getStreamDefinition(exportedStreamConfiguration.getStreamId());
                exportDefinitions.add(EventProcessorUtil.getDefinitionString(streamDefinition, exportedStreamConfiguration.getSiddhiStreamName()));
            }
            catch (EventStreamConfigurationException streamIdComponents) {}
        }
        DistributedConfiguration stormDeploymentConfiguration = EventProcessorValueHolder.getStormDeploymentConfiguration();
        try {
            executionPlanRuntime = siddhiManager.createExecutionPlanRuntime(executionPlan);
            executionPlanRuntime.handleExceptionWith((ExceptionHandler)new ExceptionHandler<Object>(){

                public void handleEventException(Throwable throwable, long l, Object o) {
                    log.error((Object)throwable.getMessage(), throwable);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Event dropped by distruptor due to exception : " + o));
                    }
                }

                public void handleOnStartException(Throwable throwable) {
                    log.error((Object)"Exception when starting the distruptor process ", throwable);
                }

                public void handleOnShutdownException(Throwable throwable) {
                    log.error((Object)"Exception when stopping the distruptor process ", throwable);
                }
            });
        }
        catch (Exception e) {
            throw new ExecutionPlanConfigurationException("Invalid query specified, " + e.getMessage(), e);
        }
        if (this.managementInfo.getMode() == Mode.Distributed && stormDeploymentConfiguration != null && stormDeploymentConfiguration.isManagerNode() && EventProcessorValueHolder.getStormManagerServer().isStormCoordinator()) {
            try {
                EventProcessorValueHolder.getStormTopologyManager().submitTopology(executionPlanConfiguration, importDefinitions, exportDefinitions, tenantId, stormDeploymentConfiguration.getTopologySubmitRetryInterval());
            }
            catch (StormDeploymentException e) {
                throw new ExecutionPlanConfigurationException("Invalid distributed query specified, " + e.getMessage(), e);
            }
        }
        for (Map.Entry entry : importsMap.entrySet()) {
            inputHandlerMap.put(entry.getValue(), executionPlanRuntime.getInputHandler((String)entry.getKey()));
        }
        ExecutionPlan processorExecutionPlan = new ExecutionPlan(executionPlanName, executionPlanRuntime, executionPlanConfiguration);
        tenantExecutionPlans.put(executionPlanName, processorExecutionPlan);
        boolean isDistributedEnabledAndIsWorker = this.managementInfo.getMode() == Mode.Distributed && stormDeploymentConfiguration != null && stormDeploymentConfiguration.isWorkerNode();
        StormStatusMonitor stormStatusMonitor = null;
        if (isDistributedEnabledAndIsWorker) {
            StormStatusMapListener mapListener = null;
            try {
                stormStatusMonitor = new StormStatusMonitor(tenantId, executionPlanName, importsMap.size());
                mapListener = new StormStatusMapListener(executionPlanName, tenantId, stormStatusMonitor);
            }
            catch (DeploymentStatusMonitorException e) {
                log.error((Object)("Failed to initialize map listener. Reason: " + e.getMessage()), (Throwable)e);
            }
            processorExecutionPlan.setStormStatusMonitor(stormStatusMonitor);
            processorExecutionPlan.setStormStatusMapListener(mapListener);
        }
        SiddhiStormOutputEventListener stormOutputListener = null;
        if (this.managementInfo.getMode() == Mode.Distributed && this.managementInfo.getDistributedConfiguration().isWorkerNode()) {
            stormOutputListener = new SiddhiStormOutputEventListener(executionPlanConfiguration, tenantId, stormDeploymentConfiguration, stormStatusMonitor);
            processorExecutionPlan.addStormOutputListener(stormOutputListener);
        }
        for (Map.Entry entry : exportsMap.entrySet()) {
            SiddhiOutputStreamListener siddhiOutputStreamListener;
            try {
                siddhiOutputStreamListener = new SiddhiOutputStreamListener((String)entry.getKey(), (String)entry.getValue(), executionPlanConfiguration, tenantId);
            }
            catch (EventStreamConfigurationException e) {
                throw new ExecutionPlanConfigurationException(e.getMessage(), e);
            }
            try {
                EventProcessorValueHolder.getEventStreamService().subscribe((EventProducer)siddhiOutputStreamListener);
            }
            catch (EventStreamConfigurationException e) {
                // empty catch block
            }
            if (this.managementInfo.getMode() == Mode.Distributed && stormDeploymentConfiguration != null && stormDeploymentConfiguration.isWorkerNode()) {
                try {
                    StreamDefinition databridgeDefinition = EventProcessorValueHolder.getEventStreamService().getStreamDefinition((String)entry.getValue());
                    org.wso2.siddhi.query.api.definition.StreamDefinition siddhiStreamDefinition = EventProcessorUtil.convertToSiddhiStreamDefinition(databridgeDefinition, (String)entry.getKey());
                    stormOutputListener.registerOutputStreamListener(siddhiStreamDefinition, siddhiOutputStreamListener);
                }
                catch (EventStreamConfigurationException e) {
                    throw new ExecutionPlanConfigurationException(e.getMessage(), e);
                }
            } else {
                executionPlanRuntime.addCallback((String)entry.getKey(), (StreamCallback)siddhiOutputStreamListener);
            }
            processorExecutionPlan.addProducer(siddhiOutputStreamListener);
        }
        ArrayList<SiddhiInputEventDispatcher> inputEventDispatchers = new ArrayList<SiddhiInputEventDispatcher>();
        for (Map.Entry entry : importsMap.entrySet()) {
            AbstractSiddhiInputEventDispatcher eventDispatcher;
            InputHandler inputHandler = (InputHandler)inputHandlerMap.get(entry.getValue());
            if (isDistributedEnabledAndIsWorker) {
                StreamDefinition streamDefinition2 = null;
                try {
                    streamDefinition2 = EventProcessorValueHolder.getEventStreamService().getStreamDefinition((String)entry.getValue());
                }
                catch (EventStreamConfigurationException eventStreamConfigurationException) {
                    // empty catch block
                }
                eventDispatcher = new SiddhiStormInputEventDispatcher(streamDefinition2, (String)entry.getKey(), executionPlanConfiguration, tenantId, stormDeploymentConfiguration, stormStatusMonitor);
            } else {
                eventDispatcher = new SiddhiInputEventDispatcher((String)entry.getValue(), inputHandler, executionPlanConfiguration, tenantId);
            }
            inputEventDispatchers.add((SiddhiInputEventDispatcher)eventDispatcher);
        }
        if (executionPlanRuntime != null) {
            executionPlanRuntime.start();
        }
        for (AbstractSiddhiInputEventDispatcher abstractSiddhiInputEventDispatcher : inputEventDispatchers) {
            try {
                EventProcessorValueHolder.getEventStreamService().subscribe((SiddhiEventConsumer)abstractSiddhiInputEventDispatcher);
                processorExecutionPlan.addConsumer(abstractSiddhiInputEventDispatcher);
            }
            catch (EventStreamConfigurationException eventStreamConfigurationException) {}
        }
        if (EventProcessorValueHolder.getPersistenceConfiguration() != null && (this.managementInfo.getMode() == Mode.SingleNode || this.managementInfo.getMode() == Mode.HA && this.managementInfo.getHaConfiguration().isActive())) {
            executionPlanRuntime.restoreLastRevision();
        }
    }

    @Override
    public List<StreamDefinition> getSiddhiStreams(String executionPlan) {
        SiddhiManager siddhiManager = EventProcessorValueHolder.getSiddhiManager();
        EventProcessorHelper.loadDataSourceConfiguration(siddhiManager);
        ExecutionPlanRuntime executionPlanRuntime = siddhiManager.createExecutionPlanRuntime(executionPlan);
        Collection streamDefinitions = executionPlanRuntime.getStreamDefinitionMap().values();
        ArrayList<StreamDefinition> databridgeStreamDefinitions = new ArrayList<StreamDefinition>(streamDefinitions.size());
        for (AbstractDefinition siddhiStreamDef : streamDefinitions) {
            StreamConfiguration streamConfig = new StreamConfiguration(siddhiStreamDef.getId());
            StreamDefinition databridgeStreamDef = EventProcessorUtil.convertToDatabridgeStreamDefinition((org.wso2.siddhi.query.api.definition.StreamDefinition)siddhiStreamDef, streamConfig);
            databridgeStreamDefinitions.add(databridgeStreamDef);
        }
        executionPlanRuntime.shutdown();
        return databridgeStreamDefinitions;
    }

    @Override
    public boolean isDistributedProcessingEnabled() {
        return this.managementInfo.getMode() == Mode.Distributed;
    }

    @Override
    public Map<String, String> getAllExecutionPlanStatusesInStorm() {
        HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map executionPlanMap = this.tenantSpecificExecutionPlans.get(tenantId);
        Set executionPlanNames = executionPlanMap.keySet();
        HashMap<String, String> executionPlanStatuses = new HashMap<String, String>();
        for (String executionPlanName : executionPlanNames) {
            IMap executionPlanStatusHolderIMap;
            ExecutionPlanStatusHolder statusHolder;
            String status = hazelcastInstance == null ? "No status info available. \nTo get status info, enable clustering." : ((statusHolder = (ExecutionPlanStatusHolder)(executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui")).get((Object)StormTopologyManager.getTopologyName(executionPlanName, tenantId))) == null ? "Execution plan not deployed to a manager. Hence no status info available." : statusHolder.getExecutionPlanStatus());
            executionPlanStatuses.put(executionPlanName, status);
        }
        return executionPlanStatuses;
    }

    @Override
    public void validateExecutionPlan(String executionPlan) throws ExecutionPlanConfigurationException, ExecutionPlanDependencyValidationException {
        EventProcessorHelper.validateExecutionPlan(executionPlan);
    }

    public ManagementModeInfo getManagementInfo() {
        return this.managementInfo;
    }

    public void setManagementInfo(ManagementModeInfo managementInfo) {
        this.managementInfo = managementInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServiceAvailability(String serviceId) {
        for (Integer tenantId : this.tenantSpecificExecutionPlanFiles.keySet()) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId.intValue());
                PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
                this.activateInactiveExecutionPlanConfigurations(ExecutionPlanConfigurationFile.Status.WAITING_FOR_OSGI_SERVICE, serviceId);
            }
            catch (ExecutionPlanConfigurationException e) {
                log.error((Object)"Error while redeploying distributed execution plans.", (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private void removeExecutionPlanConfiguration(String name) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        Map executionPlanMap = this.tenantSpecificExecutionPlans.get(tenantId);
        if (executionPlanMap != null && executionPlanMap.containsKey(name)) {
            ExecutionPlan executionPlan = (ExecutionPlan)executionPlanMap.remove(name);
            executionPlan.shutdown();
            ExecutionPlanConfiguration executionPlanConfiguration = executionPlan.getExecutionPlanConfiguration();
            DistributedConfiguration stormDeploymentConfig = EventProcessorValueHolder.getStormDeploymentConfiguration();
            if (this.managementInfo.getMode() == Mode.Distributed && stormDeploymentConfig != null && stormDeploymentConfig.isManagerNode() && EventProcessorValueHolder.getStormManagerServer().isStormCoordinator()) {
                try {
                    this.removeExecutionPlanStatusHolder(executionPlanConfiguration.getName(), tenantId);
                    EventProcessorValueHolder.getStormTopologyManager().killTopology(executionPlanConfiguration.getName(), tenantId);
                    EventProcessorValueHolder.getStormManagerServer().onExecutionPlanRemove(name, tenantId);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (SiddhiEventConsumer eventConsumer : executionPlan.getSiddhiEventConsumers()) {
                EventProcessorValueHolder.getEventStreamService().unsubscribe(eventConsumer);
            }
            for (EventProducer eventProducer : executionPlan.getEventProducers()) {
                EventProcessorValueHolder.getEventStreamService().unsubscribe(eventProducer);
            }
        }
    }

    void removeExecutionPlanStatusHolder(String executionPlanName, int tenantId) {
        HazelcastInstance hazelcastInstance = EventProcessorValueHolder.getHazelcastInstance();
        if (hazelcastInstance != null && hazelcastInstance.getLifecycleService().isRunning()) {
            IMap executionPlanStatusHolderIMap = hazelcastInstance.getMap("org.wso2.cep.org.wso2.carbon.event.processor.core.storm.status.execution.plan.ui");
            String stormTopologyName = StormTopologyManager.getTopologyName(executionPlanName, tenantId);
            ExecutionPlanStatusHolder executionPlanStatusHolder = (ExecutionPlanStatusHolder)executionPlanStatusHolderIMap.get((Object)stormTopologyName);
            executionPlanStatusHolderIMap.remove((Object)stormTopologyName, (Object)executionPlanStatusHolder);
        } else {
            log.error((Object)("Couldn't clean status info for execution plan: " + executionPlanName + ", for tenant ID : " + tenantId + " as the hazelcast instance is not active or not available."));
        }
    }

    public void addExecutionPlanConfigurationFile(ExecutionPlanConfigurationFile configurationFile) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        List<ExecutionPlanConfigurationFile> executionPlanConfigurationFiles = this.tenantSpecificExecutionPlanFiles.get(tenantId);
        if (executionPlanConfigurationFiles == null) {
            executionPlanConfigurationFiles = new CopyOnWriteArrayList<ExecutionPlanConfigurationFile>();
            this.tenantSpecificExecutionPlanFiles.put(tenantId, executionPlanConfigurationFiles);
        }
        executionPlanConfigurationFiles.add(configurationFile);
    }

    public void removeExecutionPlanConfigurationFile(String fileName) {
        List<ExecutionPlanConfigurationFile> executionPlanConfigurationFiles = this.tenantSpecificExecutionPlanFiles.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        for (ExecutionPlanConfigurationFile configurationFile : executionPlanConfigurationFiles) {
            if (!new File(configurationFile.getFileName()).getName().equals(fileName)) continue;
            if (configurationFile.getStatus().equals((Object)ExecutionPlanConfigurationFile.Status.DEPLOYED)) {
                this.removeExecutionPlanConfiguration(configurationFile.getExecutionPlanName());
            }
            executionPlanConfigurationFiles.remove(configurationFile);
            return;
        }
    }

    @Override
    public String getActiveExecutionPlan(String planName) throws ExecutionPlanConfigurationException {
        ExecutionPlanConfigurationFile configFile = this.getExecutionPlanConfigurationFileByPlanName(planName);
        if (configFile == null) {
            throw new ExecutionPlanConfigurationException("Configuration file for " + planName + " doesn't exist.");
        }
        return EventProcessorConfigurationFilesystemInvoker.readExecutionPlanConfigFile(configFile.getFileName());
    }

    @Override
    public String getInactiveExecutionPlan(String filename) throws ExecutionPlanConfigurationException {
        return EventProcessorConfigurationFilesystemInvoker.readExecutionPlanConfigFile(filename);
    }

    @Override
    public Map<String, ExecutionPlanConfiguration> getAllActiveExecutionConfigurations() {
        HashMap<String, ExecutionPlanConfiguration> configurationMap = new HashMap<String, ExecutionPlanConfiguration>();
        Map executionPlanMap = this.tenantSpecificExecutionPlans.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (executionPlanMap != null) {
            for (Map.Entry entry : executionPlanMap.entrySet()) {
                configurationMap.put((String)entry.getKey(), ((ExecutionPlan)entry.getValue()).getExecutionPlanConfiguration());
            }
        }
        return configurationMap;
    }

    @Override
    public Map<String, ExecutionPlanConfiguration> getAllExportedStreamSpecificActiveExecutionConfigurations(String streamId) {
        HashMap<String, ExecutionPlanConfiguration> configurationMap = new HashMap<String, ExecutionPlanConfiguration>();
        Map executionPlanMap = this.tenantSpecificExecutionPlans.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (executionPlanMap != null) {
            for (Map.Entry entry : executionPlanMap.entrySet()) {
                List<StreamConfiguration> streamConfigurationList = ((ExecutionPlan)entry.getValue()).getExecutionPlanConfiguration().getExportedStreams();
                for (StreamConfiguration streamConfiguration : streamConfigurationList) {
                    String streamNameWithVersion = streamConfiguration.getName() + ":" + streamConfiguration.getVersion();
                    if (!streamNameWithVersion.equals(streamId)) continue;
                    configurationMap.put((String)entry.getKey(), ((ExecutionPlan)entry.getValue()).getExecutionPlanConfiguration());
                }
            }
        }
        return configurationMap;
    }

    @Override
    public Map<String, ExecutionPlanConfiguration> getAllImportedStreamSpecificActiveExecutionConfigurations(String streamId) {
        HashMap<String, ExecutionPlanConfiguration> configurationMap = new HashMap<String, ExecutionPlanConfiguration>();
        Map executionPlanMap = this.tenantSpecificExecutionPlans.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (executionPlanMap != null) {
            for (Map.Entry entry : executionPlanMap.entrySet()) {
                List<StreamConfiguration> streamConfigurationList = ((ExecutionPlan)entry.getValue()).getExecutionPlanConfiguration().getImportedStreams();
                for (StreamConfiguration streamConfiguration : streamConfigurationList) {
                    String streamNameWithVersion = streamConfiguration.getName() + ":" + streamConfiguration.getVersion();
                    if (!streamNameWithVersion.equals(streamId)) continue;
                    configurationMap.put((String)entry.getKey(), ((ExecutionPlan)entry.getValue()).getExecutionPlanConfiguration());
                }
            }
        }
        return configurationMap;
    }

    @Override
    public ExecutionPlanConfiguration getActiveExecutionPlanConfiguration(String planName) {
        ExecutionPlan executionPlan;
        Map executionPlanMap = this.tenantSpecificExecutionPlans.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (executionPlanMap != null && (executionPlan = (ExecutionPlan)executionPlanMap.get(planName)) != null) {
            return executionPlan.getExecutionPlanConfiguration();
        }
        return null;
    }

    public ExecutionPlan getActiveExecutionPlan(String name, int tenantId) {
        Map executionPlanMap = this.tenantSpecificExecutionPlans.get(tenantId);
        if (executionPlanMap != null) {
            return (ExecutionPlan)executionPlanMap.get(name);
        }
        return null;
    }

    @Override
    public List<ExecutionPlanConfigurationFile> getAllInactiveExecutionPlanConfiguration() {
        List<ExecutionPlanConfigurationFile> executionPlanConfigurationFiles = this.tenantSpecificExecutionPlanFiles.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        ArrayList<ExecutionPlanConfigurationFile> files = new ArrayList<ExecutionPlanConfigurationFile>();
        if (executionPlanConfigurationFiles != null) {
            for (ExecutionPlanConfigurationFile configFile : executionPlanConfigurationFiles) {
                if (configFile.getStatus() != ExecutionPlanConfigurationFile.Status.ERROR && configFile.getStatus() != ExecutionPlanConfigurationFile.Status.WAITING_FOR_DEPENDENCY && configFile.getStatus() != ExecutionPlanConfigurationFile.Status.WAITING_FOR_OSGI_SERVICE) continue;
                files.add(configFile);
            }
        }
        return files;
    }

    @Override
    public void setTracingEnabled(String executionPlanName, boolean isEnabled) throws ExecutionPlanConfigurationException {
        Map executionPlans = this.tenantSpecificExecutionPlans.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (executionPlans != null) {
            ExecutionPlan processorExecutionPlan = (ExecutionPlan)executionPlans.get(executionPlanName);
            ExecutionPlanConfiguration executionPlanConfiguration = processorExecutionPlan.getExecutionPlanConfiguration();
            executionPlanConfiguration.setTracingEnabled(isEnabled);
            String executionPlan = executionPlanConfiguration.getExecutionPlan();
            String newExecutionPlan = EventProcessorHelper.setExecutionPlanAnnotationName(executionPlan, "trace", isEnabled);
            executionPlanConfiguration.setExecutionPlan(newExecutionPlan);
            ExecutionPlanConfigurationFile configFile = this.getExecutionPlanConfigurationFileByPlanName(executionPlanName);
            String fileName = configFile.getFileName();
            EventProcessorConfigurationFilesystemInvoker.delete(fileName);
            EventProcessorConfigurationFilesystemInvoker.save(newExecutionPlan, executionPlanName, fileName);
        }
    }

    @Override
    public void setStatisticsEnabled(String executionPlanName, boolean isEnabled) throws ExecutionPlanConfigurationException {
        Map processorExecutionPlans = this.tenantSpecificExecutionPlans.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (processorExecutionPlans != null) {
            ExecutionPlan processorExecutionPlan = (ExecutionPlan)processorExecutionPlans.get(executionPlanName);
            ExecutionPlanConfiguration executionPlanConfiguration = processorExecutionPlan.getExecutionPlanConfiguration();
            executionPlanConfiguration.setStatisticsEnabled(isEnabled);
            String executionPlan = executionPlanConfiguration.getExecutionPlan();
            String newExecutionPlan = EventProcessorHelper.setExecutionPlanAnnotationName(executionPlan, "statistics", isEnabled);
            executionPlanConfiguration.setExecutionPlan(newExecutionPlan);
            ExecutionPlanConfigurationFile configFile = this.getExecutionPlanConfigurationFileByPlanName(executionPlanName);
            String fileName = configFile.getFileName();
            EventProcessorConfigurationFilesystemInvoker.delete(fileName);
            EventProcessorConfigurationFilesystemInvoker.save(newExecutionPlan, executionPlanName, fileName);
        }
    }

    public void activateInactiveExecutionPlanConfigurations(ExecutionPlanConfigurationFile.Status status, String resolvedDependencyId) throws ExecutionPlanConfigurationException {
        List<ExecutionPlanConfigurationFile> executionPlanConfigurationFiles;
        ArrayList<ExecutionPlanConfigurationFile> reloadFileList = new ArrayList<ExecutionPlanConfigurationFile>();
        if (this.tenantSpecificExecutionPlanFiles != null && this.tenantSpecificExecutionPlanFiles.size() > 0 && (executionPlanConfigurationFiles = this.tenantSpecificExecutionPlanFiles.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId())) != null) {
            for (ExecutionPlanConfigurationFile executionPlanConfigurationFile : executionPlanConfigurationFiles) {
                if (!executionPlanConfigurationFile.getStatus().equals((Object)status) || !resolvedDependencyId.equalsIgnoreCase(executionPlanConfigurationFile.getDependency())) continue;
                reloadFileList.add(executionPlanConfigurationFile);
            }
        }
        for (ExecutionPlanConfigurationFile executionPlanConfigurationFile : reloadFileList) {
            try {
                EventProcessorConfigurationFilesystemInvoker.reload(executionPlanConfigurationFile.getFilePath());
            }
            catch (ExecutionPlanConfigurationException e) {
                log.error((Object)("Exception occurred while trying to deploy the Execution Plan configuration file : " + new File(executionPlanConfigurationFile.getFileName()).getName() + "," + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void deactivateActiveExecutionPlanConfigurations(String streamId) {
        ArrayList<String> toDeactivateExecutionPlan = new ArrayList<String>();
        Map executionPlanMap = this.tenantSpecificExecutionPlans.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (executionPlanMap != null) {
            block2: for (ExecutionPlan executionPlan : executionPlanMap.values()) {
                boolean done = false;
                for (EventProducer eventProducer : executionPlan.getEventProducers()) {
                    if (!eventProducer.getStreamId().equals(streamId)) continue;
                    toDeactivateExecutionPlan.add(executionPlan.getName());
                    done = true;
                    break;
                }
                if (done) continue;
                for (SiddhiEventConsumer eventConsumer : executionPlan.getSiddhiEventConsumers()) {
                    if (!eventConsumer.getStreamId().equals(streamId)) continue;
                    toDeactivateExecutionPlan.add(executionPlan.getName());
                    continue block2;
                }
            }
        }
        if (toDeactivateExecutionPlan.size() > 0) {
            for (String name : toDeactivateExecutionPlan) {
                ExecutionPlanConfigurationFile executionPlanConfigurationFile = this.getExecutionPlanConfigurationFileByPlanName(name);
                try {
                    EventProcessorConfigurationFilesystemInvoker.reload(executionPlanConfigurationFile.getFilePath());
                }
                catch (Exception e) {
                    log.error((Object)("Exception occurred while trying to deploy the Execution Plan configuration file : " + new File(executionPlanConfigurationFile.getFileName()).getName()));
                }
            }
        }
    }

    private ExecutionPlanConfigurationFile getExecutionPlanConfigurationFileByPlanName(String name) {
        List<ExecutionPlanConfigurationFile> executionPlanConfigurationFiles = this.tenantSpecificExecutionPlanFiles.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (executionPlanConfigurationFiles != null) {
            for (ExecutionPlanConfigurationFile file : executionPlanConfigurationFiles) {
                if (!name.equals(file.getExecutionPlanName()) || !file.getStatus().equals((Object)ExecutionPlanConfigurationFile.Status.DEPLOYED)) continue;
                return file;
            }
        }
        return null;
    }

    private void validateToRemoveInactiveExecutionPlanConfiguration(String executionPlanName) throws ExecutionPlanConfigurationException {
        String fileName = executionPlanName + ".siddhiql";
        List<ExecutionPlanConfigurationFile> executionPlanConfigurationFiles = this.tenantSpecificExecutionPlanFiles.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (executionPlanConfigurationFiles != null) {
            for (ExecutionPlanConfigurationFile executionPlanConfigurationFile : executionPlanConfigurationFiles) {
                if (!executionPlanConfigurationFile.getFileName().equals(fileName) || executionPlanConfigurationFile.getStatus().equals((Object)ExecutionPlanConfigurationFile.Status.DEPLOYED)) continue;
                EventProcessorConfigurationFilesystemInvoker.delete(fileName);
                break;
            }
        }
    }

    private boolean isExecutionPlanAlreadyExist(String executionPlanName) throws ExecutionPlanConfigurationException {
        Map<String, ExecutionPlanConfiguration> executionPlanConfigurationMap = this.getAllActiveExecutionConfigurations();
        if (executionPlanConfigurationMap != null) {
            for (String existingExecutionPlanName : executionPlanConfigurationMap.keySet()) {
                if (!executionPlanName.equalsIgnoreCase(existingExecutionPlanName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExecutionPlanFileAlreadyExist(String executionPlanFileName) throws ExecutionPlanConfigurationException {
        List<ExecutionPlanConfigurationFile> executionPlanConfigurationFileList;
        if (this.tenantSpecificExecutionPlanFiles.size() > 0 && (executionPlanConfigurationFileList = this.tenantSpecificExecutionPlanFiles.get(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId())) != null) {
            for (ExecutionPlanConfigurationFile executionPlanConfigurationFile : executionPlanConfigurationFileList) {
                if (!executionPlanConfigurationFile.getFileName().equals(executionPlanFileName)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<Integer, ConcurrentHashMap<String, ExecutionPlan>> getTenantSpecificExecutionPlans() {
        return this.tenantSpecificExecutionPlans;
    }

    public void shutdown() {
        for (Map.Entry<Integer, ConcurrentHashMap<String, ExecutionPlan>> executionPlans : this.tenantSpecificExecutionPlans.entrySet()) {
            for (ExecutionPlan executionPlan : executionPlans.getValue().values()) {
                try {
                    executionPlan.shutdown();
                }
                catch (RuntimeException e) {
                    log.error((Object)("Error in shutting down ExecutionPlan '" + executionPlan.getName() + "' of tenant '" + executionPlans.getKey() + "'," + e.getMessage()), (Throwable)e);
                }
            }
        }
        log.info((Object)"Successfully shutdown ExecutionPlans");
    }
}

