/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.processor.core.ExecutionPlan;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.manager.core.EventProcessorManagementService;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.carbon.event.processor.manager.core.config.ManagementModeInfo;
import org.wso2.carbon.event.processor.manager.core.exception.EventManagementException;
import org.wso2.siddhi.core.util.snapshot.ByteSerializer;

public class CarbonEventProcessorManagementService
extends EventProcessorManagementService {
    private static final Log log = LogFactory.getLog(CarbonEventProcessorManagementService.class);
    private int tenantId;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public CarbonEventProcessorManagementService() {
        EventProcessorValueHolder.getEventManagementService().subscribe((Manager)this);
        EventProcessorValueHolder.getEventProcessorService().setManagementInfo(EventProcessorValueHolder.getEventManagementService().getManagementModeInfo());
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public byte[] getState() {
        Map<Integer, ConcurrentHashMap<String, ExecutionPlan>> map = EventProcessorValueHolder.getEventProcessorService().getTenantSpecificExecutionPlans();
        HashMap snapshotdata = new HashMap();
        for (Map.Entry<Integer, ConcurrentHashMap<String, ExecutionPlan>> tenantEntry : map.entrySet()) {
            HashMap<String, byte[]> tenantData = new HashMap<String, byte[]>();
            for (Map.Entry<String, ExecutionPlan> executionPlanData : tenantEntry.getValue().entrySet()) {
                tenantData.put(executionPlanData.getKey(), executionPlanData.getValue().getExecutionPlanRuntime().snapshot());
            }
            snapshotdata.put(tenantEntry.getKey(), tenantData);
        }
        return ByteSerializer.OToB(snapshotdata);
    }

    public void restoreState(byte[] bytes) {
        Map<Integer, ConcurrentHashMap<String, ExecutionPlan>> map = EventProcessorValueHolder.getEventProcessorService().getTenantSpecificExecutionPlans();
        HashMap snapshotDataList = (HashMap)ByteSerializer.BToO((byte[])bytes);
        for (Map.Entry tenantEntry : snapshotDataList.entrySet()) {
            for (Map.Entry executionPlanData : ((HashMap)tenantEntry.getValue()).entrySet()) {
                ConcurrentHashMap<String, ExecutionPlan> executionPlanMap = map.get(tenantEntry.getKey());
                if (executionPlanMap != null) {
                    ExecutionPlan executionPlan = executionPlanMap.get(executionPlanData.getKey());
                    if (executionPlan != null) {
                        executionPlan.getExecutionPlanRuntime().restore((byte[])executionPlanData.getValue());
                        continue;
                    }
                    throw new EventManagementException("No execution plans with name '" + (String)executionPlanData.getKey() + "' exist for tenant  " + tenantEntry.getKey());
                }
                throw new EventManagementException("No execution plans exist for tenant  " + tenantEntry.getKey());
            }
        }
    }

    public void pause() {
        this.readWriteLock.writeLock().lock();
    }

    public void resume() {
        this.readWriteLock.writeLock().unlock();
    }

    public ManagementModeInfo getManagementModeInfo() {
        return EventProcessorValueHolder.getEventProcessorService().getManagementInfo();
    }

    public void persist() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
            EventProcessorValueHolder.getSiddhiManager().persist();
        }
        catch (Throwable e) {
            log.error((Object)("Unable to persist state for tenant :" + this.tenantId), e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void restoreLastState() {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
            EventProcessorValueHolder.getSiddhiManager().restoreLastState();
        }
        catch (Throwable e) {
            log.error((Object)("Unable to restore state for tenant :" + this.tenantId), e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

