/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core;

import org.wso2.carbon.event.processor.core.internal.util.EventProcessorUtil;

public class StreamConfiguration {
    private String name;
    private String version;
    private String siddhiStreamName;

    public StreamConfiguration(String name, String version) {
        this.name = name;
        if (version == null) {
            this.version = "1.0.0";
            this.siddhiStreamName = name;
        } else {
            this.version = version;
            this.siddhiStreamName = "1.0.0".equals(version) ? name : name + "_" + version.replaceAll("\\.", "_");
        }
    }

    public StreamConfiguration(String name) {
        this.name = name;
        this.version = "1.0.0";
        this.siddhiStreamName = name;
    }

    public StreamConfiguration(String name, String version, String siddhiStreamName) {
        this.name = name;
        this.siddhiStreamName = siddhiStreamName;
        this.version = version == null ? "1.0.0" : version;
    }

    public String getName() {
        return this.name;
    }

    public String getStreamId() {
        return EventProcessorUtil.getStreamId(this.name, this.version);
    }

    public String getVersion() {
        return this.version;
    }

    public String getSiddhiStreamName() {
        return this.siddhiStreamName;
    }

    public void setSiddhiStreamName(String siddhiStreamName) {
        this.siddhiStreamName = siddhiStreamName;
    }
}

