/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.internal.storm.SiddhiStormOutputEventListener;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.StormStatusMapListener;
import org.wso2.carbon.event.processor.core.internal.storm.status.monitor.StormStatusMonitor;
import org.wso2.carbon.event.stream.core.EventProducer;
import org.wso2.carbon.event.stream.core.SiddhiEventConsumer;
import org.wso2.siddhi.core.ExecutionPlanRuntime;

public class ExecutionPlan {
    private ExecutionPlanRuntime executionPlanRuntime;
    private ExecutionPlanConfiguration executionPlanConfiguration;
    private String name;
    private List<EventProducer> eventProducers = new ArrayList<EventProducer>();
    private List<SiddhiEventConsumer> siddhiEventConsumers = new ArrayList<SiddhiEventConsumer>();
    private SiddhiStormOutputEventListener stormOutputListener;
    private StormStatusMonitor stormStatusMonitor;
    private StormStatusMapListener stormStatusMapListener;

    public ExecutionPlan(String name, ExecutionPlanRuntime executionPlanRuntime, ExecutionPlanConfiguration executionPlanConfiguration) {
        this.executionPlanRuntime = executionPlanRuntime;
        this.executionPlanConfiguration = executionPlanConfiguration;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExecutionPlanRuntime getExecutionPlanRuntime() {
        return this.executionPlanRuntime;
    }

    public void setExecutionPlanRuntime(ExecutionPlanRuntime executionPlanRuntime) {
        this.executionPlanRuntime = executionPlanRuntime;
    }

    public ExecutionPlanConfiguration getExecutionPlanConfiguration() {
        return this.executionPlanConfiguration;
    }

    public void setExecutionPlanConfiguration(ExecutionPlanConfiguration executionPlanConfiguration) {
        this.executionPlanConfiguration = executionPlanConfiguration;
    }

    public void setStormStatusMonitor(StormStatusMonitor stormStatusMonitor) {
        this.stormStatusMonitor = stormStatusMonitor;
    }

    public void setStormStatusMapListener(StormStatusMapListener stormStatusMapListener) {
        this.stormStatusMapListener = stormStatusMapListener;
    }

    public void shutdown() {
        if (this.stormOutputListener != null) {
            this.stormOutputListener.shutdown();
        }
        for (SiddhiEventConsumer siddhiEventConsumer : this.siddhiEventConsumers) {
            siddhiEventConsumer.shutdown();
        }
        if (this.stormStatusMonitor != null) {
            this.stormStatusMonitor.shutdown();
        }
        if (this.stormStatusMapListener != null) {
            this.stormStatusMapListener.removeEntryListener();
        }
        this.executionPlanRuntime.shutdown();
    }

    public void addProducer(EventProducer producer) {
        this.eventProducers.add(producer);
    }

    public void addConsumer(SiddhiEventConsumer eventConsumer) {
        this.siddhiEventConsumers.add(eventConsumer);
    }

    public List<EventProducer> getEventProducers() {
        return this.eventProducers;
    }

    public List<SiddhiEventConsumer> getSiddhiEventConsumers() {
        return this.siddhiEventConsumers;
    }

    public void addStormOutputListener(SiddhiStormOutputEventListener stormOutputListener) {
        this.stormOutputListener = stormOutputListener;
    }
}

