/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.processor.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.application.deployer.EventProcessingDeployer;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfigurationFile;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanConfigurationException;
import org.wso2.carbon.event.processor.core.exception.ExecutionPlanDependencyValidationException;
import org.wso2.carbon.event.processor.core.internal.CarbonEventProcessorService;
import org.wso2.carbon.event.processor.core.internal.ds.EventProcessorValueHolder;
import org.wso2.carbon.event.processor.core.internal.util.helper.EventProcessorHelper;

public class EventProcessorDeployer
extends AbstractDeployer
implements EventProcessingDeployer {
    private static Log log = LogFactory.getLog(EventProcessorDeployer.class);
    private ConfigurationContext configurationContext;
    private Set<String> deployedExecutionPlanFilePaths = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> unDeployedExecutionPlanFilePaths = Collections.newSetFromMap(new ConcurrentHashMap());

    public void init(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        EventProcessorValueHolder.addTenantConfig(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(), configurationContext);
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        block5: {
            try {
                String path = deploymentFileData.getAbsolutePath();
                if (!this.deployedExecutionPlanFilePaths.contains(path)) {
                    try {
                        this.processDeploy(deploymentFileData);
                        break block5;
                    }
                    catch (ExecutionPlanConfigurationException e) {
                        throw new DeploymentException("Execution plan not deployed properly.", (Throwable)e);
                    }
                }
                log.debug((Object)("Execution plan file is already deployed :" + path));
                this.deployedExecutionPlanFilePaths.remove(path);
            }
            catch (Throwable t) {
                log.error((Object)("Can't deploy the execution plan: " + deploymentFileData.getName()), t);
                throw new DeploymentException("Can't deploy the execution plan: " + deploymentFileData.getName(), t);
            }
        }
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String filePath) throws DeploymentException {
        try {
            if (!this.unDeployedExecutionPlanFilePaths.contains(filePath)) {
                this.processUndeploy(filePath);
            } else {
                log.debug((Object)("Execution plan file is already undeployed :" + filePath));
                this.unDeployedExecutionPlanFilePaths.remove(filePath);
            }
        }
        catch (Throwable t) {
            log.error((Object)("Can't undeploy the execution plan: " + filePath), t);
            throw new DeploymentException("Can't undeploy the execution plan: " + filePath, t);
        }
    }

    public synchronized void processDeploy(DeploymentFileData deploymentFileData) throws ExecutionPlanConfigurationException {
        CarbonEventProcessorService carbonEventProcessorService = EventProcessorValueHolder.getEventProcessorService();
        File executionPlanFile = deploymentFileData.getFile();
        boolean isEditable = !executionPlanFile.getAbsolutePath().contains(File.separator + "carbonapps" + File.separator);
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        ExecutionPlanConfigurationFile executionPlanConfigurationFile = new ExecutionPlanConfigurationFile();
        if (!carbonEventProcessorService.isExecutionPlanFileAlreadyExist(executionPlanFile.getName())) {
            String executionPlanName = "";
            try {
                String executionPlan = this.readFile(deploymentFileData.getAbsolutePath());
                EventProcessorHelper.validateExecutionPlan(executionPlan);
                executionPlanName = EventProcessorHelper.getExecutionPlanName(executionPlan);
                carbonEventProcessorService.addExecutionPlan(executionPlan, isEditable);
                executionPlanConfigurationFile.setStatus(ExecutionPlanConfigurationFile.Status.DEPLOYED);
                executionPlanConfigurationFile.setExecutionPlanName(executionPlanName);
                executionPlanConfigurationFile.setFileName(deploymentFileData.getName());
                executionPlanConfigurationFile.setFilePath(deploymentFileData.getAbsolutePath());
                carbonEventProcessorService.addExecutionPlanConfigurationFile(executionPlanConfigurationFile);
                log.info((Object)("Execution plan is deployed successfully and in active state  : " + executionPlanName));
            }
            catch (ExecutionPlanDependencyValidationException ex) {
                executionPlanConfigurationFile.setDependency(ex.getDependency());
                executionPlanConfigurationFile.setDeploymentStatusMessage(ex.getMessage());
                executionPlanConfigurationFile.setStatus(ExecutionPlanConfigurationFile.Status.WAITING_FOR_DEPENDENCY);
                executionPlanConfigurationFile.setExecutionPlanName(executionPlanName);
                executionPlanConfigurationFile.setFileName(deploymentFileData.getName());
                executionPlanConfigurationFile.setFilePath(deploymentFileData.getAbsolutePath());
                carbonEventProcessorService.addExecutionPlanConfigurationFile(executionPlanConfigurationFile);
                log.info((Object)("Execution plan deployment held back and in inactive state : " + executionPlanConfigurationFile.getFileName() + ", Dependency validation exception: " + ex.getMessage()));
            }
            catch (Exception ex) {
                if (isEditable) {
                    executionPlanConfigurationFile.setDeploymentStatusMessage(ex.getMessage());
                    executionPlanConfigurationFile.setStatus(ExecutionPlanConfigurationFile.Status.ERROR);
                    executionPlanConfigurationFile.setExecutionPlanName(executionPlanName);
                    executionPlanConfigurationFile.setFileName(deploymentFileData.getName());
                    executionPlanConfigurationFile.setFilePath(deploymentFileData.getAbsolutePath());
                    carbonEventProcessorService.addExecutionPlanConfigurationFile(executionPlanConfigurationFile);
                    log.error((Object)("Execution plan is not deployed and in inactive state : " + executionPlanFile.getName()), (Throwable)ex);
                }
                throw new ExecutionPlanConfigurationException(ex.getMessage(), ex);
            }
        } else {
            throw new ExecutionPlanConfigurationException("Execution plan " + executionPlanFile.getName() + " is already registered with this tenant (" + tenantId + ")");
        }
    }

    public synchronized void processUndeploy(String filePath) {
        String fileName = new File(filePath).getName();
        log.info((Object)("Execution Plan was undeployed successfully : " + fileName));
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        CarbonEventProcessorService carbonEventProcessorService = EventProcessorValueHolder.getEventProcessorService();
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        carbonEventProcessorService.removeExecutionPlanConfigurationFile(fileName);
    }

    public void setDirectory(String directory) {
    }

    public void executeManualDeployment(String filePath) throws DeploymentException, ExecutionPlanConfigurationException {
        this.processDeploy(new DeploymentFileData(new File(filePath)));
    }

    public void executeManualUndeployment(String filePath) {
        this.processUndeploy(filePath);
    }

    private String readFile(String path) throws ExecutionPlanConfigurationException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(path));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new ExecutionPlanConfigurationException("File '" + path + "' not found." + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ExecutionPlanConfigurationException("Could not read from file " + path + ", " + e.getMessage(), e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                throw new ExecutionPlanConfigurationException("Could not close the file " + path + ", " + e.getMessage(), e);
            }
        }
    }

    public Set<String> getDeployedExecutionPlanFilePaths() {
        return this.deployedExecutionPlanFilePaths;
    }

    public Set<String> getUnDeployedExecutionPlanFilePaths() {
        return this.unDeployedExecutionPlanFilePaths;
    }

    public void processDeployment(DeploymentFileData deploymentFileData) throws Exception {
        this.processDeploy(deploymentFileData);
    }

    public void processUndeployment(String filePath) throws Exception {
        this.processUndeploy(filePath);
    }
}

