/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tenant.mgt.core;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.stratos.common.config.CloudServiceConfigParser;
import org.wso2.carbon.stratos.common.config.CloudServicesDescConfig;
import org.wso2.carbon.stratos.common.constants.TenantConstants;
import org.wso2.carbon.stratos.common.exception.TenantManagementClientException;
import org.wso2.carbon.stratos.common.exception.TenantManagementServerException;
import org.wso2.carbon.stratos.common.exception.TenantMgtException;
import org.wso2.carbon.stratos.common.util.CloudServicesUtil;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.tenant.mgt.core.internal.TenantMgtCoreServiceComponent;
import org.wso2.carbon.tenant.mgt.core.util.TenantCoreUtil;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class TenantPersistor {
    private static final Log log = LogFactory.getLog(TenantPersistor.class);
    private static CloudServicesDescConfig cloudServicesDesc = null;
    private static final String ADD_ADMIN_TRUE = "true";

    public int persistTenant(org.wso2.carbon.user.core.tenant.Tenant tenant, boolean checkDomainValidation, String successKey, String originatedService, boolean isSkeleton) throws Exception {
        int tenantId = 0;
        tenantId = !isSkeleton ? this.persistTenantInUserStore(tenant, checkDomainValidation, successKey) : tenant.getId();
        try {
            this.doPostTenantCreationActions(tenant, originatedService);
        }
        catch (Exception e) {
            String msg = "Error performing post tenant creation actions";
            throw new Exception(msg, e);
        }
        return tenantId;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int persistTenantInUserStore(org.wso2.carbon.user.core.tenant.Tenant tenant, boolean checkDomainValidation, String successKey) throws Exception {
        this.validateAdminUserName(tenant);
        String tenantDomain = tenant.getDomain();
        boolean isDomainAvailable = CommonUtil.isDomainNameAvailable((String)tenantDomain);
        if (!isDomainAvailable) {
            throw new Exception("Domain is not available to register");
        }
        RealmService realmService = TenantMgtCoreServiceComponent.getRealmService();
        RealmConfiguration realmConfig = realmService.getBootstrapRealmConfiguration();
        TenantMgtConfiguration tenantMgtConfiguration = realmService.getTenantMgtConfiguration();
        MultiTenantRealmConfigBuilder builder = TenantMgtCoreServiceComponent.getRealmService().getMultiTenantRealmConfigBuilder();
        RealmConfiguration realmConfigToPersist = builder.getRealmConfigForTenantToPersist(realmConfig, tenantMgtConfiguration, tenant, -1);
        tenant.setRealmConfig(realmConfigToPersist);
        realmService.getBootstrapRealm().getRealmConfiguration().setAddAdmin(ADD_ADMIN_TRUE);
        int tenantId = this.addTenant(tenant);
        tenant.setId(tenantId);
        if (checkDomainValidation) {
            if (successKey != null) {
                if (!CommonUtil.validateDomainFromSuccessKey((UserRegistry)TenantMgtCoreServiceComponent.getGovernanceSystemRegistry(-1234), (String)tenant.getDomain(), (String)successKey)) {
                    String msg = "Failed to validate domain";
                    throw new Exception(msg);
                }
                this.storeDomainValidationFlagToRegistry(tenant);
            }
        } else {
            this.storeDomainValidationFlagToRegistry(tenant);
        }
        this.addTenantAdminUser(tenant);
        return tenantId;
    }

    private void doPostTenantCreationActions(org.wso2.carbon.user.core.tenant.Tenant tenant, String originatedService) throws TenantManagementServerException {
        try {
            TenantMgtCoreServiceComponent.getRegistryLoader().loadTenantRegistry(tenant.getId());
            this.copyUIPermissions(tenant.getId());
            TenantCoreUtil.setOriginatedService(tenant.getId(), originatedService);
            this.setActivationFlags(tenant.getId(), originatedService);
        }
        catch (Exception ex) {
            throw new TenantManagementServerException("Error performing post tenant creation actions.", ex);
        }
        TenantCoreUtil.initializeRegistry(tenant.getId());
    }

    protected void storeDomainValidationFlagToRegistry(org.wso2.carbon.user.core.tenant.Tenant tenant) throws RegistryException {
        try {
            String domainValidationPath = "/repository/components/org.wso2.carbon.domain-confirmation-flag/" + tenant.getId();
            UserRegistry superTenantRegistry = TenantMgtCoreServiceComponent.getGovernanceSystemRegistry(-1234);
            Resource validationFlagR = superTenantRegistry.newResource();
            validationFlagR.setProperty(tenant.getDomain(), ADD_ADMIN_TRUE);
            superTenantRegistry.put(domainValidationPath, validationFlagR);
        }
        catch (RegistryException e) {
            String msg = "Error in storing the domain validation flag to the registry";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Domain Validation Flag is stored to the registry.");
        }
    }

    private int addTenant(org.wso2.carbon.user.core.tenant.Tenant tenant) throws TenantMgtException {
        int tenantId;
        TenantManager tenantManager = TenantMgtCoreServiceComponent.getTenantManager();
        try {
            if (StringUtils.isBlank((String)tenant.getAdminName())) {
                throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_MISSING_REQUIRED_PARAMETER.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_MISSING_REQUIRED_PARAMETER.getMessage(), "owner name"));
            }
            if (StringUtils.isBlank((String)tenant.getDomain())) {
                throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_MISSING_REQUIRED_PARAMETER.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_MISSING_REQUIRED_PARAMETER.getMessage(), "tenant domain"));
            }
            tenantId = tenantManager.addTenant((Tenant)tenant);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant is successfully added: " + tenant.getDomain()));
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String msg = "Error in adding tenant with domain: " + tenant.getDomain();
            log.error((Object)msg, (Throwable)e);
            throw new TenantManagementServerException(msg, (Exception)((Object)e));
        }
        return tenantId;
    }

    private void addTenantAdminUser(org.wso2.carbon.user.core.tenant.Tenant tenant) throws Exception {
        RealmService realmService = TenantMgtCoreServiceComponent.getRealmService();
        realmService.getTenantManager().getTenant(tenant.getId()).getRealmConfig().setAdminPassword(tenant.getAdminPassword());
        realmService.getTenantUserRealm(tenant.getId());
    }

    protected void copyUIPermissions(int tenantId) throws Exception {
        try {
            UserRealm realm = (UserRealm)TenantMgtCoreServiceComponent.getRealmService().getTenantUserRealm(tenantId);
            String adminRole = realm.getRealmConfiguration().getAdminRoleName();
            AuthorizationManager authMan = realm.getAuthorizationManager();
            if (!authMan.isRoleAuthorized(adminRole, "/permission/admin", "ui.execute")) {
                authMan.authorizeRole(adminRole, "/permission/admin", "ui.execute");
            }
        }
        catch (UserStoreException e) {
            String msg = "Error in authorizing the admin role.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Role has successfully been authorized.");
        }
    }

    protected void setActivationFlags(int tenantId, String originalService) throws Exception {
        boolean useDefaultConfig = true;
        try {
            if (cloudServicesDesc == null) {
                cloudServicesDesc = CloudServiceConfigParser.loadCloudServicesConfiguration();
            }
            if (originalService != null && !originalService.equals("WSO2 Stratos Manager")) {
                CloudServicesUtil.activateOriginalAndCompulsoryServices((CloudServicesDescConfig)cloudServicesDesc, (String)originalService, (int)tenantId);
                useDefaultConfig = false;
            }
            if (useDefaultConfig) {
                CloudServicesUtil.activateAllServices((CloudServicesDescConfig)cloudServicesDesc, (int)tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error registering the originated service", (Throwable)e);
            throw e;
        }
    }

    private void validateAdminUserName(org.wso2.carbon.user.core.tenant.Tenant tenant) throws TenantMgtException {
        UserRealm superTenantUserRealm;
        try {
            superTenantUserRealm = TenantMgtCoreServiceComponent.getRealmService().getBootstrapRealm();
        }
        catch (UserStoreException e) {
            String msg = "Error while getting bootstrapRealm";
            throw new TenantManagementServerException(msg, (Exception)((Object)e));
        }
        RealmConfiguration realmConfig = TenantMgtCoreServiceComponent.getBootstrapRealmConfiguration();
        String uniqueAcrossTenants = realmConfig.getUserStoreProperty("UserNameUniqueAcrossTenants");
        if (ADD_ADMIN_TRUE.equals(uniqueAcrossTenants)) {
            try {
                String adminName = tenant.getAdminName();
                if (superTenantUserRealm.getUserStoreManager().isExistingUser(adminName)) {
                    throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_EXISTING_USER_NAME.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_EXISTING_USER_NAME.getMessage(), adminName));
                }
            }
            catch (UserStoreException e) {
                String msg = "Error in checking whether the user already exists in the system";
                throw new TenantManagementServerException(msg, (Exception)((Object)e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Admin User Name has been validated.");
        }
    }

    public int persistTenant(org.wso2.carbon.user.core.tenant.Tenant tenant) throws Exception {
        this.validateAdminUserName(tenant);
        String tenantDomain = tenant.getDomain();
        boolean isDomainAvailable = CommonUtil.isDomainNameAvailable((String)tenantDomain);
        if (!isDomainAvailable) {
            throw new TenantManagementClientException(TenantConstants.ErrorMessage.ERROR_CODE_EXISTING_DOMAIN.getCode(), String.format(TenantConstants.ErrorMessage.ERROR_CODE_EXISTING_DOMAIN.getMessage(), tenantDomain));
        }
        int tenantId = this.addTenant(tenant);
        tenant.setId(tenantId);
        TenantMgtCoreServiceComponent.getRealmService().getTenantManager().getTenant(tenantId).getRealmConfig().setAdminPassword(tenant.getAdminPassword());
        this.doPostTenantCreationActions(tenant, null);
        return tenantId;
    }
}

