/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.export.core.internal.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.user.export.core.UserExportException;
import org.wso2.carbon.identity.user.export.core.dto.UserInformationDTO;
import org.wso2.carbon.identity.user.export.core.service.UserInformationProvider;
import org.wso2.carbon.identity.user.export.core.service.UserInformationService;

@Component(name="org.wso2.carbon.user.export.service", immediate=true)
public class UserInformationServiceImpl
implements UserInformationService {
    private List<UserInformationProvider> userInformationProviders = new ArrayList<UserInformationProvider>();

    @Override
    public Map<String, Object> getRetainedUserInformation(String username, String userStoreDomain, int tenantId) throws UserExportException {
        HashMap<String, Object> userInformation = new HashMap<String, Object>();
        for (UserInformationProvider userInformationProvider : this.userInformationProviders) {
            UserInformationDTO retainedUserInformation;
            if (!userInformationProvider.isEnabled() || (retainedUserInformation = userInformationProvider.getRetainedUserInformation(username, userStoreDomain, tenantId)) == null || !retainedUserInformation.isInformationAvailable()) continue;
            String type = userInformationProvider.getType();
            userInformation.put(type, retainedUserInformation.getData());
        }
        return userInformation;
    }

    @Reference(name="user.export.attribute.provider", service=UserInformationProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserAttributeProvider")
    public void setUserAttributeProvider(UserInformationProvider userInformationProvider) {
        this.userInformationProviders.add(userInformationProvider);
    }

    public void unsetUserAttributeProvider(UserInformationProvider userInformationProvider) {
        this.userInformationProviders.remove(userInformationProvider);
    }
}

