/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.export.core.internal.service.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.user.export.core.UserExportException;
import org.wso2.carbon.identity.user.export.core.dto.SecurityInformationDTO;
import org.wso2.carbon.identity.user.export.core.dto.UserInformationDTO;
import org.wso2.carbon.identity.user.export.core.internal.service.impl.BasicUserInformationProvider;
import org.wso2.carbon.identity.user.export.core.service.UserInformationProvider;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.user.export.security", immediate=true, service={UserInformationProvider.class})
public class SecurityInformationProvider
extends BasicUserInformationProvider {
    private static final Log log = LogFactory.getLog(SecurityInformationProvider.class);

    @Override
    public UserInformationDTO getRetainedUserInformation(String username, String userStoreDomain, int tenantId) throws UserExportException {
        String challengeQuestionClaimValue;
        UserStoreManager userStoreManager;
        try {
            userStoreManager = this.getUserStoreManager(tenantId, userStoreDomain);
            challengeQuestionClaimValue = userStoreManager.getUserClaimValue(username, "http://wso2.org/claims/challengeQuestionUris", null);
        }
        catch (UserStoreException e) {
            throw new UserExportException("Error while retrieving the user information.", e);
        }
        if (challengeQuestionClaimValue != null) {
            List<String> challengeQuestionUris = this.getChallengeQuestionUris(challengeQuestionClaimValue);
            SecurityInformationDTO securityInformationDTO = new SecurityInformationDTO();
            if (challengeQuestionUris.size() > 0) {
                Map challengeQuestions;
                try {
                    challengeQuestions = userStoreManager.getUserClaimValues(username, challengeQuestionUris.toArray(new String[challengeQuestionUris.size()]), null);
                }
                catch (UserStoreException e) {
                    throw new UserExportException("Error while retrieving the user information.", e);
                }
                String challengeQuestionSeparator = this.challengeQuestionSeparator();
                for (Map.Entry challengeQuestion : challengeQuestions.entrySet()) {
                    String[] challengeQuestionsParts = ((String)challengeQuestion.getValue()).split(challengeQuestionSeparator);
                    securityInformationDTO.addChallengeQuestion(challengeQuestionsParts[0]);
                }
            }
            return new UserInformationDTO(securityInformationDTO);
        }
        return new UserInformationDTO();
    }

    @Override
    public String getType() {
        return "security";
    }

    @Override
    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    public void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        this.realmService = realmService;
    }

    @Override
    public void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service");
        }
        this.realmService = null;
    }

    @Override
    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    public void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService is set in the org.wso2.carbon.user.export.security component");
        }
        this.registryService = registryService;
    }

    @Override
    public void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService is unset in the org.wso2.carbon.user.export.security component");
        }
        this.registryService = null;
    }
}

