/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.user.export.core.internal.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.Receipt;
import org.wso2.carbon.consent.mgt.core.model.ReceiptListResponse;
import org.wso2.carbon.identity.user.export.core.UserExportException;
import org.wso2.carbon.identity.user.export.core.dto.ConsentReceiptDTO;
import org.wso2.carbon.identity.user.export.core.dto.UserInformationDTO;
import org.wso2.carbon.identity.user.export.core.internal.service.impl.AbstractUserInformationProvider;
import org.wso2.carbon.identity.user.export.core.service.UserInformationProvider;
import org.wso2.carbon.identity.user.export.core.utils.Utils;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

@Component(name="org.wso2.carbon.user.export.consent", immediate=true, service={UserInformationProvider.class})
public class ConsentInformationProvider
extends AbstractUserInformationProvider {
    private static final Log log = LogFactory.getLog(ConsentInformationProvider.class);
    private ConsentManager consentManager;
    private RealmService realmService;

    @Override
    public UserInformationDTO getRetainedUserInformation(String username, String userStoreDomain, int tenantId) throws UserExportException {
        try {
            List receiptListResponses;
            ArrayList<ConsentReceiptDTO> receipts = new ArrayList<ConsentReceiptDTO>();
            int limit = 100;
            int offset = 0;
            String tenantDomain = this.realmService.getTenantManager().getDomain(tenantId);
            do {
                receiptListResponses = this.consentManager.searchReceipts(limit, offset, UserCoreUtil.addDomainToName((String)username, (String)userStoreDomain), tenantDomain, null, "ACTIVE");
                for (ReceiptListResponse receiptListResponse : receiptListResponses) {
                    String receiptId = receiptListResponse.getConsentReceiptId();
                    Receipt receipt = this.consentManager.getReceipt(receiptId);
                    receipts.add(Utils.getConsentReceiptDTO(receipt));
                }
                offset += limit;
            } while (receiptListResponses != null && receiptListResponses.size() != 0);
            if (receipts.size() > 0) {
                return new UserInformationDTO(receipts);
            }
        }
        catch (UserStoreException e) {
            throw new UserExportException("Error while retrieving tenant domain from tenant id: " + tenantId, e);
        }
        catch (ConsentManagementException e) {
            throw new UserExportException("Error while retrieving consent receipts for user: " + UserCoreUtil.addDomainToName((String)username, (String)userStoreDomain) + " in tenant id: " + tenantId, e);
        }
        return new UserInformationDTO();
    }

    @Override
    public String getType() {
        return "consents";
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    public void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service");
        }
        this.realmService = realmService;
    }

    public void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Realm Service");
        }
        this.realmService = null;
    }

    @Reference(name="consent.manager", service=ConsentManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentManager")
    public void setConsentManager(ConsentManager consentManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the ConsentManager Service");
        }
        this.consentManager = consentManager;
    }

    public void unsetConsentManager(ConsentManager consentManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the ConsentManager Service");
        }
        this.consentManager = null;
    }
}

