/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.notification.internal;

import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.impl.handlers.EventHandler;
import org.wso2.carbon.apimgt.impl.keymgt.KeyManagerEventHandler;
import org.wso2.carbon.apimgt.notification.DefaultKeyManagerEventHandlerImpl;
import org.wso2.carbon.apimgt.notification.NotificationEventService;
import org.wso2.carbon.apimgt.notification.WebhooksDeliveryEventHandler;
import org.wso2.carbon.apimgt.notification.WebhooksSubscriptionEventHandler;
import org.wso2.carbon.apimgt.notification.internal.ServiceReferenceHolder;
import org.wso2.carbon.event.stream.core.EventStreamService;

@Component(name="apim.notification.component", immediate=true)
public class ApimgtNotificationServiceComponent {
    @Activate
    protected void activate(ComponentContext ctxt) {
        ctxt.getBundleContext().registerService(KeyManagerEventHandler.class, (Object)new DefaultKeyManagerEventHandlerImpl(), null);
        ctxt.getBundleContext().registerService(EventHandler.class, (Object)new WebhooksSubscriptionEventHandler(), null);
        ctxt.getBundleContext().registerService(EventHandler.class, (Object)new WebhooksDeliveryEventHandler(), null);
        ctxt.getBundleContext().registerService(NotificationEventService.class, (Object)new NotificationEventService(), null);
    }

    @Reference(name="keymgt.event.handlers", service=KeyManagerEventHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeKeyManagerEventHandlers")
    protected void addKeyManagerEventHandlers(KeyManagerEventHandler keyManagerEventHandler) {
        ServiceReferenceHolder.getInstance().addEventHandler(keyManagerEventHandler.getType(), (EventHandler)keyManagerEventHandler);
    }

    protected void removeKeyManagerEventHandlers(KeyManagerEventHandler keyManagerEventHandler) {
        ServiceReferenceHolder.getInstance().removeEventHandlers(keyManagerEventHandler.getType());
    }

    @Reference(name="event.handlers", service=EventHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeEventHandlers")
    protected void addEventHandlers(EventHandler eventHandler) {
        ServiceReferenceHolder.getInstance().addEventHandler(eventHandler.getType(), eventHandler);
    }

    protected void removeEventHandlers(EventHandler eventHandler) {
        ServiceReferenceHolder.getInstance().removeEventHandlers(eventHandler.getType());
    }

    @Reference(name="apimgt.event.stream.service.reference", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        ServiceReferenceHolder.getInstance().setEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        ServiceReferenceHolder.getInstance().setEventStreamService(null);
    }

    @Reference(name="api.manager.config.service", service=APIManagerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAPIManagerConfigurationService")
    protected void setAPIManagerConfigurationService(APIManagerConfigurationService amcService) {
        ServiceReferenceHolder.getInstance().setAPIManagerConfigurationService(amcService);
    }

    protected void unsetAPIManagerConfigurationService(APIManagerConfigurationService amcService) {
        ServiceReferenceHolder.getInstance().setAPIManagerConfigurationService(null);
    }
}

